/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CONSENSUS_SELECTOR_DIALOG_CONTROLLER_H_
#define _GB2_CONSENSUS_SELECTOR_DIALOG_CONTROLLER_H_

#include "ui/ui_ConsensusSelectorDialog.h"

#include <core_api/core_api.h>
#include <util_msa_consensus/MSAConsensusAlgorithm.h>

namespace GB2{

class GB2_COREAPI_EXPORT ConsensusSelectorDialogController : public QDialog, Ui_ConsensusSelectorDialog { 
	Q_OBJECT
public:
	ConsensusSelectorDialogController(const QString& selectedAlgorithmId, ConsensusAlgorithmFlags flags, QWidget *p = NULL);

    const QString& getSelectedAlgorithmId() const {return selectedAlgorithmId;}

    // enables threshold selector group, sets threshold range to 'r' 
    // and current value for slider and spin box to 'value'
    void enableThresholdSelector(const LRegion& r, int value, const QString& suffix);
    
    // disables threshold selector group
    void disableThresholdSelector();
    
    int getThresholdValue() const;

signals:
	void si_algorithmChanged(const QString& algoId);
    
    void si_thresholdChanged(int val);

private slots:
	void sl_algorithmSelectionChanged(int);
    void sl_thresholdSliderChanged(int);
    void sl_thresholdSpinChanged(int);
    void sl_resetThresholdClicked(bool);

private:
	void updateSelectedAlgorithmDesc();
	
    QString selectedAlgorithmId;
};

}

#endif
