/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "MSAEditorState.h"
#include "MSAEditor.h"
#include "MSAEditorFactory.h"

#include <core_api/DocumentModel.h>
#include <gobjects/AnnotationTableObject.h>
#include <gobjects/MAlignmentObject.h>
#include <selection/DNASequenceSelection.h>

namespace GB2 {


#define VIEW_ID		QString("view_id")
#define MSA_OBJ		QString("msa_obj_ref")
#define X_POS       QString("x_pos")
#define Y_POS       QString("y_pos")

bool MSAEditorState::isValid() const {
	return stateData.value(VIEW_ID) == MSAEditorFactory::ID;
}

GObjectReference MSAEditorState::getMSAObject() const {
	return stateData.contains(MSA_OBJ) ? stateData[MSA_OBJ].value<GObjectReference>() : GObjectReference();
}

void MSAEditorState::setMSAObject(const GObjectReference& ref) {
    stateData[MSA_OBJ] = QVariant::fromValue<GObjectReference>(ref);
}


int MSAEditorState::getX() const {
	QVariant v = stateData.value(X_POS);
    if (v.type() == QVariant::Int) {
        return v.toInt();
    }
    return 0;
}

void MSAEditorState::setX(int x) {
    stateData[X_POS] = x;
}

int MSAEditorState::getY() const {
    QVariant v = stateData.value(Y_POS);
    if (v.type() == QVariant::Int) {
        return v.toInt();
    }
    return 0;
}

void MSAEditorState::setY(int y) {
    stateData[Y_POS] = y;
}


QVariantMap MSAEditorState::saveState(MSAEditor* v) {
	MSAEditorState ss;

    ss.stateData[VIEW_ID]=MSAEditorFactory::ID;

	MAlignmentObject* msaObj = v->getMSAObject();
    if (msaObj)
    	ss.setMSAObject(GObjectReference(msaObj));
	ss.setX(0);
	ss.setY(0);
	
	return ss.stateData;
}



} // namespace

