/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "GraphicsButtonItem.h"
#include "GraphicsBranchItem.h"
#include <QtGui/QPainter>
#include <QtGui/QPen>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtCore/QList>
#include <QtGui/QMenu>
#include <assert.h>
#include <QGraphicsScene>

namespace GB2 {

const qreal GraphicsButtonItem::min_radius = 2.0;
const qreal GraphicsButtonItem::max_radius = 4.5;

GraphicsButtonItem::GraphicsButtonItem(): mouse(false), selected(false) {
    setPen(QColor(0, 0, 0));
    setBrush(Qt::gray);
    setAcceptHoverEvents(true);
    setZValue(2);
}

QRectF GraphicsButtonItem::boundingRect() const {
    return QRectF(-max_radius, -max_radius, 2 * max_radius, 2 * max_radius);
}

QPainterPath GraphicsButtonItem::shape() const {
    QPainterPath path;
    path.addEllipse(boundingRect());
    return path;
}

void GraphicsButtonItem::paint(QPainter *painter, const QStyleOptionGraphicsItem*, QWidget*) {
    painter->setPen(pen());
    painter->setBrush(brush());
    painter->drawEllipse(QPointF(0, 0), mouse || selected ? max_radius : min_radius, mouse || selected ? max_radius : min_radius);
}

void GraphicsButtonItem::hoverEnterEvent(QGraphicsSceneHoverEvent *e) {
    mouse = true;
    QAbstractGraphicsShapeItem::hoverEnterEvent(e);
}

void GraphicsButtonItem::hoverLeaveEvent(QGraphicsSceneHoverEvent *e) {
    mouse = false;
    QAbstractGraphicsShapeItem::hoverLeaveEvent(e);
}

void GraphicsButtonItem::mousePressEvent(QGraphicsSceneMouseEvent *e) {
    GraphicsBranchItem *p = dynamic_cast<GraphicsBranchItem*>(parentItem());
    assert(p);
    if (p)
        p->setSelected(true);
    e->accept();
}

void GraphicsButtonItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *e) {
    collapse();
    QAbstractGraphicsShapeItem::mouseDoubleClickEvent(e);
}

void GraphicsButtonItem::collapse() {
    GraphicsBranchItem *p = dynamic_cast<GraphicsBranchItem*>(parentItem());
    assert(p);
    if (p) {
        p->collapse();
    }
}

void GraphicsButtonItem::setSelected(bool sel) {
    if (sel != selected) {
        setBrush(sel ? QColor(0, 0, 255) : Qt::gray);
        selected = sel;
    }
}

}//namespace
