/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "GraphicsCircularBranchItem.h"
#include "GraphicsRectangularBranchItem.h"
#include "GraphicsButtonItem.h"
#include "TreeViewerUtils.h"

#include <QtGui/QPainter>
#include <QtGui/QPen>
#include <QtCore/QStack>
#include <QtGui/QGraphicsScene>
#include <QtGui/QGraphicsView>
#include <gobjects/PhyTreeObject.h>
#include <core_api/AppContext.h>
#include <qmath.h>

namespace GB2 {

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

GraphicsCircularBranchItem::GraphicsCircularBranchItem(QGraphicsItem* parent, qreal h, GraphicsRectangularBranchItem* from)
: GraphicsBranchItem(true), height(h), direction(from->getDirection()), visible(true) {
    setParentItem(parent);
    qreal w = from->getWidth();
    setWidthW(w);
    setPos(w, 0);
    QPointF p = mapFromScene(0, 0);
    setTransform(QTransform().translate(p.x(), p.y()).rotate((direction == GraphicsBranchItem::up ? -1 : 1) * h / M_PI * 180).translate(-p.x(), -p.y()));
//    setTransformOriginPoint(mapFromScene(0, 0));
//    setRotation((direction == GraphicsBranchItem::up ? -1 : 1) * h / M_PI * 180);

    QPen pen1;
    pen1.setCosmetic(true);
    if (from->getNameText() != NULL) {
        nameText = new QGraphicsSimpleTextItem(from->getNameText()->text(), this);
        QRectF rect = nameText->boundingRect();
        qreal h = rect.height();
        nameText->setPos(GraphicsBranchItem::TEXT_SPACE, -h * 0.5);
        if (nameText->scenePos().x() < 0.0) {
            QPointF p = rect.center();
            nameText->setTransform(QTransform().translate(p.x(), p.y()).rotate(180).translate(-p.x(), -p.y()));
//            nameText->setTransformOriginPoint(rect.center());
//            nameText->setRotation(180);
        }

        pen1.setStyle(Qt::DotLine);
        pen1.setColor(Qt::darkGray);
        QBrush brush1 = nameText->brush();
        brush1.setColor(Qt::darkGray);
        nameText->setBrush(brush1);
    }
    if (from->getDistanceText() != NULL) {
        distanceText = new QGraphicsSimpleTextItem(from->getDistanceText()->text(), this);
        QRectF rect = distanceText->boundingRect();
        if (distanceText->scenePos().x() < 0) {
            QPointF p(rect.center().x(), rect.height());
            distanceText->setTransform(QTransform().translate(p.x(), p.y()).rotate(180).translate(-p.x(), -p.y()));
//            distanceText->setTransformOriginPoint(rect.center().x(), rect.height());
//            distanceText->setRotation(180);
        }
        distanceText->setPos(-0.5 * (w + rect.width()), -rect.height());

        QBrush brush1 = distanceText->brush();
        brush1.setColor(Qt::darkGray);
        distanceText->setBrush(brush1);
    }
    setPen(pen1);
}

QRectF GraphicsCircularBranchItem::boundingRect() const {
    QPointF p = scenePos();
    qreal rad = qSqrt(p.x() * p.x() + p.y() * p.y());
    qreal w = width + rad * (1 - qCos(height));
    qreal h = rad * qSin(height);
    return QRectF(-w, direction == GraphicsBranchItem::up ? 0 : -h, w, h);
}

void GraphicsCircularBranchItem::paint(QPainter *painter, const QStyleOptionGraphicsItem*, QWidget*) {
    if (!visible)
        return;
    painter->setPen(pen());
    QPointF p = scenePos();
    qreal rad = qSqrt(p.x() * p.x() + p.y() * p.y()) - width;
    QRectF rect(-2 * rad - width, -rad, 2 * rad, 2 * rad);
    painter->drawArc(rect, 0, (direction == GraphicsBranchItem::up ? -1 : 1) * height * 16 * 180 / M_PI);
    painter->drawLine(0, 0, -width, 0);
}

}//namespace
