/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TREE_VIEWER_H_
#define _GB2_TREE_VIEWER_H_

#include <QtGui/QGraphicsView>
#include <QtGui/QToolBar>
#include <QtGui/QToolButton>
#include <QtGui/QScrollBar>
#include <QtCore/QMap>
#include <datatype/MAlignment.h>
#include <gobjects/MAlignmentObject.h>
#include <gobjects/PhyTreeObject.h>
#include <datatype/PhyTree.h>
#include <core_api/Task.h>
#include <phyltree/PhyTreeGeneratorTask.h>
#include <phyltree/CreatePhyTreeSettings.h>
#include <core_api/ObjectViewModel.h>

namespace GB2 {

class GObjectView;
class TreeViewerUI;
class GraphicsBranchItem;
class GraphicsButtonItem;
class GraphicsRectangularBranchItem;
class CreateBranchesTask;

class TreeViewer: public GObjectView {
    Q_OBJECT
public:
    TreeViewer(const QString& viewName, GObject* obj, GraphicsRectangularBranchItem* root, qreal scale);

    void createActions();
    virtual void buildStaticToolbar(QToolBar* tb);

    const QAction* getPrintAction() const { return printAction; }
    const QAction* getContAction() const { return contAction; }
    const QAction* getNameLabelsAction() const { return nameLabelsAction; }
    const QAction* getDistanceLabelsAction() const { return distanceLabelsAction; }
    const QAction* getCaptureTreeAction() const { return captureTreeAction; }
    const QAction* getExportAction() const { return exportAction; }
    const QAction* getRectangularLayoutAction() const { return rectangularLayoutAction; }
    const QAction* getCircularLayoutAction() const { return circularLayoutAction; }
    const QAction* getUnrootedLayoutAction() const { return unrootedLayoutAction; }

    PhyTreeObject* getPhyObject() const { return phyObject; }
    GraphicsRectangularBranchItem* getRoot() const { return root; }
    qreal getScale() const { return scale; }

protected:
    virtual QWidget* createWidget();

private:
    QAction*            printAction;
    QAction*            contAction;
    QAction*            nameLabelsAction;
    QAction*            distanceLabelsAction;
    QAction*            captureTreeAction;
    QAction*            exportAction;
    QAction*            rectangularLayoutAction;
    QAction*            circularLayoutAction;
    QAction*            unrootedLayoutAction;
    QMenu*              labelsMenu;
    QMenu*              captureMenu;
    QMenu*              layoutMenu;

    TreeViewerUI*       ui;
    QByteArray          state;
    PhyTreeObject*      phyObject;
    GraphicsRectangularBranchItem* root;
    qreal               scale;
};

class TreeViewerUI: public QGraphicsView {
    Q_OBJECT

public:
    TreeViewerUI(TreeViewer* treeViewer);
    ~TreeViewerUI();

    static const qreal ZOOM_COEF;
    static const qreal MINIMUM_ZOOM;
    static const qreal MAXIMUM_ZOOM;
    static const int MARGIN;

protected:
    virtual void wheelEvent(QWheelEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);

private slots:
    void sl_printTriggered();
    void sl_captureTreeTriggered();
    void sl_contTriggered(bool on);
    void sl_exportTriggered();
    void sl_showNameLabelsTriggered(bool on);
    void sl_showDistanceLabelsTriggered(bool on);
    void sl_rectangularLayoutTriggered();
    void sl_circularLayoutTriggered();
    void sl_unrootedLayoutTriggered();
    void sl_layoutRecomputed();
    void sl_chrootTriggered();
    void sl_swapTriggered();
    void sl_zoomTriggered();
    void sl_collapseTriggered();

private:
    enum TreeLayout {
        TreeLayout_Rectangular,
        TreeLayout_Circular,
        TreeLayout_Unrooted,
    };
    enum LabelType {
        LabelType_SequnceName = 1,
        LabelType_Distance = 2,
    };
    typedef QFlags<LabelType> LabelTypes;

    void updateRect();
    void paint(QPainter &painter);
    void showLabels(LabelTypes labelTypes);
    void addLegend(qreal scale);

    PhyTreeObject*      phyObject;
    GraphicsBranchItem* root;
    GraphicsRectangularBranchItem* rectRoot;
    bool                contEnabled;
    int                 maxNameWidth;
    bool                showNameLabels;
    bool                showDistanceLabels;
    qreal               zoom;
    TreeLayout          layout;
    CreateBranchesTask* layoutTask;
    QGraphicsItem*      legend;
    QMenu*              buttonPopup;
    GraphicsButtonItem* selectedButton;
};

}//namespace
#endif
