/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_TREE_VIEWER_TASKS_H_
#define _GB2_TREE_VIEWER_TASKS_H_

#include <core_api/GObjectReference.h>
#include <util_tasks/ObjectViewTasks.h>

namespace GB2 {

class PhyTreeObject;
class UnloadedObject;
class TreeViewer;
class CreateRectangularBranchesTask;

class OpenTreeViewerTask : public ObjectViewTask {
    Q_OBJECT
public:
    OpenTreeViewerTask(PhyTreeObject* obj);
    OpenTreeViewerTask(UnloadedObject* obj);
    OpenTreeViewerTask(Document* doc);

    virtual void open();

private:
    QPointer<PhyTreeObject>     phyObject;
    GObjectReference            unloadedReference;
};

class OpenSavedTreeViewerTask : public ObjectViewTask {
    Q_OBJECT
public:
    OpenSavedTreeViewerTask(const QString& viewName, const QVariantMap& stateData);
    virtual void open();
	
    static void updateRanges(const QVariantMap& stateData, TreeViewer* ctx);
};


class UpdateTreeViewerTask : public ObjectViewTask {
public:
	UpdateTreeViewerTask(GObjectView* v, const QString& stateName, const QVariantMap& stateData);
	virtual void update();
};

class CreateTreeViewerTask: public Task {
    QString viewName;
    QPointer<PhyTreeObject> phyObj;
    CreateRectangularBranchesTask* subTask;
public:
    CreateTreeViewerTask(const QString& name, const QPointer<PhyTreeObject>& obj);
    virtual void prepare();
    virtual ReportResult report();
};

} // namespace

#endif
