/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SEC_STRUCT_PREDICT_UTILS_H_
#define _GB2_SEC_STRUCT_PREDICT_UTILS_H_

#include <util_ov_annotated_dna/ADVUtils.h>
#include <datatype/AnnotationData.h>

namespace GB2 {

class AnnotatedDNAView;

class SecStructPredictViewAction: public ADVGlobalAction {
    Q_OBJECT
public:
    SecStructPredictViewAction(AnnotatedDNAView* v);
    ~SecStructPredictViewAction();
    static ADVGlobalAction* createAction(AnnotatedDNAView* view);    
protected slots:
    void sl_execute();
};

class GB2_COREAPI_EXPORT SecStructPredictUtils {
public:
    static QString getStructNameForCharTag(char tag);
    static QList<SharedAnnotationData> saveAlgorithmResultsAsAnnotations(const QByteArray& predicted, const QString& annotationName);
};



} //namespace

#endif // _GB2_SEC_STRUCT_PREDICT_UTILS_H_
