/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_SMITH_WATERMAN_LOCAL_TASK_H_
#define _GB2_SMITH_WATERMAN_LOCAL_TASK_H_

#define NEED_DLL_EXPORT
#include <distributed_computing/LocalTask.h>
#undef NEED_DLL_EXPORT

#include <distributed_computing/RemoteMachine.h>
#include <distributed_computing/RemoteTask.h>

#include "SmithWatermanSettings.h"

namespace GB2 {

class GB2_COREAPI_EXPORT SmithWatermanLocalTaskSettings : public LocalTaskSettings {
private:
    static const int SERIALIZED_LIST_SZ = 12;
    
public:
    SmithWatermanLocalTaskSettings();
    virtual ~SmithWatermanLocalTaskSettings();
    SmithWatermanLocalTaskSettings( const SmithWatermanSettings & settings );
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
    const SmithWatermanSettings & getSWSettings() const;
    
private:
    void cleanup();
    
private:
    SmithWatermanSettings   settings;
    /* if settings were deserialized -> we create SubstMatrix and resultListener,
       so we should delete them.
     */
    bool                    doCleanup;
    
}; // SmithWatermanLocalTaskSettings

class GB2_COREAPI_EXPORT SmithWatermanLocalTaskResult : public LocalTaskResult {
public:
    SmithWatermanLocalTaskResult();
    virtual ~SmithWatermanLocalTaskResult();
    
    QList< SmithWatermanResult > getResult() const;
    void setResult( const QList< SmithWatermanResult > & d );
    
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );
    
private:
    QList< SmithWatermanResult > domains;
    
}; // SmithWatermanLocalTaskResult

class GB2_COREAPI_EXPORT SmithWatermanLocalTask : public LocalTask {
    Q_OBJECT
public:
    /* SmithWatermanLocalTask takes responsibility for settings */
    SmithWatermanLocalTask( SmithWatermanLocalTaskSettings * settings );
    virtual ~SmithWatermanLocalTask();
    
    virtual void prepare();
    virtual ReportResult report();
    
    virtual const LocalTaskResult * getResult() const;
    
private:
    SmithWatermanLocalTaskSettings *    settings;
    SmithWatermanLocalTaskResult        result;
    Task *                              swTask;
    
}; // SmithWatermanLocalTask

class GB2_COREAPI_EXPORT SmithWatermanRemoteToAnnotationsTask : public Task {
    Q_OBJECT
public:
    SmithWatermanRemoteToAnnotationsTask( RemoteMachineSettings * machineSettings, const SmithWatermanSettings & config,
                                          AnnotationTableObject * obj, const QString & aname, const QString & agroup );
    
    ~SmithWatermanRemoteToAnnotationsTask();
    
    virtual ReportResult report();
    virtual QString generateReport() const;
    
private:
    void checkArgs();
    
private:
    RemoteMachineSettings *             machineSettings;
    SmithWatermanSettings               config;
    QPointer< AnnotationTableObject >   annotationObj;
    QString                             aname;
    QString                             agroup;
    RemoteMachine *                     machine;
    RemoteTask *                        swTask;
    SmithWatermanReportCallback *       reportCallback;
    
}; // SmithWatermanRemoteToAnnotationsTask

typedef SimpleLocalTaskFactoryImpl< SmithWatermanLocalTaskSettings, SmithWatermanLocalTask, SmithWatermanLocalTaskResult >
    SmithWatermanLocalTaskFactory;

} // GB2

#endif // _GB2_SMITH_WATERMAN_LOCAL_TASK_H_
