/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_RESULT_H_
#define _GB2_SMITH_WATERMAN_RESULT_H_

#include <QList>
#include <core_api/LRegion.h>
#include <datatype/AnnotationData.h>


namespace GB2 {

struct GB2_COREAPI_EXPORT SmithWatermanResult {
	SharedAnnotationData toAnnotation(const QString& name) const {
        SharedAnnotationData data;
        data = new AnnotationData;
        data->name = name;
        data->location.append(region);
        data->complement = complement;
        data->aminoStrand = trans ? TriState_Yes : TriState_No;
        data->qualifiers.append(Qualifier("score", QString::number(score)));
        return data;
    }
    bool operator<(const SmithWatermanResult& op1) const {
        if (score < op1.score) {
            return true;
        } else {
            return false;
        }
    }
	bool complement;
	bool trans;
	float score;
    LRegion region;
};

class GB2_COREAPI_EXPORT SmithWatermanResultListener {
public:
    virtual void pushResult(const SmithWatermanResult& r) {
		result.append(r);
	}
    virtual void pushResult( const QList<SmithWatermanResult>& r ) {
        result.append( r );
    }
	virtual QList<SmithWatermanResult> popResults() {
		QList<SmithWatermanResult> res = result;
		result.clear();
        return res;
	}    
    virtual QList<SmithWatermanResult> getResults() const {
        return result;
    }
	virtual ~SmithWatermanResultListener() {}

private:
	QList<SmithWatermanResult> result;
};

} // namespace

#endif
