/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SUBST_MATRIX_DIALOG_H_
#define _GB2_SUBST_MATRIX_DIALOG_H_

#include "ui_SubstMatrixDialogBase.h"

#include <core_api/core_api.h>
#include <datatype/SMatrix.h>

#include <QtGui/QDialog>

namespace GB2 {

class GB2_COREAPI_EXPORT SubstMatrixDialog: public QDialog, public Ui::SubstMatrixDialogBase {
	Q_OBJECT
public:
	SubstMatrixDialog(const SMatrix& m, QWidget* parent);

private slots:
	void sl_closeWindow();

	void sl_mouseOnCell(int row, int column);
	
private:
	
	void connectGUI();
	void prepareTable();

    int hlBorderColumn;
    int hlBorderRow;
    
    int hlInnerColumn;
    int hlInnerRow;

    SMatrix m;	
};

} // namespace

#endif
