/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_PING_TASK_H_
#define _GB2_PING_TASK_H_

#include <distributed_computing/LocalTask.h>

namespace GB2 {

class GB2_COREAPI_EXPORT PingTaskSettings : public LocalTaskSettings {
private:
    static const QString PING_SETTINGS_ITEM_STR;
    static const int PING_SETTINGS_ITEMS_NUM = 8192;
    
public:
    PingTaskSettings();
    virtual ~PingTaskSettings();
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );

}; // PingTaskSettings

class GB2_COREAPI_EXPORT PingTaskResult : public LocalTaskResult {
private:
    static const QString PING_RESULT_ITEM_STR;
    static const int PING_RESULT_ITEMS_NUM = 8192;
    
public:
    PingTaskResult();
    virtual ~PingTaskResult();
    virtual QVariant serialize() const;
    virtual bool deserialize( const QVariant & data );

}; // PingTaskResult

class GB2_COREAPI_EXPORT PingTask : public LocalTask {
    Q_OBJECT
public:
    PingTask( const PingTaskSettings &settings );
    virtual ~PingTask();
    
    virtual void prepare();
    virtual void run();
    virtual ReportResult report();
    
    virtual const LocalTaskResult * getResult() const;
    
private:
    PingTaskResult result;
    
}; // PingTask

class GB2_COREAPI_EXPORT PingTaskFactory : public LocalTaskFactory {
public:
    PingTaskFactory();
    virtual ~PingTaskFactory();
    virtual LocalTask * createInstance( const QVariant & settings ) const;
    virtual LocalTaskResult * createResults( const QVariant & serializedResults ) const;

    virtual QString getId()const;

public:
    static const QString ID;

}; // PingTaskFactory

} // GB2

#endif // _GB2_PING_TASK_H_
