/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_CONFIGURATION_H_
#define _GB2_WORKFLOW_CONFIGURATION_H_

#include "ConfigurationValidator.h"
#include "ConfigurationEditor.h"

namespace GB2 {

class WCOREAPI_EXPORT Configuration {
public:
    Configuration();
    virtual ~Configuration();
    virtual QMap<QString, Attribute*> getParameters() const;
    virtual Attribute* getParameter(const QString& name) const;
    
    virtual Attribute * removeParameter( const QString & name );
    virtual void addParameter( const QString & name, Attribute * attr );
    
    virtual void setParameter(const QString& name, const QVariant& val);
    virtual bool hasParameter(const QString & name) const;
    
    void setParameters(const QVariantMap&);
    virtual ConfigurationEditor* getEditor();
    void setEditor(ConfigurationEditor* ed);
    virtual ConfigurationValidator* getValidator();
    void setValidator(ConfigurationValidator* v);
    
    virtual bool validate(QStringList&) const;
    virtual void remap(const QMap<ActorId, ActorId>&) = 0;
    
protected:
    ConfigurationEditor* editor;
    ConfigurationValidator* validator;

private:
    QMap<QString, Attribute*> params;
    
}; // Configuration

} // GB2

#endif // _GB2_WORKFLOW_CONFIGURATION_H_
