/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_ITERATION_H_
#define _GB2_WORKFLOW_ITERATION_H_

#include <workflow/Attribute.h>

#include <QtCore/QPair>

typedef QPair<GB2::ActorId,QString> IterationCfgKey;
typedef QMap<IterationCfgKey, QVariant> IterationCfg;
typedef QMap<GB2::ActorId, QVariantMap> CfgMap; 

Q_DECLARE_METATYPE(IterationCfg)
Q_DECLARE_METATYPE(CfgMap)

namespace GB2 {
namespace Workflow {

class Actor;
class Link;

class WCOREAPI_EXPORT Iteration {
public:
    Iteration() : id(nextId()) {}
    Iteration(const QString& name) : name(name), id(nextId()) {}
    QString name;
    int id;
    QMap<ActorId, QVariantMap> cfg;
    QVariantMap getParameters(const ActorId& id) const {return cfg.value(id);}
    void remap(QMap<ActorId, ActorId>);
private:
    static int nextId();
};

class WCOREAPI_EXPORT Schema /*: public Peer + TODO Actor */ {
public:
    Schema() : /*Actor(NULL),*/ deepCopy(false) {}
    virtual ~Schema();
    Schema( const Schema & other );
    Schema & operator=( const Schema & other );
    
    QList<Actor*> procs;
    QList<Link*> flows;
    QList<Iteration> iterations;
//    QList<QString> aliasMap;
    QString domain;
    bool deepCopy;
    void applyConfiguration(const Iteration&, QMap<ActorId, ActorId>);
    Actor* actorById(ActorId);
    int iterationById(int);
    void reset();
};

enum WorkflowSchemaRunMode {
    LOCAL_HOST,
    REMOTE_MACHINE
}; // WorkflowSchemaRunMode

class WCOREAPI_EXPORT Metadata {
public:
    QString name;
    QString url;
    QString comment;
    WorkflowSchemaRunMode runMode;
    
    void reset() {
        name = QString();
        comment = QString();
        url = QString();
        runMode = LOCAL_HOST;
    }
    Metadata() { reset(); }
};


}//Workflow namespace
}//GB2 namespace

#endif
