/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_MNGR_H_
#define _GB2_WORKFLOW_MNGR_H_

#include <workflow/WorkflowModel.h>
#include <workflow/WorkflowTransport.h>

#include <core_api/Task.h>
#include <core_api/IdRegistry.h>

#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <assert.h>

namespace GB2 {

namespace Workflow {

class WCOREAPI_EXPORT Worker {
public:
    // initialize input and output ports
    virtual void init() = 0;
    // if data in the ports is ready
    virtual bool isReady() = 0;
    // get data from actor and return task
    // if you want your worker support scripting: use 
    virtual Task* tick() = 0;
    // nothing to do
    virtual bool isDone() = 0;
    // opened files, etc...
    virtual void cleanup() = 0;
    virtual ~Worker() {}

}; // Worker

enum WorkerState {WorkerWaiting, WorkerReady, WorkerRunning, WorkerDone};

class WCOREAPI_EXPORT Scheduler : public Worker {
public:
    virtual WorkerState getWorkerState(ActorId) = 0;
    
}; // Scheduler


class WCOREAPI_EXPORT DomainFactory : public IdRegistry<DomainFactory>, public Descriptor {
public:
    DomainFactory(const Descriptor& d) : Descriptor(d) {}
    DomainFactory(const QString& id) : Descriptor(id) {}
    virtual Worker* createWorker(Actor*) = 0;
    virtual CommunicationChannel* createConnection(Link*) {return NULL;}
    virtual Configuration* getDefaultSettings() {return NULL;}
    virtual Scheduler* createScheduler(Schema*, Configuration*) {return NULL;}
    virtual void destroy(Scheduler*, Schema*) {}
    virtual ~DomainFactory(){}

}; // DomainFactory

class WCOREAPI_EXPORT DomainRegistry : public IdRegistry<DomainFactory> {};

// FIXME: not used
class WCOREAPI_EXPORT Manager {
public:
    void start(Schema*);
    void validate();
    
}; // Manager

}//Workflow namespace
}//GB2 namespace


#endif
