/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_REG_H_
#define _GB2_WORKFLOW_REG_H_

#include <workflow/WorkflowModel.h>

namespace GB2 {
namespace Workflow {

class WCOREAPI_EXPORT WProtoRegistry: public QObject {
    Q_OBJECT
public:
    virtual ~WProtoRegistry();
    void registerProto(const Descriptor& group, ActorPrototype* proto);
    ActorPrototype* unregisterProto(const QString& id);
    const QMap<Descriptor, QList<ActorPrototype*> >& getProtos() const {return groups;}
    ActorPrototype* getProto(const QString& id) const;
signals:
    void si_registryModified();
private:
     QMap<Descriptor, QList<ActorPrototype*> > groups;
};

}//namespace Workflow
}//namespace GB2

#endif
