/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CORE_DATATYPE_H_
#define _GB2_CORE_DATATYPE_H_

#include <QtCore/QVariant>

#include <workflow/Datatype.h>

namespace GB2 {

class WCOREAPI_EXPORT CoreDataTypes : public QObject {
    Q_OBJECT
public:
    static const QString STRING_TYPE_ID;
    static const QString STRING_SHORT_NAME;
    static const QString BOOL_TYPE_ID;
    static const QString NUM_TYPE_ID;
    static const QString ANY_TYPE_ID;

    static DataTypePtr STRING_TYPE();
    static DataTypePtr BOOL_TYPE();
    static DataTypePtr NUM_TYPE();

    static DataTypePtr ANY_TYPE();
};

// value factories for core datatypes

class StringTypeValueFactory : public DataTypeValueFactory {
public:
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL  ) const;
    virtual QString getId() const { return CoreDataTypes::STRING_TYPE_ID; }

}; // StringTypeValueFactory

class BoolTypeValueFactory : public DataTypeValueFactory {
public:
    static const QString TRUE_STR;
    static const QString FALSE_STR;
    static const QString YES_STR;
    static const QString NO_STR;
    static const QString ONE_STR;
    static const QString NIL_STR;
    
public:
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL  ) const;
    virtual QString getId() const { return CoreDataTypes::BOOL_TYPE_ID; }

}; // BoolTypeValueFactory

class NumTypeValueFactory : public DataTypeValueFactory {
public:
    virtual QVariant getValueFromString( const QString & str, bool * ok = NULL ) const;
    virtual QString getId() const { return CoreDataTypes::NUM_TYPE_ID; }

}; // NumTypeValueFactory

} //namespace
#endif
