/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_MAP_EDITOR_H_
#define _GB2_WORKFLOW_MAP_EDITOR_H_

#include <workflow/Configuration.h>
#include <workflow/ConfigurationEditor.h>

class QTableWidget;
class QTextEdit;

namespace GB2 {

class WCOREAPI_EXPORT MapDatatypeEditor : public QObject, public ConfigurationEditor {
    Q_OBJECT
public:
    MapDatatypeEditor(Configuration* cfg, const QString& prop, DataTypePtr from, DataTypePtr to);
    virtual ~MapDatatypeEditor() {}
    virtual QWidget* getWidget();
    virtual void commit();
private slots:
    void sl_showDoc();
protected:
    bool isInfoMode() const {return from == to;}
    virtual QWidget* createGUI(DataTypePtr from, DataTypePtr to);
protected:
    Configuration* cfg;
    const QString propertyName;
    DataTypePtr from, to;
    QTableWidget* table;
    QTextEdit* doc;
    
}; // MapDatatypeEditor


namespace Workflow { class BusPort;}

class WCOREAPI_EXPORT BusPortEditor : public MapDatatypeEditor {
    Q_OBJECT
public:
    BusPortEditor(Workflow::BusPort* p);
    virtual ~BusPortEditor() {}
protected:
    virtual QWidget* createGUI(DataTypePtr from, DataTypePtr to);
    Workflow::BusPort* port;
private slots:
    void handleDataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight);
    
}; // BusPortEditor


class WCOREAPI_EXPORT DescriptorListEditorDelegate : public QItemDelegate
{
    Q_OBJECT
public:
    DescriptorListEditorDelegate(QObject *parent = 0) : QItemDelegate(parent) {}
    virtual ~DescriptorListEditorDelegate() {}

    virtual QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    virtual void setEditorData(QWidget *editor, const QModelIndex &index) const;
    virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const;
    
    //void updateEditorGeometry(QWidget *editor,
    //  const QStyleOptionViewItem &option, const QModelIndex &index) const;
    
}; // DescriptorListEditorDelegate

}//namespace GB2

#endif
