/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "WorkflowEnvImpl.h"

#include "workflow/WorkflowRegistry.h"
#include <workflow/Datatype.h>
#include <workflow/WorkflowManager.h>
#include <workflow/Schema.h>
#include <workflow/IntegralBusModel.h>
#include <workflow_support/CoreDataTypes.h>


namespace GB2 {
namespace Workflow {

DataTypeRegistry* WorkflowEnvImpl::initDataRegistry() {
    qRegisterMetaTypeStreamOperators<QStrStrMap>("QStrStrMap");
    qRegisterMetaTypeStreamOperators<CfgMap>("CfgMap");
    qRegisterMetaTypeStreamOperators<IterationCfg>("IterationCfg");

    DataTypeRegistry * r = new DataTypeRegistry();

    return r;
}

DomainRegistry* WorkflowEnvImpl::initDomainRegistry() {
    DomainRegistry* r = new DomainRegistry();
    return r;
}

WProtoRegistry* WorkflowEnvImpl::initProtoRegistry() {

    WProtoRegistry* r = new WProtoRegistry();
    return r;
}

DataTypeValueFactoryRegistry* WorkflowEnvImpl::initDataTypeValueFactoryRegistry() {
    DataTypeValueFactoryRegistry* ret = new DataTypeValueFactoryRegistry();
    ret->registerEntry( new StringTypeValueFactory() );
    ret->registerEntry( new BoolTypeValueFactory() );
    ret->registerEntry( new NumTypeValueFactory() );
    return ret;
}

WorkflowEnvImpl::~WorkflowEnvImpl()
{
    delete domain;
    delete proto;
    delete data;
    delete dvfReg;
}

}//namespace Workflow
}//namespace GB2
