/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "ChromaViewPlugin.h"
#include "ChromatogramView.h"

#include <core_api/GObject.h>
#include <core_api/DocumentModel.h>
#include <gobjects/GObjectTypes.h>
#include <gobjects/DNASequenceObject.h>
#include <gobjects/DNAChromatogramObject.h>
#include <core_api/MainWindow.h>
#include <selection/DocumentSelection.h>

#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVSingleSequenceWidget.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>

#include <util_gui/GUIUtils.h>

#include <QtGui/QMessageBox>
#include <QtGui/QMenu>

namespace GB2 {

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    if (AppContext::getMainWindow()) {
        ChromaViewPlugin* plug = new ChromaViewPlugin();
        return plug;
    }
    return NULL;
}


ChromaViewPlugin::ChromaViewPlugin() : Plugin(tr("ChromaView"), tr("chroma_view_plugin_desc")) {
    viewCtx = new ChromaViewContext(this);
    viewCtx->init();
}

ChromaViewPlugin::~ChromaViewPlugin() {
}

#define CHROMA_ACTION_NAME   "CHROMA_ACTION"
#define CHROMA_VIEW_NAME     "CHROMA_VIEW"

ChromaViewContext::ChromaViewContext(QObject* p) : GObjectViewWindowContext(p, ANNOTATED_DNA_VIEW_FACTORY_ID) {
}

void ChromaViewContext::initViewContext(GObjectView* v) {
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(v);
    foreach(ADVSequenceWidget* w, av->getSequenceWidgets()) {
        sl_sequenceWidgetAdded(w);
    }
    connect(av, SIGNAL(si_sequenceWidgetAdded(ADVSequenceWidget*)), SLOT(sl_sequenceWidgetAdded(ADVSequenceWidget*)));
    
}

static DNAChromatogramObject* findChromaObj(ADVSingleSequenceWidget* sw) {
    QList<GObject*> chromaObjs = sw->getSequenceObject()->getDocument()->findGObjectByType(GObjectTypes::CHROMATOGRAM);
    if (chromaObjs.isEmpty()) {
        return NULL;
    }
    DNAChromatogramObject* chromaObj = qobject_cast<DNAChromatogramObject*>(chromaObjs.first());
    assert(chromaObj->getChromatogram().seqLength == sw->getSequenceLen());
    return chromaObj;
}

void ChromaViewContext::sl_sequenceWidgetAdded(ADVSequenceWidget* w) {
    ADVSingleSequenceWidget* sw = qobject_cast<ADVSingleSequenceWidget*>(w);
    if (sw == NULL || sw->getSequenceObject() == NULL || findChromaObj(sw) == NULL) {
        return;
    }
    
    ChromaViewAction* action = new ChromaViewAction();
    action->setIcon(QIcon(":chroma_view/images/cv.png"));
    action->setCheckable(true);
    action->setChecked(false);
    action->addToMenu = true;
    action->addToBar = true;
    connect(action, SIGNAL(triggered()), SLOT(sl_showChromatogram()));
    
    sw->addADVSequenceWidgetAction(action);

    // if chromatogram is enabled detailed sequence view is hidden
    sw->setDetViewCollapsed(true);
    
    action->trigger();
}

void ChromaViewContext::sl_showChromatogram() {
    ChromaViewAction* a = qobject_cast<ChromaViewAction*>(sender());
    assert(a!=NULL);
    if (a->isChecked()) {
        assert(a->view == NULL);
        ADVSingleSequenceWidget* sw = qobject_cast<ADVSingleSequenceWidget*>(a->seqWidget);
        DNAChromatogramObject* chromaObj = findChromaObj(sw);
        assert(chromaObj!=NULL);
        a->view = new ChromatogramView(sw, sw->getSequenceContext(), sw->getPanGSLView(), chromaObj->getChromatogram());
        sw->addSequenceView(a->view);
    } else {
        assert(a->view!=NULL);
        GObject* editSeq = a->view->getEditedSequence();
        if (editSeq!=NULL) {
            a->view->getSequenceContext()->getAnnotatedDNAView()->removeObject(editSeq);
        }
        delete a->view;
        a->view = NULL;
    } 
}

ChromaViewAction::ChromaViewAction() : ADVSequenceWidgetAction(CHROMA_ACTION_NAME, tr("show_chromatogram")), view(NULL) 
{
}

ChromaViewAction::~ChromaViewAction() {
    delete view;
}


}//namespace
