/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CIRCULAR_VIEW_PLUGIN_H_
#define _GB2_CIRCULAR_VIEW_PLUGIN_H_

#include <core_api/PluginModel.h>
#include <core_api/AppContext.h>
#include <core_api/ObjectViewModel.h>

#include <QtCore/QMap>
#include <QtGui/QAction>

#include <util_ov_annotated_dna/ADVSequenceWidget.h>

namespace GB2 {

class CircularViewSplitter;
class CircularView;

class CircularViewPlugin : public Plugin {
    Q_OBJECT
public:
    CircularViewPlugin();
    ~CircularViewPlugin();
private:
    GObjectViewWindowContext* viewCtx;
};

class CircularViewContext: public GObjectViewWindowContext {
    Q_OBJECT
public:
    CircularViewContext(QObject* p);
protected slots:
    void sl_showCircular();
    void sl_sequenceWidgetAdded(ADVSequenceWidget*);
    
protected:
    virtual void initViewContext(GObjectView* view);
    void buildMenu(GObjectView* v, QMenu* m);
	CircularViewSplitter* getView(GObjectView* view, bool create);
	void removeCircularView(GObjectView* view);
private:
    GObjectViewAction* exportAction;
};    

class CircularViewAction : public ADVSequenceWidgetAction {
    Q_OBJECT
public:
    CircularViewAction();
    ~CircularViewAction();
    CircularView* view;
};

} //namespace

#endif
