/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef DIRECTSOCKETPROTOCOLUI_H
#define DIRECTSOCKETPROTOCOLUI_H

#include <distributed_computing/ProtocolUI.h>
#include "ui/ui_DirectSocketProtocolUI.h"

namespace GB2 {

class DirectSocketProtocolUI : public ProtocolUI, public Ui::DirectSocketProtocolUI
{
    Q_OBJECT
public:
    DirectSocketProtocolUI();
    virtual ~DirectSocketProtocolUI();

    virtual RemoteMachineSettings * createMachine() const;
    virtual void initializeWidget(const RemoteMachineSettings *settings);
    virtual void clearWidget();
    virtual QString validate() const;

private:
    bool validateHost() const;
    bool validatePort() const;
    
};

} // namespace GB2

#endif // DIRECTSOCKETPROTOCOLUI_H
