/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef DIRECTSOCKETREMOTEMACHINE_H
#define DIRECTSOCKETREMOTEMACHINE_H

#include <distributed_computing/RemoteMachine.h>

namespace GB2 {

class DirectSocketRemoteMachineSettings : public RemoteMachineSettings
{
public:
    DirectSocketRemoteMachineSettings();
    DirectSocketRemoteMachineSettings(const QString &host, quint16 port);
    
    virtual QString toString() const;
    virtual bool operator==( const RemoteMachineSettings& machine ) const;

    QString getHost()const;
    quint16 getPort()const;

    QString serialize()const;
    bool deserialize( const QString & data );

private:
    QString host;
    quint16 port;
};

class DirectSocketRemoteMachine : public RemoteMachine
{
public:
    DirectSocketRemoteMachine(const DirectSocketRemoteMachineSettings &settings);
    virtual ~DirectSocketRemoteMachine();
    virtual RemoteTaskError runRemoteTask( const QString & taskFactoryId, const QVariant & settings, qint64 * taskId );
    virtual RemoteTaskError cancelRemoteTask( qint64 taskId );
    virtual RemoteTaskError deleteRemoteTask( qint64 taskId );
    virtual RemoteTaskError getRemoteTaskCancelFlag( qint64 taskId, bool * cancelFlag );
    virtual RemoteTaskError getRemoteTaskState( qint64 taskId, Task::State * state );
    virtual RemoteTaskError getRemoteTaskProgress( qint64 taskId, int * progress );
    virtual RemoteTaskError getRemoteTaskResult( qint64 taskId, QVariant * result );
    virtual RemoteTaskError getRemoteTaskError( qint64 taskId, QString * errMsg );
    virtual RemoteTaskError getUuid( QUuid * uuid );
    virtual RemoteTaskError getServicesList( QStringList * list );
    virtual RemoteTaskError getHostName( QString * hostname );
    
private:
    RemoteTaskError sendRequest(const QVariant & arg, QVariant * result = NULL);

private:
    DirectSocketRemoteMachineSettings settings;
};

class DirectSocketRemoteMachineFactory : public RemoteMachineFactory
{
public:
    DirectSocketRemoteMachineFactory();
    virtual ~DirectSocketRemoteMachineFactory();

    virtual RemoteMachine * createInstance( const QString & serializedSettings ) const;
    virtual RemoteMachine * createInstance( RemoteMachineSettings * settings ) const;
    virtual RemoteMachineSettings * createSettings( const QString & serializedSettings ) const;
    
};

} // namespace GB2

#endif // DIRECTSOCKETREMOTEMACHINE_H
