/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_SEQUENCES_DIALOG_H_
#define _GB2_EXPORT_SEQUENCES_DIALOG_H_

#include <core_api/core_api.h>

#include <QtGui/QDialog>
#include <ui/ui_ExportSequencesDialog.h>

namespace GB2 {

class SaveDocumentGroupController;

class ExportSequencesDialog : public QDialog, Ui_ExportSequencesDialog {
    Q_OBJECT
public:
    ExportSequencesDialog(bool multiMode, bool allowComplement, bool allowTranslation, bool allowBackTranslation, const QString& defaultFileName, const DocumentFormatId& f, QWidget* p);

    void updateModel();
    bool multiMode;
    DocumentFormatId formatId;
    QString file;
    
    TriState strand;//Yes-> direct, No->complement, Unkn -> both
    bool translate;
    bool translateAllFrames;
    bool useSpecificTable;
    QString translationTable;

    bool backTranslate;
    bool mostProbable;

    bool merge;
    bool addToProject;
    int mergeGap;

private slots:
    void sl_exportClicked();
	void sl_translationTableEnabler();

private:
	SaveDocumentGroupController* saveGroupContoller;
    QList<QString> tableID;
};

}//namespace

#endif
