/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_IMPORT_ANNOTATIONS_FROM_CSV_DIALOG_H_
#define _GB2_IMPORT_ANNOTATIONS_FROM_CSV_DIALOG_H_

#include <ui/ui_ImportAnnotationsFromCSVDialog.h>

#include "CSVColumnConfiguration.h"

class QTreeWidgetItem;

namespace GB2 {

class SaveDocumentGroupController;
class ImportAnnotationsFromCSVTaskConfig;
class CSVParsingConfig;

class ImportAnnotationsFromCSVDialog : public QDialog, Ui_ImportAnnotationsFromCSVDialog {
    Q_OBJECT
public:
	ImportAnnotationsFromCSVDialog(QWidget* w);

	void toTaskConfig(ImportAnnotationsFromCSVTaskConfig& config) const;
	void toParsingConfig(CSVParsingConfig& config) const;

public slots:	
	virtual void accept();


private slots:
    void sl_readFileClicked();
    void sl_previewClicked();
	void sl_guessSeparatorClicked();
    void sl_scriptSeparatorClicked();
    void sl_separatorChanged(const QString&);
    void sl_prefixToSkipChanged(const QString&);
	void sl_tableItemClicked(QTableWidgetItem*);
	void sl_tableHeaderClicked(int);
    void sl_separatorRadioToggled(bool);
    void sl_scriptRadioToggled(bool);
    
private:
    QString checkInputGroup(bool silentFail);
    QString checkOutputGroup();
    void prepareColumnsConfig(int numColumnsHint);
    QTableWidgetItem* createHeaderItem(int column) const;
	QString getHeaderItemText(int column) const;
	void	configureColumn(int column);
	QString readFileHeader(const QString& fileName, bool silentFail);
	
	void guessSeparator(bool silentFail);
	void preview(bool silentFail);
	
    SaveDocumentGroupController* saveGroupController;
	QList<ColumnConfig>          columnsConfig;	
    
    // script text used to parse separator
    QString parsingScript;
    // header of the script
    QString scriptHeader;
    // last separator value before switch to script mode
    QString lastUsedSeparator;
};

} // namespace GB2

#endif 
