/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DOT_PLOT_FILES_DIALOG_H_
#define _GB2_DOT_PLOT_FILES_DIALOG_H_

#include <ui/ui_DotPlotFilesDialog.h>

namespace GB2 {
class ADVSequenceObjectContext;

class DotPlotFilesDialog : public QDialog, public Ui_DotPlotFilesDialog{
	Q_OBJECT
public:
    DotPlotFilesDialog(QWidget *parent);

	virtual void accept();

	QString getFirstFileName() const {return firstFileName;}
	QString getSecondFileName() const {return secondFileName;}

	int getFirstGap() const;
	int getSecondGap() const;

protected slots:
	void sl_openFirstFile();
	void sl_openSecondFile();

	void sl_oneSequence();

	void sl_mergeFirst();
	void sl_mergeSecond();
private:
	QString firstFileName;
	QString secondFileName;

	QString filter;
};

} //namespace

#endif
