/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_GENOME_ALIGNER_TASK_H_
#define _GB2_GENOME_ALIGNER_TASK_H_

#include <util_dna_assembly/DnaAssemblyTask.h>

#define ULOG_CAT_GA "Plugin: Genome Aligner"

namespace GB2 {

class DNASequenceObject;
class LoadDocumentTask;
class CreateSArrayIndexTask;
class SArrayBasedFindTask;
class SArrayIndex;


class GenomeAlignerTask : public DnaAssemblyToReferenceTask {
    Q_OBJECT
public:
    GenomeAlignerTask(const DnaAssemblyToRefTaskSettings& settings);
    virtual void prepare();
    virtual void run();
    virtual ReportResult report();
    virtual QList<Task*> onSubTaskFinished(Task* subTask);
    static const QString OPTION_ALIGN_REVERSED; 
	static const QString OPTION_MISMATCHES;
    static const QString OPTION_ADD_REF_TO_ALIGNMENT;
    DNA_ASSEMBLEY_TO_REF_TASK_FACTORY(GenomeAlignerTask)
private:
    LoadDocumentTask* loadRefTask;
    CreateSArrayIndexTask* createIndexTask;
    DNASequenceObject* refSeqObj;
    QList<DNASequence> shortReads;
    int windowSize;
    QList<SArrayBasedFindTask*> findTasks;
    QMap<int,DNASequence> alignedShortReads;
};

} //namespace

#endif // _GB2_GENOME_ALIGNER_TASK_H_
