/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ORFDIALOG_H_
#define _GB2_ORFDIALOG_H_

#include "ui/ui_ORFDialogUI.h"

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtCore/QList>
#include <QtGui/QTreeWidget>
#include <QtGui/QTreeWidgetItem>
#include <QtGui/QCloseEvent>
#include <QtCore/QTimer>

namespace GB2 {

class ADVSequenceObjectContext;
class DNASequenceObject;
class ORFFindTask;
class Task;

class ORFDialog : public QDialog, public Ui_ORFDialogBase {
    Q_OBJECT

public:
    ORFDialog(ADVSequenceObjectContext* ctx);

public slots:
    virtual void reject();

protected:
    bool eventFilter(QObject *obj, QEvent *ev);

private slots:
    
    //buttons:
    void sl_onSaveAnnotations();
    void sl_onClearList();
    void sl_onFindAll();
    void sl_onClose();
    void sl_onRangeToSelection();
    void sl_onRangeToPanView();
    void sl_onRangeToSequence();

    void sl_onTaskFinished(Task*);
    void sl_onTimer();

    void sl_onResultActivated(QTreeWidgetItem* i, int col);
    void sl_translationChanged();


private:
    void connectGUI();
    void updateState();
    void updateStatus();
    void tunePercentBox();
    
    void runTask();

    void importResults();

    LRegion getCompleteSearchRegion() const;

private:
    ADVSequenceObjectContext* ctx;
    DNASequenceObject* sequence;

    LRegion panViewSelection;
    ORFFindTask* task;
    QTimer* timer;
    LRegion initialSelection;
};

}//namespace

#endif
