/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOTE_QUERY_PLUGIN_TEST_H_
#define _GB2_REMOTE_QUERY_PLUGIN_TEST_H_

#include <test_framework/xmltest/XMLTestUtils.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <core_api/DocumentModel.h>
#include <document_format/GenbankPlainTextFormat.h>
#include <gobjects/DNASequenceObject.h>
#include <test_framework/xmltest/XMLTestUtils.h>
#include <gobjects/GObjectTypes.h>
#include <gobjects/GObjectUtils.h>
#include <core_api/GObject.h>
#include <core_api/AppContext.h>
#include <QtXml/QDomElement>
#include <core_api/IOAdapter.h>
#include <core_api/GObject.h>

#include "RemoteQueryPlugin.h"
#include "RemoteQueryTask.h"
#include "RemoteQueryConsts.h"

namespace GB2 {

class GTest_RemoteQuery : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(GTest_RemoteQuery, "plugin_remote-query");
    ~GTest_RemoteQuery(){};

    void prepare();
    void cleanup();
    Task::ReportResult report();
private:
    AnnotationTableObject *ao;
    RemoteQueryToAnnotationsTask *task;
    int minLength;
    int maxLength;
    QString index;
    QString sequence;
    QString request;
    QString algoritm;
    QStringList expectedResults;
};



}//ns

#endif
