/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REMOTE_QUERY_TASK_H_
#define _GB2_REMOTE_QUERY_TASK_H_

#include <core_api/Task.h>
#include <datatype/AnnotationData.h>
#include <core_api/DNATranslation.h>
#include <util_tasks/CreateAnnotationTask.h>
#include <core_api/Counter.h>
#include <util_text/TextUtils.h>
#include <core_api/Log.h>
#include <core_api/DocumentModel.h>
#include <core_api/ProjectModel.h>
#include <util_gui/CreateAnnotationWidgetController.h>

#include "HttpRequest.h"

#define ULOG_CAT_PLUGIN_REMOTE_QUERY "Plugin: Remote query"


namespace GB2 {

class DNATranslation;
class AnnotationTableObject;

enum SendSelectionAlphabet
{
    SendSelectionAlphabet_Any,
    SendSelectionAlphabet_Nucleo,
    SendSelectionAlphabet_Amino
};

struct RemoteQueryTaskSettings {
    QString				dbChoosen;
    QString				params;
    int					retries;
    DNATranslation *    aminoT;
    DNATranslation *    complT;
    QByteArray          query;
    RemoteQueryTaskSettings() : aminoT(0) {}
};

class RemoteQueryToAnnotationsTask : public Task {
    Q_OBJECT
public:
    RemoteQueryToAnnotationsTask( QString dbChosen, DNATranslation * aminoT, DNATranslation * complT,
        const QByteArray & query, int qoffs, AnnotationTableObject* ao, const QString &url, const QString & group, QString params, int retries );

    QList<Task*> onSubTaskFinished(Task* subTask);

private:
    int                 offsInGlobalSeq;
    QPointer<AnnotationTableObject>  aobj;
    QString             group;
    Task*               queryTask;
    QString				url;
};

class RemoteQueryTask : public Task {
    Q_OBJECT
public:
    RemoteQueryTask( const RemoteQueryTaskSettings & cfg );
    void run();
    void prepare();
    bool isTranslated() const {return ( cfg.aminoT != NULL); }
    void increaseProgress() { stateInfo.progress++; emit si_progressChanged();}
    void resetProgress() {stateInfo.progress = 0; emit si_progressChanged();}
    QByteArray getOutputFile() const {return httpRequest.first()->getOutputFile();}

    QList<SharedAnnotationData> getResultedAnnotations() const;
    bool timeout;

private slots:
    void sl_timeout() {timeout = false;}

private:
    struct Query {
        Query() : amino(false), complement(false), offs(0){}
        QByteArray seq;
        bool amino;
        bool complement;
        int offs;       //translation frame offset
    };
    void  prepareQueries();
    void  createAnnotations(const Query & q,HttpRequest *t);

    RemoteQueryTaskSettings cfg;
    QList<Query>        queries;
    QList<SharedAnnotationData> resultAnnotations;
    QList<HttpRequest*> httpRequest;
    
    QTimer timer;

};

}

#endif
