/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "RFTaskFactory.h"
#include "RFBase.h"

namespace GB2 {

    RFTaskFactory::RFTaskFactory()
    {
    }

    RFTaskFactory::~RFTaskFactory()
    {
    }

    Task* RFTaskFactory::getTaskInstance( const RepeatFinderSettings& c) const {
		return RFAlgorithmBase::createTask(
			c._l,
			c._seqX,
			c._sizeX,
			c._seqY,
			c._sizeY,
			c._al,
			c._w,
			c._mismatches,
			c._alg,
			c._nThreads
		);
	}

	void RFTaskFactory::setRFResultsListener(Task* b, RFResultsListener* l) {
		RFAlgorithmBase* rfTask = qobject_cast<RFAlgorithmBase*>(b);
		if (rfTask) {
			rfTask->setRFResultsListener(l);
		}
	}
} // namespace
