/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WEIGHT_MATRIX_BUILD_DIALOG_CONTROLLER_H_
#define _GB2_WEIGHT_MATRIX_BUILD_DIALOG_CONTROLLER_H_

#include <ui/ui_PWMBuildDialog.h>

#include "WeightMatrixPlugin.h"
#include "WeightMatrixAlgorithm.h"
#include <core_api/Task.h>
#include <datatype/MAlignment.h>
#include <datatype/DNASequence.h>
#include <datatype/PFMatrix.h>
#include <datatype/PWMatrix.h>
#include <QtGui/QDialog>
#include <util_weight_matrix/PWMConversionAlgorithm.h>
#include <util_ov_msaedit/AlignmentLogo.h>

namespace GB2 {

class LoadDocumentTask;
class PWMBuildSettings;
class PWMModel;

class PWMBuildDialogController : public QDialog, public Ui_PWMBuildDialog {
    Q_OBJECT

public:
    PWMBuildDialogController(QWidget* w = NULL);
    QString lastURL;

public slots:
    virtual void reject();

private slots:
    void sl_inFileButtonClicked();
    void sl_outFileButtonClicked();
    void sl_okButtonClicked();
    void sl_matrixTypeChanged(bool);

    void sl_onStateChanged();
    void sl_onProgressChanged();

private:
    Task* task;
    AlignmentLogoRenderArea* logoArea;
};


class PFMatrixBuildTask : public Task {
    Q_OBJECT
public:
    PFMatrixBuildTask(const PMBuildSettings& s, const MAlignment& ma);
    void run();
    PFMatrix getResult() const {return m;}

private:
    PMBuildSettings        settings;
    MAlignment              ma;
    PFMatrix                m;
};

class PFMatrixBuildToFileTask : public Task {
    Q_OBJECT
public:
    PFMatrixBuildToFileTask(const QString& inFile, const QString& outFile, const PMBuildSettings& s);
    virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
    LoadDocumentTask*       loadTask;
    PFMatrixBuildTask*           buildTask;
    QString                 outFile;
    PMBuildSettings         settings;
};

class PWMatrixBuildTask : public Task {
    Q_OBJECT
public:
    PWMatrixBuildTask(const PMBuildSettings& s, const MAlignment& ma);
    PWMatrixBuildTask(const PMBuildSettings& s, const PFMatrix& m);
    void run();
    PWMatrix getResult() const {return m;}

private:
    PMBuildSettings         settings;
    MAlignment              ma;
    PFMatrix                tempMatrix;
    PWMatrix                m;
};

class PWMatrixBuildToFileTask : public Task {
    Q_OBJECT
public:
    PWMatrixBuildToFileTask(const QString& inFile, const QString& outFile, const PMBuildSettings& s);
    virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
    LoadDocumentTask*       loadTask;
    PWMatrixBuildTask*       buildTask;
    QString                 outFile;
    PMBuildSettings    settings;
};

} //namespace

#endif

