/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SetParametersDialogController.h"

#include <core_api/AppContext.h>
#include <util_weight_matrix/PWMConversionAlgorithmRegistry.h>

namespace GB2 {

SetParametersDialogController::SetParametersDialogController(QWidget *w) 
    : QDialog(w) {

    setupUi(this);
    
    QStringList algo = AppContext::getPWMConversionAlgorithmRegistry()->getAlgorithmIds();
    algorithmComboBox->addItems(algo);

    connect(okButton, SIGNAL(clicked()), SLOT(sl_onOkButton()));
    connect(scoreSlider, SIGNAL(valueChanged(int)), SLOT(sl_onSliderMoved(int)));
}

void SetParametersDialogController::sl_onSliderMoved(int value) {
    scoreValueLabel->setText(QString("%1%").arg(value));
}

void SetParametersDialogController::sl_onOkButton() {
    QDialog::accept();
}

}