/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ACTOR_CFG_H_
#define _GB2_ACTOR_CFG_H_

#include <QtCore/QList>
#include <QtCore/QPair>
#include <QtCore/QString>
#include <QtCore/QAbstractTableModel>

#include <workflow/WorkflowModel.h>
#include <workflow/IntegralBusModel.h>
#include <workflow_support/DelegateEditors.h>

namespace GB2 {

struct InputPortData {
    BusPort * port;
    QString portDisplayName;
    DataTypePtr from;
    DataTypePtr to;
    QList<QPair<Descriptor, Descriptor> > data; // list of pairs (keyDescriptor, valueDescriptor)
}; // InputPortData

class InputPortsData {
public:
    void setData( const QList<Port*>& inputPorts );
    void reset();
    
    int size() const;
    void dump() const;
    void setKeyValDescriptors( Descriptor & key, Descriptor & val, int row ) const;
    
public:
    QList<InputPortData> data;
}; // InputPortsData

class ActorCfgModel : public QAbstractTableModel {
public:
    ActorCfgModel(QObject *parent, QList<Iteration>& lst);
    ~ActorCfgModel();
    
    void setActor(Actor * cfg);
    
    void selectIteration(int i);
    
    void setIterations(QList<Iteration>& lst);

    int columnCount(const QModelIndex &) const;
    
    int rowCount ( const QModelIndex & parent = QModelIndex() ) const;
    
    Qt::ItemFlags flags( const QModelIndex & index ) const;
    
    QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
    
    /*Used to supply item data to views and delegates. 
    Generally, models only need to supply data for Qt::DisplayRole and any application-specific user roles, 
    but it is also good practice to provide data for Qt::ToolTipRole, Qt::AccessibleTextRole, and Qt::AccessibleDescriptionRole.*/
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    
    /*Used to modify the item of data associated with a specified model index. 
    To be able to accept user input, provided by user interface elements, this function must handle data associated with Qt::EditRole. 
    The implementation may also accept data associated with many different kinds of roles specified by Qt::ItemDataRole. 
    After changing the item of data, models must emit the dataChanged() signal to inform other components of the change.*/
    bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );

private:
    QVariant dataForActorAttributes(const QModelIndex & index, int role ) const;
    QVariant dataForPortAttributes(const QModelIndex & index, int role ) const;
    bool setAttributeValue( const Attribute * attr, QVariant & attrValue ) const;
    void setupAttributesScripts();
    
private:
    Actor*              subject;
    QList<Attribute*>   attrs;
    AttributeScriptDelegate * scriptDelegate;
    
    InputPortsData      inputPortsData;
    QList<Iteration>&   iterations;
    int                 iterationIdx;
    QVariantMap         listValues;
    
}; // ActorCfgModel

}//namespace GB2

#endif // _GB2_ACTOR_CFG_H_
