/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_FLOWCHART_H_
#define _GB2_FLOWCHART_H_

#include <core_api/PluginModel.h>
#include <core_api/ServiceModel.h>
#include <core_api/Task.h>

#include <wd_local_task/WorkflowSimpleLocalTask.h>

class QAction;
class QEvent;

namespace GB2 {

class WorkflowDesignerPlugin : public Plugin {
	Q_OBJECT
public:
    static const QString RUN_WORKFLOW;
    static const QString REMOTE_MACHINE;
    
public:
    WorkflowDesignerPlugin ();
	//~WorkflowDesignerPlugin ();
private:
    void registerCMDLineHelp();
    void processCMDLineOptions();
    
private:
    WorkflowSimpleLocalTaskFactory workflowSimpleTaskFactory;
    
};

class WorkflowDesignerService : public Service {
    Q_OBJECT
public:
    WorkflowDesignerService();
    bool closeViews();
protected:
    virtual Task* createServiceEnablingTask();

    virtual Task* createServiceDisablingTask();

    virtual void serviceStateChangedCallback(ServiceState oldState, bool enabledStateChanged);

private slots:
    void sl_showDesignerWindow();
    void sl_showManagerWindow();

private:
    QAction*        designerAction;
    QAction*        managerAction;
};


} //namespace

#endif
