/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _BOWTIE_IO_ADAPTER_H_
#define _BOWTIE_IO_ADAPTER_H_

#include "bowtie/pat.h"
#include "bowtie/hit.h"

#include <QtCore/QMutex>

namespace GB2 {
	class MAlignment;
	class MAlignmentRow;
}

/************************************************************************/
/* DNASequencesPatternSource                                            */
/************************************************************************/

class DNASequencesPatternSource: public PatternSource {
public:
	DNASequencesPatternSource(uint32_t seed, const QList<GB2::DNASequence> &dnaList);
	void nextReadImpl(ReadBuf& r, uint32_t& patid);
	void nextReadPairImpl(ReadBuf& ra, ReadBuf& rb, uint32_t& patid);
private:
	const QList<GB2::DNASequence> &dnaList;
	QMutex mutex;
};

/************************************************************************/
/* MAlignmentHitSink                                                    */
/************************************************************************/

class MAlignmentHitSink: public HitSink {
public:
	MAlignmentHitSink(GB2::MAlignment &result, OutFileBuf* out, DECL_HIT_DUMPS, bool onePairFile, bool sampleMax, RecalTable *table, vector<string>* refnames = NULL);
	void append(ostream& o, const Hit& h);
	void commitResultMA();
private:
	QList<GB2::MAlignmentRow> rowList;
	GB2::MAlignment& resultMA;
	QMutex mutex;
};

#endif // _BOWTIE_IO_ADAPTER_H_
