/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_HMMER3_HMM_FORMAT_H_
#define _GB2_HMMER3_HMM_FORMAT_H_

#include <QtCore/QByteArray>
#include <QtCore/QString>
#include <QtCore/QStringList>

#include <core_api/core_api.h>
#include <core_api/DocumentModel.h>
#include <core_api/IOAdapter.h>

namespace GB2 {

class UHMMFormat : public DocumentFormat {
    Q_OBJECT
public:
    static const DocumentFormatId   UHHMER_FORMAT_ID;
    static const QString            WRITE_LOCK_REASON;
    static const QString            WRITE_FAILED;
    
public:
    UHMMFormat( QObject* obj );
    
    virtual DocumentFormatId getFormatId() const;
    
    virtual const QString& getFormatName() const;
    
    
    virtual Document* loadDocument( IOAdapter* io, TaskStateInfo& ti, const QVariantMap& formatSettings, DocumentLoadMode mode = DocumentLoadMode_Whole );
    
    virtual void storeDocument( Document* d, TaskStateInfo& ts, IOAdapter* io );
    
    virtual bool checkRawData( const QByteArray& data) const;
    
    struct UHMMWriteException {
        QString what;
        UHMMWriteException( const QString& msg ) : what( msg ) {}
    }; // UHMMWriteException
    
private:
    QString formatName;
    
}; // UHMMFormat

} // GB2

#endif // _GB2_HMMER3_HMM_FORMAT_H_
