/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/


#ifndef _GB2_UHMM3_UTILITIES_H_
#define _GB2_UHMM3_UTILITIES_H_

#include <core_api/DocumentModel.h>
#include <core_api/DNAAlphabet.h>
#include <datatype/MAlignment.h>

#include <hmmer3/hmmer.h>
#include <hmmer3/easel/esl_scorematrix.h>
#include <hmmer3/easel/esl_msa.h>

namespace GB2 {

class SMatrix;

class UHMM3Utilities {
public:
    static const int BAD_ALPHABET = -1;
    
public:
    static ESL_SCOREMATRIX * convertScoreMatrix( const SMatrix& it );
    
    static int convertAlphabetType( const DNAAlphabet * al );
    
    static ESL_MSA * convertMSA( const MAlignment & ma );
    
    static P7_HMM * getHmmFromDocument( Document* doc, TaskStateInfo& ti );
    
}; // UHMM3Utilities

} // GB2

#endif // _GB2_UHMM3_UTILITIES_H_
