/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtGui/QMenu>
#include <QtGui/QAction>
#include <QtGui/QMessageBox>
#include <QtCore/QMap>
#include <QtCore/QFile>

#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>
#include <core_api/AppContext.h>
#include <core_api/Log.h>
#include <core_api/SecStructPredictAlgRegistry.h>
#include <datatype/BioStruct3D.h>
#include <gobjects/AnnotationSettings.h>
#include <test_framework/GTestFrameworkComponents.h>

#include <util_sec_struct_predict/SecStructPredictTask.h>
#include <util_sec_struct_predict/SecStructDialog.h>

#include "PsipredPlugin.h"
#include "PsipredAlgTask.h"
#include "sspred_utils.h"

namespace GB2 {

static LogCategory log(ULOG_CAT_PLUGIN_SEC_STRUCT_PREDICT);

extern "C" Q_DECL_EXPORT Plugin* GB2_PLUGIN_INIT_FUNC() {
    PsipredPlugin* plug = new PsipredPlugin();
    return plug;
}


PsipredPlugin::PsipredPlugin() : Plugin(tr("PsiPred"), tr("PsiPred protein secondary structure prediction")) {
   
    // Register PsiPred algorithm
    SecStructPredictAlgRegistry* registry = AppContext::getSecStructPredictAlgRegistry();
    SecStructPredictTaskFactory* taskFactory = new PsipredAlgTask::Factory;
    registry->registerAlgorithm(taskFactory, PsipredAlgTask::taskName);
    
    //Register PsiPred annotation settings
    AnnotationSettingsRegistry* asr =AppContext::getAnnotationsSettingsRegistry();
    AnnotationSettings* as = new AnnotationSettings(PSIPRED_ANNOTATION_NAME, true, QColor(102,255, 0), true);
    as->nameQuals.append(BioStruct3D::SecStructTypeQualifierName);
    asr->changeSettings(QList<AnnotationSettings*>() << as, false);


}

PsipredPlugin::~PsipredPlugin() {
}



}//namespace

