/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EXPORT_PROJECT_DIALOG_CONTROLLER_
#define _GB2_EXPORT_PROJECT_DIALOG_CONTROLLER_

#include <ui/ui_ExportProjectDialog.h>

#include <core_api/AppContext.h>

namespace GB2 {

class ExportProjectDialogController : public QDialog, public Ui_ExportProjectDialog {
	Q_OBJECT
public:
	ExportProjectDialogController(QWidget *p, const QString& defaultProjectFileName);

	void accept();

	const QString& getDirToSave() const {return exportDir;}
    const QString& getProjectFile() const {return projectFile;}

	bool useCompression() const {return false;}

private slots:
	void sl_onBrowseButton();

private:
    //canonical representation of the dir
    QString exportDir;
    QString projectFile;
};

} //namespace

#endif
