/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

// collect result of GOptionContext to UgDataset

#ifndef UG_OPTION_H
#define UG_OPTION_H

#include <glib.h>
#include <ug_dataset.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct		UgOption_			UgOption;
typedef struct		UgOptionMainData_	UgOptionMainData;

typedef gboolean	(*UgOptionGetFunc)	(const UgOption* option, UgDataset* dataset);

extern	const		UgOption*			UgOptionMain;

// ----------------------------------------------------------------------------
// UgOption
struct UgOption_
{
	const gchar*		name;
	gpointer			reserve;			// reserve for GModule-related code

	GOptionEntry*		entry;				// for  g_option_group_add_entries()
	gpointer			data;				// argument data
	guint				data_size;			// size of argument data

	UgInitFunc			init;				// initialize option_data
	UgOptionGetFunc		get;				// get argument data and set it to UgDataset
};

// These functions can use with g_list_foreach().
// g_list_foreach (UgOption_list, (GFunc) ug_option_get, dataset);
// g_list_foreach (UgOption_list, (GFunc) ug_option_clear, NULL);
void	ug_option_get   (const UgOption* option, UgDataset* dataset);
void	ug_option_clear (const UgOption* option);

// ---------------------------------------------------------------------------
// UgOptionMainData: main argument data
//
struct UgOptionMainData_
{
	// option_entry->arg_data place below
	gboolean	version;
	gboolean	quiet;
	gint		category_index;
	gchar*		input_file;

	gchar*		folder;
	gchar*		file;

	gchar*		user;
	gchar*		password;

	gint		proxy_type;
	gchar*		proxy_host;
	guint		proxy_port;
	gchar*		proxy_user;
	gchar*		proxy_password;

	gchar*		http_user;
	gchar*		http_password;
	gchar*		http_referrer;
	gchar*		http_user_agent;
	gchar*		http_cookie_data;
	gchar*		http_cookie_file;
	gchar*		http_post_data;
	gchar*		http_post_file;

	gchar*		ftp_user;
	gchar*		ftp_password;
};


#ifdef __cplusplus
}
#endif

#endif  // UG_OPTION_H

