/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UGLIB_H
#define UGLIB_H

#include <glib.h>
#include <ug_message.h>
#include <ug_data_download.h>
#include <ug_dataset.h>
#include <ug_plugin.h>
#include <ug_option.h>
#include <ug_utils.h>
#include <ug_ipc.h>

#ifdef __cplusplus
extern "C" {
#endif

// find -?, -h, --help, or --help- in command-line options and return it.
char*	ug_find_help_option (int argc, char** argv);
// find -V, --version
char*	ug_find_version_option (int argc, char** argv);

// ------------------------------------------------------------------
// URI list functions
// To get URIs from text file, error is G_FILE_ERROR.
GList*	ug_text_file_get_uris (const gchar* file_utf8, GError** error);
// get URIs from text
GList*	ug_text_get_uris (const gchar* text, gint text_len);
// remove URIs from list by scheme
GList*	ug_uri_list_remove_scheme (GList* uris, const gchar* scheme);

// ------------------------------------------------------------------
// check BOM in file header and set it's encoding.
// return encoding string.
const char*	ug_io_channel_decide_encoding (GIOChannel* channel);

// ------------------------------------------------------------------
// register/unregister classes
gboolean	uget_class_init		(void);
void		uget_class_finalize	(void);

// return  1: server start and push arguments to queue.
// return  0: server exist and send arguments to server.
// return -1: error
gint		uget_ipc_init (UgIpc* ipc, int argc, char** argv);

// ----------------------------------------------------------------------------
// UgetOption: integrate GOptionContext, GOptionGroup, and UgOption
//
typedef	struct	UgetOption_		UgetOption;

struct	UgetOption_
{
	GOptionContext*		context;
	GOptionGroup*		group;		// main group
	UgOptionMainData*	data;		// main data
	GList*				list;		// list of UgOption
};

void	uget_option_init  (UgetOption* uopt);

// if group is NULL, option->entry will add to main group.
void	uget_option_add   (UgetOption* uopt, const UgOption* option, GOptionGroup* group);

// show help message and exit
void	uget_option_help  (UgetOption* uopt, const char* progname, const char* help_option);

// This parse arguments and return list of newly-created UgDataset.
// To free the returned value, use:
//	g_list_foreach (list, (GFunc) ug_dataset_unref, NULL);
//	g_list_free (list);
GList*	uget_option_parse (UgetOption* uopt, GPtrArray* args);


#ifdef __cplusplus
}
#endif

#endif  // UGLIB_H

