/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef UG_CATEGORY_GTK_H
#define UG_CATEGORY_GTK_H

#include <gtk/gtk.h>
#include <ug_category.h>
#include <ug_download_widget.h>

#ifdef __cplusplus
extern "C" {
#endif

#define	UG_DATASET_RELATION_GTK(dataset)	( (UgRelationGtk*) UG_DATASET_RELATION (dataset) )

typedef struct	UgCategoryGtk_			UgCategoryGtk;
typedef struct	UgRelationGtk_			UgRelationGtk;

extern	const	UgDataClass*			UgCategoryGtkClass;
extern	const	UgDataClass*			UgRelationGtkClass;


// ----------------------------------------------------------------------------
// UgCategoryGtk
//
// UgData
// |
// `- UgCategory  (abstract class)
//    |
//    +- UgCategoryCmd  (uget-cmd)
//    |
//    `- UgCategoryGtk  (uget-gtk)
//
struct UgCategoryGtk_
{
	UG_CATEGORY_MEMBERS;
//	const UgDataClass*	data_class;			// UG_DATA_MEMBERS
//	gchar*				name;
//	struct {
//		guint			active;
//		guint			finished;			// finished: completed and paused
//		guint			recycled;
//	} limit;
//	GList*				indices;			// used when program save/load category
//	UgDataset*			defaults;			// default setting of UgDataset
//	struct {
//		UgWatchFunc		func;				// watch (global)
//		gpointer		data;
//	} watch;

	GQueue				active;

	UgCategoryGtk*		primary;	// if it is NULL, this category is primary.
	GtkListStore*		store;		// Only primary category has this.
	GtkTreeModel*		filter;		// model or filter for primary.store

	UgDownloadWidget	all;		// GtkTreeModelSort
	UgDownloadWidget	queuing;	// GtkTreeModelFilter
	UgDownloadWidget	finished;	// GtkTreeModelFilter
	UgDownloadWidget	recycled;	// GtkTreeModelFilter

	// iterator for UgCategoryWidget.store
	GtkTreeIter			tree_iter;
};

UgCategoryGtk*	ug_category_gtk_new  (UgCategoryGtk* primary);
void			ug_category_gtk_free (UgCategoryGtk* cgtk);

void	ug_category_gtk_set_primary (UgCategoryGtk* cgtk, UgCategoryGtk* primary);

void	ug_category_gtk_add    (UgCategoryGtk* cgtk, UgDataset* dataset);
void	ug_category_gtk_remove (UgCategoryGtk* cgtk, UgDataset* dataset);
void	ug_category_gtk_switch (UgCategoryGtk* cgtk, UgDataset* dataset, UgCategoryHints hint);
void	ug_category_gtk_clear  (UgCategoryGtk* cgtk, UgCategoryHints hint, guint from_nth);

void	ug_category_gtk_move_to (UgCategoryGtk* cgtk, UgDataset* dataset, UgCategoryGtk* cgtk_dest);

// get all jobs in this category, call g_list_free(list) to free returned list
GList*	ug_category_gtk_get_list (UgCategoryGtk* cgtk);

gboolean	ug_category_gtk_move_selected_up (UgCategoryGtk* cgtk, UgDownloadWidget* dwidget);
gboolean	ug_category_gtk_move_selected_down (UgCategoryGtk* cgtk, UgDownloadWidget* dwidget);
gboolean	ug_category_gtk_move_selected_to_top (UgCategoryGtk* cgtk, UgDownloadWidget* dwidget);
gboolean	ug_category_gtk_move_selected_to_bottom (UgCategoryGtk* cgtk, UgDownloadWidget* dwidget);

gboolean	ug_category_gtk_start (UgCategoryGtk* cgtk, UgDataset* dataset);
void		ug_category_gtk_stop  (UgCategoryGtk* cgtk, UgDataset* dataset);

// returned value
// FALSE: status no changed.
// TRUE:  status changed. (start, stop, move, remove)
gboolean	ug_category_gtk_refresh (UgCategoryGtk* cgtk, GList** completed);
gboolean	ug_category_gtk_activate (UgCategoryGtk* cgtk);
gboolean	ug_category_gtk_clear_excess (UgCategoryGtk* cgtk);

// ----------------------------------------------------------------------------
// UgRelationGtk : relation of UgCategoryGtk, UgDataset, and UgPlugin.
//
// UgData
// |
// +- UgDataList
//    |
//    +- UgRelation  (abstract class)
//       |
//       +- UgRelationCmd  (uget-cmd)
//       |
//       +- UgRelationGtk  (uget-gtk)
//
struct UgRelationGtk_
{
	UG_RELATION_MEMBERS (UgRelationGtk);
//	const UgDataClass*	data_class;		// UG_DATA_LIST_MEMBERS (UgRelationGtk)
//	UgRelationGtk*		next;
//	UgRelationGtk*		prev;
//	guint				index;			// use index when program save/load file.
//	UgCategoryHints		hints;
//	UgPlugin*			plugin;			// plug-in
//	struct {
//		UgWatchFunc		func;			// watch
//		gpointer		data;
//	} watch;

	UgMessageType		message_type;
	gchar*				message;

	UgCategoryGtk*		category;
	UgCategoryGtk*		primary;
	GtkTreeIter			iter;		// iterator of primary.store
};


#ifdef __cplusplus
}
#endif

#endif  // UG_CATEGORY_GTK_H

