/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <UgDownloadForm.h>
#include <UgData-download.h>
#include <UgCategory-gtk.h>
#include <UgUri.h>
#include <UgUtils.h>
#include <UgString.h>
#include <UgetGtk-setting.h>		// UGET_GTK_NAME

#include <glib/gi18n.h>

//	signal handler
static void	on_spin_changed (GtkEditable *editable, UgDownloadForm* dform);
static void	on_entry_changed (GtkEditable *editable, UgDownloadForm* dform);
static void	on_url_entry_changed (GtkEditable *editable, UgDownloadForm* dform);
static void	on_http_entry_changed (GtkEditable *editable, UgDownloadForm* dform);
static void	on_select_folder (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkEvent* event, UgDownloadForm* dform);
static void	on_select_cookie (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkEvent* event, UgDownloadForm* dform);
static void	on_select_post   (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkEvent* event, UgDownloadForm* dform);

void	ug_download_form_init (UgDownloadForm* dform, UgProxyForm* proxy, GtkWindow* parent)
{
	GtkWidget*	entry;
	GtkWidget*	label;
	GtkTable*	top_table;
	GtkTable*	table;
	GtkWidget*	frame;
	GtkWidget*	vbox;
	GtkWidget*	hbox;

	dform->changed.enable   = TRUE;
	dform->changed.url      = FALSE;
	dform->changed.file     = FALSE;
	dform->changed.folder   = FALSE;
	dform->changed.user     = FALSE;
	dform->changed.password = FALSE;
	dform->changed.referrer = FALSE;
	dform->changed.cookie   = FALSE;
	dform->changed.post     = FALSE;
	dform->changed.retry    = FALSE;
	dform->changed.delay    = FALSE;
	dform->parent = parent;
	dform->self = gtk_table_new (7, 3, FALSE);
	top_table = (GtkTable*) dform->self;

	// URL Label & Entry
//	button = gtk_button_new ();
//	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
//	gtk_container_add (GTK_CONTAINER (button),
//			gtk_image_new_from_stock (GTK_STOCK_PASTE, GTK_ICON_SIZE_MENU));
//	gtk_table_attach (top_table, button, 2, 3, 0, 1,
//			GTK_SHRINK, GTK_SHRINK, 2, 1);
//	dform->url_button = button;
	// entry
	label = gtk_label_new_with_mnemonic (_("_URL:"));
	entry = gtk_entry_new ();
	gtk_entry_set_width_chars (GTK_ENTRY (entry), 20);
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), entry);
	gtk_table_attach (top_table, label,  0, 1, 0, 1,
			GTK_SHRINK, GTK_SHRINK, 3, 2);
	gtk_table_attach (top_table, entry,  1, 3, 0, 1,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 2);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_url_entry_changed), dform);
	dform->url_label  = label;
	dform->url_entry  = entry;

	// "File" label & entry
//	button = gtk_button_new ();
//	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
//	gtk_container_add (GTK_CONTAINER (button),
//			gtk_image_new_from_stock (GTK_STOCK_FILE, GTK_ICON_SIZE_MENU));
//	gtk_table_attach (top_table, button, 2, 3, 1, 2,
//			GTK_SHRINK, GTK_SHRINK, 2, 1);
//	dform->file_button = button;
	// entry
	label = gtk_label_new_with_mnemonic (_("File:"));
	entry = gtk_entry_new ();
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
	gtk_table_attach (top_table, label,  0, 1, 1, 2,
			GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (top_table, entry,  1, 3, 1, 2,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_entry_changed), dform);
	dform->file_entry = entry;
	dform->file_label = label;

	// "Folder" label, entry, and icon
//	button = gtk_button_new ();
//	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
//	gtk_container_add (GTK_CONTAINER (button),
//			gtk_image_new_from_stock (GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU));
//	gtk_table_attach (top_table, button, 2, 3, 2, 3,
//			GTK_SHRINK, GTK_SHRINK, 2, 1);
//	dform->folder_button = button;
	// entry
	dform->folder_combo = gtk_combo_box_entry_new_text ();
	dform->folder_entry = gtk_bin_get_child (GTK_BIN (dform->folder_combo));
	label = gtk_label_new_with_mnemonic (_("_Folder:"));
	entry = dform->folder_entry;
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_entry_set_icon_from_stock (GTK_ENTRY (entry),
			GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_DIRECTORY);
	gtk_entry_set_icon_tooltip_text (GTK_ENTRY (entry),
			GTK_ENTRY_ICON_SECONDARY, _("Select Folder"));
	gtk_label_set_mnemonic_widget(GTK_LABEL (label), dform->folder_combo);
	gtk_table_attach (top_table, label,  0, 1, 2, 3,
			GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (top_table, dform->folder_combo,  1, 2, 2, 3,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (entry, "icon-release",
			G_CALLBACK (on_select_folder), dform);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_entry_changed), dform);

	// "Referrer" label & entry
	label = gtk_label_new_with_mnemonic (_("Referrer:"));
	entry = gtk_entry_new ();
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
	gtk_table_attach (top_table, label, 0, 1, 3, 4,
			GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (top_table, entry, 1, 3, 3, 4,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_http_entry_changed), dform);
	dform->referrer_entry = entry;
//	dform->referrer_label = label;

	// ----------------------------------------------------
	// HBox for "Status" and "Login"
	hbox = gtk_hbox_new (FALSE, 2);
	gtk_table_attach (top_table, hbox, 0, 3, 4, 5,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);

	// ----------------------------------------------------
	// frame for Status (start mode)
	frame = gtk_frame_new (_("Status"));
	vbox = gtk_vbox_new (FALSE, 2);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);
	gtk_container_add (GTK_CONTAINER (frame), vbox);
	gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);
	dform->radio_runnable = gtk_radio_button_new_with_mnemonic (NULL,
				_("_Runnable"));
	dform->radio_pause = gtk_radio_button_new_with_mnemonic_from_widget (
				(GtkRadioButton*)dform->radio_runnable, _("P_ause"));
	gtk_box_pack_start (GTK_BOX (vbox), dform->radio_runnable, FALSE, FALSE, 1);
	gtk_box_pack_start (GTK_BOX (vbox), dform->radio_pause, FALSE, FALSE, 1);

	// ----------------------------------------------------
	// frame for login
	frame = gtk_frame_new (_("Login"));
	table = (GtkTable*) gtk_table_new (2, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 2);
	gtk_container_add (GTK_CONTAINER (frame), (GtkWidget*) table);
	gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 2);
	// user
	label = gtk_label_new (_("User:"));
	entry = gtk_entry_new ();
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_table_attach (table, label, 0, 1, 0, 1,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 2, 1);
	gtk_table_attach (table, entry, 1, 2, 0, 1,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_entry_changed), dform);
	dform->username_entry = entry;
//	dform->username_label = label;
	// password
	label = gtk_label_new (_("Password:"));
	entry = gtk_entry_new ();
	gtk_entry_set_visibility (GTK_ENTRY (entry), FALSE);
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_table_attach (table, label, 0, 1, 1, 2,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 2, 1);
	gtk_table_attach (table, entry, 1, 2, 1, 2,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_entry_changed), dform);
	dform->password_entry = entry;
//	dform->password_label = label;

	// ----------------------------------------------------
	// frame for option
	frame = gtk_frame_new (_("Options"));
	table = (GtkTable*) gtk_table_new (2, 5, FALSE);
	gtk_container_add (GTK_CONTAINER (frame), (GtkWidget*) table);
	gtk_container_set_border_width (GTK_CONTAINER (table), 2);
	gtk_table_attach (top_table, frame, 0, 3, 5, 6,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	// Retry limit
	dform->spin_retry = gtk_spin_button_new_with_range (0.0, 99.0, 1.0);
	label = gtk_label_new_with_mnemonic (_("Retry _limit:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), dform->spin_retry);
	gtk_table_attach (table, label, 0, 1, 0, 1,
			GTK_SHRINK, GTK_SHRINK, 2, 1);
	gtk_table_attach (table, dform->spin_retry, 1, 2, 0, 1,
			GTK_SHRINK, GTK_SHRINK, 2, 1);
	g_signal_connect (GTK_EDITABLE (dform->spin_retry), "changed",
			G_CALLBACK (on_spin_changed), dform);
	// Retry delay
	dform->spin_delay = gtk_spin_button_new_with_range (0.0, 600.0, 1.0);
	label = gtk_label_new_with_mnemonic (_("Retry _delay:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), dform->spin_delay);
	gtk_table_attach (table, label, 0, 1, 1, 2,
			GTK_SHRINK, GTK_SHRINK, 2, 1);
	gtk_table_attach (table, dform->spin_delay, 1, 2, 1, 2,
			GTK_SHRINK, GTK_SHRINK, 2, 1);
	g_signal_connect (GTK_EDITABLE (dform->spin_delay), "changed",
			G_CALLBACK (on_spin_changed), dform);
	// separator
	gtk_table_attach (table, gtk_vseparator_new (), 2, 3, 0, 2,
			GTK_FILL, GTK_FILL, 2, 1);
	// cookie
	label = gtk_label_new (_("Cookie:"));
	entry = gtk_entry_new ();
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_entry_set_icon_from_stock (GTK_ENTRY (entry),
			GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_FILE);
	gtk_entry_set_icon_tooltip_text (GTK_ENTRY (entry),
			GTK_ENTRY_ICON_SECONDARY, _("Select Cookie File"));
	gtk_table_attach (table, label, 3, 4, 0, 1,
			GTK_SHRINK, GTK_SHRINK, 2, 1);
	gtk_table_attach (table, entry, 4, 5, 0, 1,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (entry, "icon-release",
			G_CALLBACK (on_select_cookie), dform);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_http_entry_changed), dform);
	dform->cookie_entry = entry;
//	dform->cookie_label = label;
	// post
	label = gtk_label_new (_("Post:"));
	entry = gtk_entry_new ();
	gtk_entry_set_activates_default (GTK_ENTRY (entry), TRUE);
	gtk_entry_set_icon_from_stock (GTK_ENTRY (entry),
			GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_FILE);
	gtk_entry_set_icon_tooltip_text (GTK_ENTRY (entry),
			GTK_ENTRY_ICON_SECONDARY, _("Select Post File"));
	gtk_table_attach (table, label, 3, 4, 1, 2,
			GTK_SHRINK, GTK_SHRINK, 2, 1);
	gtk_table_attach (table, entry, 4, 5, 1, 2,
			GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (entry, "icon-release",
			G_CALLBACK (on_select_post), dform);
	g_signal_connect (GTK_EDITABLE (entry), "changed",
			G_CALLBACK (on_http_entry_changed), dform);
	dform->post_entry = entry;
//	dform->post_label = label;

	// ----------------------------------------------------
	// proxy
//	ug_proxy_widget_init (&dform->proxy_dform, TRUE);
	if (proxy)
		gtk_table_attach (top_table, proxy->self, 0, 3, 6, 7,
				GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);

	gtk_widget_show_all (dform->self);
}

void	ug_download_form_get  (UgDownloadForm* dform, UgDataset* dataset)
{
	UgDataCommon*	common;
	UgDataHttp*		http;
	UgRelationGtk*	relation;
	UgUriFull		urifull;
	const gchar*	text;

	// UgDataCommon
	common = ug_dataset_realloc (dataset, UgDataCommonClass, 0);
	ug_str_set (&common->folder,   gtk_entry_get_text ((GtkEntry*)dform->folder_entry),   -1);
	ug_str_set (&common->user,     gtk_entry_get_text ((GtkEntry*)dform->username_entry), -1);
	ug_str_set (&common->password, gtk_entry_get_text ((GtkEntry*)dform->password_entry), -1);
	common->retry_limit = gtk_spin_button_get_value_as_int ((GtkSpinButton*) dform->spin_retry);
	common->retry_delay = gtk_spin_button_get_value_as_int ((GtkSpinButton*) dform->spin_delay);
	if (gtk_widget_is_sensitive (dform->url_entry) == TRUE) {
		ug_str_set (&common->url,  gtk_entry_get_text ((GtkEntry*)dform->url_entry),  -1);
		ug_str_set (&common->file, gtk_entry_get_text ((GtkEntry*)dform->file_entry), -1);
		if (common->url) {
			ug_uri_full_init (&urifull, common->url);
			// set user
			text = ug_uri_full_get_user (&urifull);
			if (text) {
				g_free (common->user);
				common->user = (gchar*) text;
			}
			// set password
			text = ug_uri_full_get_password (&urifull);
			if (text) {
				g_free (common->password);
				common->password = (gchar*) text;
			}
			// Remove user & password from URL
			if (urifull.authority != urifull.host) {
				memmove ((char*) urifull.authority, (char*) urifull.host,
						strlen (urifull.host) + 1);
			}
		}
	}

	// UgDataHttp
	text = gtk_entry_get_text ((GtkEntry*) dform->referrer_entry);
	if (*text) {
		http = ug_dataset_realloc (dataset, UgDataHttpClass, 0);
		ug_str_set (&http->referrer, text, -1);
	}
	text = gtk_entry_get_text ((GtkEntry*) dform->cookie_entry);
	if (*text) {
		http = ug_dataset_realloc (dataset, UgDataHttpClass, 0);
		ug_str_set (&http->cookie_file, text, -1);
	}
	text = gtk_entry_get_text ((GtkEntry*) dform->post_entry);
	if (*text) {
		http = ug_dataset_realloc (dataset, UgDataHttpClass, 0);
		ug_str_set (&http->post_file, text, -1);
	}

	// UgRelation
	if (gtk_widget_get_sensitive (dform->radio_pause)) {
		relation = ug_dataset_realloc (dataset, UgRelationGtkClass, 0);
		if (gtk_toggle_button_get_active ((GtkToggleButton*) dform->radio_pause))
			relation->hints |=  UG_HINT_PAUSED;
		else
			relation->hints &= ~UG_HINT_PAUSED;
	}
}

void	ug_download_form_set (UgDownloadForm* dform, UgDataset* dataset, gboolean keep_changed)
{
	UgDataCommon*	common;
	UgDataHttp*		http;
	UgRelationGtk*	relation;

	common = ug_dataset_get (dataset, UgDataCommonClass, 0);
	http   = ug_dataset_get (dataset, UgDataHttpClass, 0);

	// disable changed flags
	dform->changed.enable = FALSE;
	// UgDataCommon
	// set changed flags
	if (keep_changed==FALSE && common) {
		dform->changed.url      = common->keeping.url;
		dform->changed.file     = common->keeping.file;
		dform->changed.folder   = common->keeping.folder;
		dform->changed.user     = common->keeping.user;
		dform->changed.password = common->keeping.password;
		dform->changed.retry    = common->keeping.retry_limit;
		dform->changed.delay    = common->keeping.retry_delay;
	}
	// set data
	if (keep_changed==FALSE || dform->changed.url==FALSE) {
		if (gtk_widget_is_sensitive (dform->url_entry)) {
			gtk_entry_set_text ((GtkEntry*) dform->url_entry,
					(common && common->url)  ? common->url  : "");
		}
	}
	if (keep_changed==FALSE || dform->changed.file==FALSE) {
		if (gtk_widget_is_sensitive (dform->file_entry)) {
			gtk_entry_set_text ((GtkEntry*) dform->file_entry,
					(common && common->file) ? common->file : "");
			// set changed flags
			if (common && common->file)
				dform->changed.file = TRUE;
		}
	}
	if (keep_changed==FALSE || dform->changed.folder==FALSE) {
		gtk_entry_set_text ((GtkEntry*) dform->folder_entry,
				(common && common->folder) ? common->folder : "");
	}
	if (keep_changed==FALSE || dform->changed.user==FALSE) {
		gtk_entry_set_text ((GtkEntry*) dform->username_entry,
				(common && common->user) ? common->user : "");
	}
	if (keep_changed==FALSE || dform->changed.password==FALSE) {
		gtk_entry_set_text ((GtkEntry*) dform->password_entry,
				(common && common->password) ? common->password : "");
	}
	if (keep_changed==FALSE || dform->changed.retry==FALSE) {
		gtk_spin_button_set_value ((GtkSpinButton*) dform->spin_retry,
				(common) ? common->retry_limit : 99);
	}
	if (keep_changed==FALSE || dform->changed.delay==FALSE) {
		gtk_spin_button_set_value ((GtkSpinButton*) dform->spin_delay,
				(common) ? common->retry_delay : 6);
	}

	// UgDataHttp
	// set data
	if (keep_changed==FALSE || dform->changed.referrer==FALSE) {
		gtk_entry_set_text ((GtkEntry*) dform->referrer_entry,
				(http && http->referrer) ? http->referrer : "");
	}
	if (keep_changed==FALSE || dform->changed.cookie==FALSE) {
		gtk_entry_set_text ((GtkEntry*) dform->cookie_entry,
				(http && http->cookie_file) ? http->cookie_file : "");
	}
	if (keep_changed==FALSE || dform->changed.post==FALSE) {
		gtk_entry_set_text ((GtkEntry*) dform->post_entry,
				(http && http->post_file) ? http->post_file : "");
	}
	// set changed flags
	if (keep_changed==FALSE && http) {
		dform->changed.referrer = http->keeping.referrer;
		dform->changed.cookie   = http->keeping.cookie_file;
		dform->changed.post     = http->keeping.post_file;
	}

	// UgRelation
	if (gtk_widget_get_sensitive (dform->radio_pause)) {
		relation = ug_dataset_realloc (dataset, UgRelationGtkClass, 0);
		if (relation->hints & UG_HINT_PAUSED)
			gtk_toggle_button_set_active ((GtkToggleButton*) dform->radio_pause, TRUE);
		else
			gtk_toggle_button_set_active ((GtkToggleButton*) dform->radio_runnable, TRUE);
	}

	// enable changed flags
	dform->changed.enable = TRUE;
	// complete entry
	ug_download_form_complete_entry (dform);
}

void	ug_download_form_set_multiple (UgDownloadForm* dform, gboolean multiple_mode)
{
//	dform->multiple = multiple_mode;

	if (multiple_mode) {
		gtk_widget_hide (dform->url_label);
		gtk_widget_hide (dform->url_entry);
		gtk_widget_hide (dform->file_label);
		gtk_widget_hide (dform->file_entry);
	}
	else {
		gtk_widget_show (dform->url_label);
		gtk_widget_show (dform->url_entry);
		gtk_widget_show (dform->file_label);
		gtk_widget_show (dform->file_entry);
	}

	multiple_mode = !multiple_mode;
	gtk_widget_set_sensitive (dform->url_label,  multiple_mode);
	gtk_widget_set_sensitive (dform->url_entry,  multiple_mode);
	gtk_widget_set_sensitive (dform->file_label, multiple_mode);
	gtk_widget_set_sensitive (dform->file_entry, multiple_mode);
}

void	ug_download_form_set_relation (UgDownloadForm* dform, gboolean relation_mode)
{
	gtk_widget_set_sensitive (dform->radio_pause,    relation_mode);
	gtk_widget_set_sensitive (dform->radio_runnable, relation_mode);
}

void	ug_download_form_set_folder_list (UgDownloadForm* dform, GList* folder_list)
{
	GtkComboBox*	combo;

	combo = (GtkComboBox*) dform->folder_combo;
	for (;  folder_list;  folder_list = folder_list->next)
		gtk_combo_box_append_text (combo, folder_list->data);
}

void	ug_download_form_get_folder_list (UgDownloadForm* dform, GList** folder_list)
{
	GtkComboBox*	combo;
	const gchar*	current;
	GList*			link;
	guint			length;

	combo   = (GtkComboBox*) dform->folder_combo;
	current = gtk_entry_get_text ((GtkEntry*) dform->folder_entry);
	if (*current == 0)
		return;

	for (link = *folder_list;  link;  link = link->next) {
		if (strcmp (current, link->data) == 0) {
			*folder_list = g_list_remove_link (*folder_list, link);
			*folder_list = g_list_prepend (*folder_list, link->data);
			g_list_free_1 (link);
			return;
		}
	}

	length = g_list_length (*folder_list);
	if (length >= 8) {
		link = g_list_last (*folder_list);
		*folder_list = g_list_remove_link (*folder_list, link);
		g_free (link->data);
		g_list_free_1 (link);
	}
	*folder_list = g_list_prepend (*folder_list, g_strdup (current));
}

void	ug_download_form_complete_entry (UgDownloadForm* dform)
{
	UgUriFull		urifull;
	const gchar*	text;
	gchar*			temp;
	gboolean		completed;

	// URL
	text = gtk_entry_get_text ((GtkEntry*) dform->url_entry);
	ug_uri_full_init (&urifull, text);
	if (urifull.host) {
		// disable changed flags
		dform->changed.enable = FALSE;
		// complete file entry
		text = gtk_entry_get_text ((GtkEntry*) dform->file_entry);
		if (text[0] == 0 || dform->changed.file == FALSE) {
			temp = ug_uri_full_get_file (&urifull);
			gtk_entry_set_text ((GtkEntry*) dform->file_entry,
					(temp) ? temp : "index.htm");
			g_free (temp);
		}
/*
		// complete user entry
		text = gtk_entry_get_text ((GtkEntry*) dform->username_entry);
		if (text[0] == 0 || dform->changed.user == FALSE) {
			temp = ug_uri_full_get_user (&urifull);
			gtk_entry_set_text ((GtkEntry*) dform->username_entry,
					(temp) ? temp : "");
			g_free (temp);
		}
		// complete password entry
		text = gtk_entry_get_text ((GtkEntry*) dform->password_entry);
		if (text[0] == 0 || dform->changed.password == FALSE) {
			temp = ug_uri_full_get_password (&urifull);
			gtk_entry_set_text ((GtkEntry*) dform->password_entry,
					(temp) ? temp : "");
			g_free (temp);
		}
*/
		// enable changed flags
		dform->changed.enable = TRUE;
		// status
		completed = TRUE;
	}
	else if (gtk_widget_is_sensitive (dform->url_entry) == FALSE)
		completed = TRUE;
	else
		completed = FALSE;

	if (dform->notify_func)
		dform->notify_func (dform->notify_data, completed);
}

// ----------------------------------------------------------------------------
// signal handler
static void	on_spin_changed (GtkEditable* editable, UgDownloadForm* dform)
{
	if (dform->changed.enable) {
		if (editable == GTK_EDITABLE (dform->spin_retry))
			dform->changed.retry = TRUE;
		else if (editable == GTK_EDITABLE (dform->spin_delay))
			dform->changed.delay = TRUE;
	}
}

static void on_entry_changed (GtkEditable* editable, UgDownloadForm* dform)
{
	if (dform->changed.enable) {
		if (editable == GTK_EDITABLE (dform->file_entry))
			dform->changed.file = TRUE;
		else if (editable == GTK_EDITABLE (dform->folder_entry))
			dform->changed.folder = TRUE;
		else if (editable == GTK_EDITABLE (dform->username_entry))
			dform->changed.user = TRUE;
		else if (editable == GTK_EDITABLE (dform->password_entry))
			dform->changed.password = TRUE;
	}
}

static void	on_url_entry_changed (GtkEditable* editable, UgDownloadForm* dform)
{
	if (dform->changed.enable) {
		dform->changed.url = TRUE;
		ug_download_form_complete_entry (dform);
	}
}

static void	on_http_entry_changed (GtkEditable* editable, UgDownloadForm* dform)
{
	if (dform->changed.enable) {
		if (editable == GTK_EDITABLE (dform->referrer_entry))
			dform->changed.referrer = TRUE;
		else if (editable == GTK_EDITABLE (dform->cookie_entry))
			dform->changed.cookie = TRUE;
		else if (editable == GTK_EDITABLE (dform->post_entry))
			dform->changed.post = TRUE;
	}
}

static void on_select_folder_response (GtkDialog* chooser, gint response, UgDownloadForm* dform)
{
	gchar*	file;
	gchar*	path;

	if (response == GTK_RESPONSE_OK ) {
		file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (chooser));
		path = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
		gtk_entry_set_text (GTK_ENTRY (dform->folder_entry), path);
		g_free (path);
		g_free (file);
	}
	gtk_widget_destroy (GTK_WIDGET (chooser));

	if (dform->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dform->parent, TRUE);
}

static void	on_select_folder (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkEvent* event, UgDownloadForm* dform)
{
	GtkWidget*	chooser;
	gchar*		path;
	gchar*		title;

	// disable sensitive of parent window
	// enable sensitive in function on_file_chooser_response()
	if (dform->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dform->parent, FALSE);

	title = g_strconcat (UGET_GTK_NAME " - ", _("Select Folder"), NULL);
	chooser = gtk_file_chooser_dialog_new (title, dform->parent,
			GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OK,     GTK_RESPONSE_OK,
			NULL);
	g_free (title);
	gtk_window_set_transient_for ((GtkWindow*) chooser, dform->parent);
	gtk_window_set_destroy_with_parent ((GtkWindow*) chooser, TRUE);

	path = (gchar*) gtk_entry_get_text ((GtkEntry*) dform->folder_entry);
	if (*path) {
		path = g_filename_from_utf8 (path, -1, NULL, NULL, NULL);
		gtk_file_chooser_select_filename (GTK_FILE_CHOOSER (chooser), path);
		g_free (path);
	}
	g_signal_connect (chooser, "response",
			G_CALLBACK (on_select_folder_response), dform);

	if (gtk_window_get_modal (dform->parent))
		gtk_dialog_run ((GtkDialog*) chooser);
	else {
		gtk_window_set_modal ((GtkWindow*) chooser, FALSE);
		gtk_widget_show (chooser);
	}
}

static void on_select_cookie_response (GtkDialog* chooser, gint response, UgDownloadForm* dform)
{
	gchar*	file;
	gchar*	path;

	if (response == GTK_RESPONSE_OK ) {
		file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (chooser));
		path = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
		gtk_entry_set_text (GTK_ENTRY (dform->cookie_entry), path);
		g_free (path);
		g_free (file);
	}
	gtk_widget_destroy (GTK_WIDGET (chooser));

	if (dform->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dform->parent, TRUE);
}

static void	on_select_cookie (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkEvent* event, UgDownloadForm* dform)
{
	GtkWidget*	chooser;
	gchar*		path;
	gchar*		title;

	// disable sensitive of parent window
	// enable sensitive in function on_file_chooser_response()
	if (dform->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dform->parent, FALSE);

	title = g_strconcat (UGET_GTK_NAME " - ", _("Select Cookie File"), NULL);
	chooser = gtk_file_chooser_dialog_new (title, dform->parent,
			GTK_FILE_CHOOSER_ACTION_OPEN,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OK,     GTK_RESPONSE_OK,
			NULL);
	g_free (title);
	gtk_window_set_transient_for ((GtkWindow*) chooser, dform->parent);
	gtk_window_set_destroy_with_parent ((GtkWindow*) chooser, TRUE);

	path = (gchar*) gtk_entry_get_text ((GtkEntry*) dform->cookie_entry);
	if (*path) {
		path = g_filename_from_utf8 (path, -1, NULL, NULL, NULL);
		gtk_file_chooser_select_filename (GTK_FILE_CHOOSER (chooser), path);
		g_free (path);
	}
	g_signal_connect (chooser, "response",
			G_CALLBACK (on_select_cookie_response), dform);

	if (gtk_window_get_modal (dform->parent))
		gtk_dialog_run ((GtkDialog*) chooser);
	else {
		gtk_window_set_modal ((GtkWindow*) chooser, FALSE);
		gtk_widget_show (chooser);
	}
}

static void on_select_post_response (GtkDialog* chooser, gint response, UgDownloadForm* dform)
{
	gchar*	file;
	gchar*	path;

	if (response == GTK_RESPONSE_OK ) {
		file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (chooser));
		path = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
		gtk_entry_set_text (GTK_ENTRY (dform->post_entry), path);
		g_free (path);
		g_free (file);
	}
	gtk_widget_destroy (GTK_WIDGET (chooser));

	if (dform->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dform->parent, TRUE);
}

static void	on_select_post (GtkEntry* entry, GtkEntryIconPosition icon_pos, GdkEvent* event, UgDownloadForm* dform)
{
	GtkWidget*	chooser;
	gchar*		path;
	gchar*		title;

	// disable sensitive of parent window
	// enable sensitive in function on_file_chooser_response()
	if (dform->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dform->parent, FALSE);

	title = g_strconcat (UGET_GTK_NAME " - ", _("Select Post File"), NULL);
	chooser = gtk_file_chooser_dialog_new (title, dform->parent,
			GTK_FILE_CHOOSER_ACTION_OPEN,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OK,     GTK_RESPONSE_OK,
			NULL);
	g_free (title);
	gtk_window_set_transient_for ((GtkWindow*) chooser, dform->parent);
	gtk_window_set_destroy_with_parent ((GtkWindow*) chooser, TRUE);

	path = (gchar*) gtk_entry_get_text ((GtkEntry*) dform->post_entry);
	if (*path) {
		path = g_filename_from_utf8 (path, -1, NULL, NULL, NULL);
		gtk_file_chooser_select_filename (GTK_FILE_CHOOSER (chooser), path);
		g_free (path);
	}
	g_signal_connect (chooser, "response",
			G_CALLBACK (on_select_post_response), dform);

	if (gtk_window_get_modal (dform->parent))
		gtk_dialog_run ((GtkDialog*) chooser);
	else {
		gtk_window_set_modal ((GtkWindow*) chooser, FALSE);
		gtk_widget_show (chooser);
	}
}

