/***************************************************************************
                                   Options.cpp
                              -------------------

     Begin        : Mon May 12 2008 12:13 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the options window

****************************************************************************/

#include "env.h"
#include "Options.h"
#include "structDef.h"

/** \brief Constructor of the options dialog

It initialise the box with the user value stored in the file or with the default value.
\see ~optionsDialog()
*/
optionsDialog::optionsDialog()
{
	langHaveChanged		= false;
	MaxSpeedValueInt	= 0;
	DEBUGCONSOLE(30,"optionsDialog::optionsDialog","start");
	//setup the interface
	setupUi(this);
	layout()->setSizeConstraint(QLayout::SetFixedSize);
	tabWidget->setCurrentIndex(0);
	
	//connect the button
	connect(applyButton,		SIGNAL(clicked()),		this, SLOT(apply()));
	connect(okButton,		SIGNAL(clicked()),		this, SLOT(ok()));
	
	//connect for speed
	connect(limitSpeed,		SIGNAL(valueChanged(int)),	this, SLOT(abstractLayerGetSpeed()));
	connect(checkBox_limitSpeed,	SIGNAL(stateChanged(int)),	this, SLOT(abstractLayerGetSpeed()));
	connect(SliderSpeed,		SIGNAL(valueChanged(int)),	this, SLOT(abstractLayerGetSpeed()));
	connect(comboBox_TypeSpeedMax,	SIGNAL(currentIndexChanged(int)), this, SLOT(abstractLayerUpdateSpeedType()));
	
	//get path Of Resource
	QStringList pathOfResource(getPathOfResource());
	
	//load the external language
	QList<translatorLang> theTranslations=getTheTranslations();
	for (int i = 0; i < theTranslations.size(); ++i) {
		if(comboBoxLang->findText(theTranslations.at(i).fullName)==-1)
		{
			DEBUGCONSOLE(70,"optionsDialog::optionsDialog","name not found: "+theTranslations.at(i).fullName);
			comboBoxLang->addItem(QIcon(theTranslations.at(i).image),theTranslations.at(i).fullName);
		}
	}
	
	//load the external style
	for (int i = 0; i < pathOfResource.size(); ++i) {
		QDir dir(pathOfResource.at(i)+"styles/");
		QFileInfoList list = dir.entryInfoList();
		for (int j = 0; j < list.size(); ++j)
		{
			QFileInfo fileInfo(list.at(j));
			QString name=fileInfo.fileName();
			if(fileInfo.isDir())
				if(QFile(pathOfResource.at(i)+"styles/"+name+"/main.png").exists())
				{
					if(comboBoxStyle->findText(name)==-1)
						comboBoxStyle->addItem(QIcon(pathOfResource.at(i)+"styles/"+name+"/main.png"),name);
				}
		}
	}
	
	comboBoxStyleWidget->addItems(QStyleFactory::keys());
	
	#ifdef ULTRACOPIER_MODE_WINDOWS
	checkBoxPreallocate->setChecked(true);
	checkBoxEnabledStart->setChecked(true);
	#endif
	
	//load the settings
	QSettings *theSettings=getSettingsRes();
	if(theSettings->status()==QSettings::NoError)
	{
		theSettings->beginGroup("theCopy");
		if(theSettings->contains("comboBox_copyEnd"))
			comboBox_copyEnd->setCurrentIndex(theSettings->value("comboBox_copyEnd").toInt());
		if(theSettings->contains("comboBox_fileCollisions"))
			comboBox_fileCollisions->setCurrentIndex(theSettings->value("comboBox_fileCollisions").toInt());
		if(theSettings->contains("comboBox_copyErrors"))
			comboBox_copyErrors->setCurrentIndex(theSettings->value("comboBox_copyErrors").toInt());
		if(theSettings->contains("MaxSpeed"))
			abstractLayerSetSpeed(theSettings->value("MaxSpeed").toInt());
		theSettings->endGroup();
		theSettings->beginGroup("starting");
		if(theSettings->contains("checkBoxEnabledStart"))
			checkBoxEnabledStart->setChecked(theSettings->value("checkBoxEnabledStart").toBool());
		theSettings->endGroup();
		theSettings->beginGroup("Interface");
		if(theSettings->contains("comboBoxLang"))
		{
			if(theTranslationExists(theSettings->value("comboBoxLang").toString()))
			{
				translatorLang newLang=getTheTranslation(theSettings->value("comboBoxLang").toString());
				lastLangIndex=comboBoxLang->findText(newLang.fullName);
				if(lastLangIndex!=-1)
					comboBoxLang->setCurrentIndex(lastLangIndex);
			}
		}
		if(theSettings->contains("checkBoxOnTop"))
			checkBoxOnTop->setChecked(theSettings->value("checkBoxOnTop").toBool());
		if(theSettings->contains("checkBoxLang"))
			checkBoxLang->setChecked(theSettings->value("checkBoxLang").toBool());
		comboBoxLang->setEnabled(!checkBoxLang->isChecked());
		int index;
		if(theSettings->contains("comboBoxStyle"))
			index=comboBoxStyle->findText(theSettings->value("comboBoxStyle").toString());
		else
			index=comboBoxStyle->findText(ULTRACOPIER_DEFAULT_STYLE);
		if(index!=-1)
			comboBoxStyle->setCurrentIndex(index);
		if(theSettings->contains("comboBoxStyleWidget"))
		{
			int index=comboBoxStyleWidget->findText(theSettings->value("comboBoxStyleWidget").toString());
			if(index!=-1)
			{
				checkBoxForceStyle->setChecked(true);
				comboBoxStyleWidget->setEnabled(true);
				comboBoxStyleWidget->setCurrentIndex(index);
			}
		}
		if(theSettings->contains("comboBoxGroupWindows"))
		{
			int index=comboBoxGroupWindows->findText(theSettings->value("comboBoxGroupWindows").toString());
			if(index!=-1)
				comboBoxGroupWindows->setCurrentIndex(index);
		}
		theSettings->endGroup();
		theSettings->beginGroup("CopyManagement");
		if(theSettings->contains("checkBoxDisableAutoStart"))
			checkBoxDisableAutoStart->setChecked(theSettings->value("checkBoxDisableAutoStart").toBool());
		if(theSettings->contains("checkBoxRightCopy"))
			checkBoxRightCopy->setChecked(theSettings->value("checkBoxRightCopy").toBool());
		if(theSettings->contains("checkWriteThread"))
			checkWriteThread->setChecked(theSettings->value("checkWriteThread").toBool());
		if(theSettings->contains("checkBoxSystray"))
			checkBoxSystray->setChecked(theSettings->value("checkBoxSystray").toBool());
		if(theSettings->contains("checkBoxKeepDate"))
			checkBoxKeepDate->setChecked(theSettings->value("checkBoxKeepDate").toBool());
		if(theSettings->contains("comboBox_statusBar"))
			comboBox_statusBar->setCurrentIndex(theSettings->value("comboBox_statusBar").toInt());
		if(theSettings->contains("comboBox_TypeSpeedMax"))
		{
			int index=comboBox_TypeSpeedMax->findText(theSettings->value("comboBox_TypeSpeedMax").toString());
			if(index!=-1)
				comboBox_TypeSpeedMax->setCurrentIndex(index);
		}
		theSettings->endGroup();
		theSettings->beginGroup("Advanced");
		if(theSettings->contains("comboBox_Priority"))
		{
			int index=theSettings->value("comboBox_Priority").toInt();
			if(index<0 || index>3)
				index=2;
			comboBox_Priority->setCurrentIndex(index);
		}
		if(theSettings->contains("spinBoxBlock"))
		{
			int index=theSettings->value("spinBoxBlock").toInt();
			if(index<1 || index>16384)
				index=64;
			spinBoxBlock->setValue(index);
		}
		if(theSettings->contains("checkBoxPreallocate"))
			checkBoxPreallocate->setChecked(theSettings->value("checkBoxPreallocate").toBool());
		theSettings->endGroup();
	}
	abstractLayerUpdateSpeedType();
	this->UpdateStyle();
	QString checkBoxStartText=tr("Start ultracopier when you start your session");
	QString checkBoxEnabledStartText=tr("Enabled Ultracopier when it start");
	#ifdef ULTRACOPIER_MODE_WINDOWS
	//for autostart
	checkBoxStart->setEnabled(true);
	checkBoxStart->setText(checkBoxStartText);
	checkBoxEnabledStart->setEnabled(true);
	checkBoxEnabledStart->setText(checkBoxEnabledStartText);
	checkBoxStart->setChecked(getOpenWithSession());
	#endif
	
	connect(comboBoxLang, SIGNAL(currentIndexChanged(int)), this, SLOT(updateLangBool()));
}

/** \brief Save the settings

Save the settings in the settings file
*/
void optionsDialog::apply()
{
	DEBUGCONSOLE(30,"optionsDialog::apply","start");
	resetQIconCache();
	QSettings *theSettings=getSettingsRes();
	theSettings->clear();
	//save the copy settings
	theSettings->beginGroup("theCopy");
	theSettings->setValue("comboBox_copyEnd",	comboBox_copyEnd->currentIndex());
	theSettings->setValue("comboBox_fileCollisions",comboBox_fileCollisions->currentIndex());
	theSettings->setValue("comboBox_copyErrors",	comboBox_copyErrors->currentIndex());
	theSettings->setValue("MaxSpeed",		MaxSpeedValueInt);
	theSettings->endGroup();
	//save the settings of the interface
	theSettings->beginGroup("Interface");
	theSettings->setValue("comboBoxGroupWindows",	comboBoxGroupWindows->currentText());
	QList<translatorLang> listTranslations=getTheTranslations();
	for (int i = 0; i < listTranslations.size(); ++i) {
		if(listTranslations.at(i).fullName==comboBoxLang->currentText())
			theSettings->setValue("comboBoxLang",listTranslations.at(i).shortName.at(0));
	}
	theSettings->setValue("checkBoxLang",		checkBoxLang->isChecked());
	theSettings->setValue("checkBoxOnTop",		checkBoxOnTop->isChecked());
	theSettings->setValue("comboBoxStyle",		comboBoxStyle->currentText());
	if(checkBoxForceStyle->isChecked())
	{
		DEBUGCONSOLE(90,"optionsDialog::apply","style applied: "+comboBoxStyleWidget->currentText());
		QApplication::setStyle(comboBoxStyleWidget->currentText());
		theSettings->setValue("comboBoxStyleWidget",comboBoxStyleWidget->currentText());
	}
	else
	{
		DEBUGCONSOLE(90,"optionsDialog::apply","style applied: default");
		QApplication::setStyle("default");
		theSettings->remove("comboBoxStyleWidget");
	}
	theSettings->endGroup();
	theSettings->beginGroup("CopyManagement");
	theSettings->setValue("checkWriteThread",	checkWriteThread->isChecked());
	theSettings->setValue("checkBoxRightCopy",	checkBoxRightCopy->isChecked());
	theSettings->setValue("checkBoxSystray",	checkBoxSystray->isChecked());
	theSettings->setValue("checkBoxDisableAutoStart",checkBoxDisableAutoStart->isChecked());
	theSettings->setValue("checkBoxKeepDate",	checkBoxKeepDate->isChecked());
	theSettings->setValue("comboBox_TypeSpeedMax",	comboBox_TypeSpeedMax->currentText());
	theSettings->setValue("comboBox_statusBar",	comboBox_statusBar->currentIndex());
	theSettings->endGroup();
	theSettings->beginGroup("Advanced");
	theSettings->setValue("comboBox_Priority",	comboBox_Priority->currentIndex());
	theSettings->setValue("spinBoxBlock",		spinBoxBlock->value());
	theSettings->setValue("checkBoxPreallocate",	checkBoxPreallocate->isChecked());
	theSettings->endGroup();
	theSettings->beginGroup("starting");
	theSettings->setValue("checkBoxEnabledStart",	checkBoxEnabledStart->isChecked());
	theSettings->endGroup();
	if(theSettings->status()!=QSettings::NoError)
		QMessageBox::warning(NULL, tr("Error"),
		tr("Ultracopier can't save the settings, will not work correctly."),
		QMessageBox::Ok,
		QMessageBox::Ok);
	if(langHaveChanged)
	{
		QMessageBox::warning(NULL, tr("Warning"),
		tr("Ultracopier need be restarted.")+"\nUltracopier need be restarted.",
		QMessageBox::Ok,
		QMessageBox::Ok);
		langHaveChanged=false;
	}
	
	if(!checkBoxLang->isChecked())
		reloadTheTranslator(comboBoxLang->currentText());
	
	loadStyle();
	
	//run at the current user startup for windows
	setOpenWithSession(checkBoxStart->isChecked());

	
	//emit the order for update the style of all ultracopier
	emit OrderUpdateStyle();
	//emit the options have changed
	emit OptionsUpdated();
}

/// \brief Ok action, save the settings and quit
void optionsDialog::ok()
{
	apply();
	this->close();
}

/** \brief Get speed

Abstract Layer for get the speed, it stored in MaxSpeedValueInt
\see MaxSpeedValueInt
*/
void optionsDialog::abstractLayerGetSpeed()
{
	DEBUGCONSOLE(90,"optionsDialog::abstractLayerGetSpeed","start");
	if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
	{
		MaxSpeedValueInt=0;
		if(checkBox_limitSpeed->isChecked())
			MaxSpeedValueInt=limitSpeed->value();
	}
	else
	{
		MaxSpeedValueInt=SliderSpeed->sliderPosition();
		if(MaxSpeedValueInt<0 || MaxSpeedValueInt>7)
			MaxSpeedValueInt=0;
		switch(MaxSpeedValueInt)
		{
			case 1:
				MaxSpeedValueInt=1024;
			break;
			case 2:
				MaxSpeedValueInt=4*1024;
			break;
			case 3:
				MaxSpeedValueInt=8*1024;
			break;
			case 4:
				MaxSpeedValueInt=16*1024;
			break;
			case 5:
				MaxSpeedValueInt=32*1024;
			break;
			case 6:
				MaxSpeedValueInt=64*1024;
			break;
			case 7:
				MaxSpeedValueInt=128*1024;
			break;
		}
		UpdateSliderSpeedText();
	}
	DEBUGCONSOLE(90,"optionsDialog::abstractLayerGetSpeed","MaxSpeedValueInt: "+QString::number(MaxSpeedValueInt));
	UpdateSliderSpeedText();
}

/** \brief Update the speed type

Methode for choise what is the user input methode for give the speed
*/
void optionsDialog::abstractLayerUpdateSpeedType()
{
	DEBUGCONSOLE(90,"optionsDialog::abstractLayerUpdateSpeedType","update the speed type");
	if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
	{
		label_Slider_speed->setVisible(false);
		SliderSpeed->setVisible(false);
		label_SpeedMaxValue->setVisible(false);
		checkBox_limitSpeed->setVisible(true);
		limitSpeed->setVisible(true);
	}
	else
	{
		label_Slider_speed->setVisible(true);
		SliderSpeed->setVisible(true);
		label_SpeedMaxValue->setVisible(true);
		checkBox_limitSpeed->setVisible(false);
		limitSpeed->setVisible(false);
	}
	abstractLayerSetSpeed(MaxSpeedValueInt);
}

/** \brief Set speed

Abstract layer for set speed
*/
void optionsDialog::abstractLayerSetSpeed(int speed)
{
	DEBUGCONSOLE(90,"optionsDialog::abstractLayerSetSpeed","set speed at: "+QString::number(speed));
	if(speed<0)
		speed=0;
	if(!speed)
	{
		MaxSpeedValueInt=0;
		if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
		{
			checkBox_limitSpeed->setChecked(false);
			limitSpeed->setEnabled(false);
		}
		else
		{
			SliderSpeed->setSliderPosition(0);
			UpdateSliderSpeedText();
		}
	}
	else
	{
		MaxSpeedValueInt=speed;
		if(comboBox_TypeSpeedMax->currentText()==tr("Direct value"))
		{
			checkBox_limitSpeed->setChecked(true);
			limitSpeed->setEnabled(true);
			limitSpeed->setValue(speed);
		}
		else
		{
			if(speed>=128*1024 || speed<=0)
			{
				SliderSpeed->setSliderPosition(0);
				MaxSpeedValueInt=0;
			}
			else if(speed<=1024)
			{
				SliderSpeed->setSliderPosition(1);
				MaxSpeedValueInt=1024;
			}
			else if(speed<=4*1024)
			{
				SliderSpeed->setSliderPosition(2);
				MaxSpeedValueInt=4*1024;
			}
			else if(speed<=8*1024)
			{
				SliderSpeed->setSliderPosition(3);
				MaxSpeedValueInt=8*1024;
			}
			else if(speed<=16*1024)
			{
				SliderSpeed->setSliderPosition(4);
				MaxSpeedValueInt=16*1024;
			}
			else if(speed<=32*1024)
			{
				SliderSpeed->setSliderPosition(5);
				MaxSpeedValueInt=32*1024;
			}
			else if(speed<=64*1024)
			{
				SliderSpeed->setSliderPosition(6);
				MaxSpeedValueInt=64*1024;
			}
			else if(speed<=128*1024)
			{
				SliderSpeed->setSliderPosition(7);
				MaxSpeedValueInt=128*1024;
			}
			else
			{
				DEBUGCONSOLE(10,"optionsDialog::abstractLayerSetSpeed","error value wrong");
				SliderSpeed->setSliderPosition(0);
				MaxSpeedValueInt=0;
			}
		}
		UpdateSliderSpeedText();
	}
}

/// \brief Update the slider speed text
void optionsDialog::UpdateSliderSpeedText()
{
	DEBUGCONSOLE(90,"optionsDialog::UpdateSliderSpeedText","MaxSpeedValueInt: "+QString::number(MaxSpeedValueInt));
	if(MaxSpeedValueInt==0)
		label_SpeedMaxValue->setText(tr("Unlimited"));
	else
		label_SpeedMaxValue->setText(QString::number(MaxSpeedValueInt)+"K"+tr("B/s"));
}

/// \brief Update the style
void optionsDialog::UpdateStyle()
{
	//update style here
	okButton->setIcon(loadImage("ok.png"));
	cancelButton->setIcon(loadImage("cancel.png"));
	applyButton->setIcon(loadImage("apply.png"));
	this->setWindowIcon(loadImage("tools.png"));
	tabWidget->setTabIcon(0,loadImage("language.png"));
	tabWidget->setTabIcon(1,loadImage("launch.png"));
	tabWidget->setTabIcon(2,loadImage("options.png"));
	tabWidget->setTabIcon(3,loadImage("player_playlist.png"));
	tabWidget->setTabIcon(4,loadImage("advanced.png"));
}

/// \brief update the lang
void optionsDialog::updateLangBool()
{
	langHaveChanged=true;
}
