/***************************************************************************
                                   UIcon.h
                              -------------------

     Begin        : Sat May 3 2008 12:22 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the constructor and the methode of the error window

****************************************************************************/

#include "env.h"
#include "UIcon.h"
#include "Mwindow.h"
#include "Options.h"
#include <QPluginLoader>
#include <QMessageBox>
#include <QFileDialog>

#ifdef Q_OS_UNIX
#include <unistd.h>
#include <sys/types.h>
#define PATHSOCKET "advanced-copier-"+QString::number(getuid())
#endif

#if defined (Q_OS_WIN32) || defined (Q_OS_WINCE)
#include <windows.h>
#define PATHSOCKET "advanced-copier-"+UltracopierWindowsGetUserName()
#endif

/** \brief Constructor of the systray icon
\see ~UIcon()
*/
UIcon::UIcon()
{
	DEBUGCONSOLE(90,"UIcon::UIcon","start");
        UIconIsListen = false;
	localServer = new QLocalServer(this);
        #ifdef Q_OS_UNIX
        //prevent of problem of socket not removed
        localServer->removeServer(PATHSOCKET);
        #endif
        on_listen();
        
        theHelpDialog		= NULL;
	if(!UIconIsListen)
	{
		QMessageBox::critical(NULL,"Openning error","Ultracopier already open!");
		DEBUGCONSOLE(10,"UIcon::UIcon","Cannot create local server");
                QuitAction();
		QCoreApplication::exit();
	}
	else
	{
		connect(localServer, SIGNAL(newConnection()), this, SLOT(newConnexionUI()));
		
		//setup the systray icon
		sysTrayIcon = new QSystemTrayIcon(this);
		
		//setup menu
		systrayMenu =		new QMenu();
		IconQuit =		new QIcon(loadImage("exit.png"));
		IconInfo =		new QIcon(loadImage("info.png"));
		IconOptions =		new QIcon(loadImage("tools.png"));
		IconAdd =		new QIcon(loadImage("add.png"));
		#if (DEBUG_ULTRACOPIER>0)
		if(IconQuit->isNull() || IconInfo->isNull() || IconOptions->isNull() || IconAdd->isNull())
			DEBUGCONSOLE(10,"UIcon::UIcon","error loading the icons");
		#endif
		actionMenuQuit =	new QAction(tr("&Quit"),this);
		#if (DEBUG_ULTRACOPIER<=0)
		actionMenuAbout =	new QAction(tr("&About"),this);
		#else
		actionMenuAbout =	new QAction(tr("&About/Debug/Log"),this);
		#endif
		actionOptions =		new QAction(tr("&Options"),this);
		
		copyMenu =		new QMenu();
		actionCopy =		new QAction(tr("Add &copy"),this);
		actionMove =		new QAction(tr("Add &move"),this);
		copyMenu->addAction(actionCopy);
		copyMenu->addAction(actionMove);
		copyMenu->setTitle(tr("A&dd copy/moving"));
		
		systrayMenu->addMenu(copyMenu);
		systrayMenu->addAction(actionOptions);
		systrayMenu->addAction(actionMenuAbout);
		systrayMenu->addAction(actionMenuQuit);
		systrayMenu->insertSeparator(actionOptions);
		
		sysTrayIcon->setContextMenu(systrayMenu);
		
		//connect for the action
		connect(actionMove,	SIGNAL(triggered()), this, SLOT(MoveAction()));
		connect(actionCopy,	SIGNAL(triggered()), this, SLOT(CopyAction()));
		connect(actionOptions,	SIGNAL(triggered()), this, SLOT(OptiAction()));
		connect(actionMenuQuit, SIGNAL(triggered()), this, SLOT(QuitAction()));
		connect(actionMenuAbout,SIGNAL(triggered()), this, SLOT(HelpAction()));
		
		connect(sysTrayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), this, SLOT(CatchAction(QSystemTrayIcon::ActivationReason)));
		connect(this,SIGNAL(SignalPopup(QString)),this,SLOT(showDelayedPopup(QString)));

		iconActivBool=true;
		UpdateSsystrayIcon();
		TimerForTheDelayedPopup.setInterval(250);
		TimerForTheDelayedPopup.setSingleShot(true);
		connect(&TimerForTheDelayedPopup, SIGNAL(timeout()), this, SLOT(ShowPopupMessage()));
		TextOfTheDelayedPopup="";
		#if defined (Q_OS_WIN32) && (defined (_M_X64) || defined (_WIN64))
		sysTrayIcon->setToolTip(QString("Ultracopier x64"));
		#else
		sysTrayIcon->setToolTip(QString("Ultracopier"));
		#endif
		sysTrayIcon->show();
		
		TheOptions = NULL;
		
		//for dectect the timeout on QLocalSocket
		TimeOutQLocalSocket.setInterval(500);
		TimeOutQLocalSocket.setSingleShot(true);
		connect(&TimeOutQLocalSocket, SIGNAL(timeout()), this, SLOT(timeoutDectectedQLocalSocket()));

		//how many time wait before preallocation copy windows
		TimerForDelayedAllocation.setInterval(1000);
		TimerForDelayedAllocation.setSingleShot(true);
		connect(&TimerForDelayedAllocation, SIGNAL(timeout()), this, SLOT(preloadOneInstance()));
		
		//load the settings
		iconActivBool=false;
		QSettings *theSettings=getSettingsRes();
		if(theSettings->status()==QSettings::NoError)
		{
			theSettings->beginGroup("starting");
			if(theSettings->contains("checkBoxEnabledStart"))
				iconActivBool=theSettings->value("checkBoxEnabledStart").toBool();
			else
				iconActivBool=true;
			theSettings->endGroup();
			theSettings->beginGroup("Interface");
			if(theSettings->contains("comboBoxStyleWidget"))
				if(QStyleFactory::keys().indexOf(theSettings->value("comboBoxStyleWidget").toString())!=-1)
				{
					DEBUGCONSOLE(90,"UIcon::UIcon","style applied: "+theSettings->value("comboBoxStyleWidget").toString());
					QApplication::setStyle(theSettings->value("comboBoxStyleWidget").toString());
				}
			theSettings->endGroup();
		}
		QString errorMessage=setSystemCopyCatched(iconActivBool);
		if(errorMessage!="")
		{
			DEBUGCONSOLE(30,"UIcon::UIcon","errorMessage: "+errorMessage);
			iconActivBool=getSystemCopyCatched();
		}
		
		UpdateSsystrayIcon();

		windowIsPreloaded	= false;

		//preload 1 windows
		preloadOneInstance();
		
		//update the style
		this->UpdateStyle();

		#if (DEBUG_ULTRACOPIER>0)
		//check if it had crash
		if(QFile::exists(giveWritablePath("log/stdout.log.html.crash")))
		{
			QMessageBox::StandardButton reply=QMessageBox::question(NULL,tr("Crash of ultracopier"),tr("Ultracopier seem had been crashed.\nDo you want save the old log for report it?"),QMessageBox::Yes|QMessageBox::No);
			if(reply==QMessageBox::Yes)
			{
				QString fileName = QFileDialog::getSaveFileName(NULL, tr("Save file"),
					"ultracopier-repport.log.html",
					tr("Log file")+" (*.log)");
				if(fileName=="")
					 return;
				if(QFile::exists(fileName))
					QFile::remove(fileName);
				if(!QFile::copy(giveWritablePath("log/stdout.log.html.crash"),fileName))
					QMessageBox::critical(NULL,"Error","Unable to save advanced repport");
			}
			QFile::remove(giveWritablePath("log/stdout.log.html.crash"));
		}
		#endif
	}
}

/// \brief The destructor
UIcon::~UIcon()
{
	DEBUGCONSOLE(30,"UIcon::~UIcon","start");
	
	delete localServer;
	if(UIconIsListen)
	{
		//no control because it's closing
		setSystemCopyCatched(false);
		
		delete sysTrayIcon;
		delete systrayMenu;
		delete IconQuit;
		delete IconInfo;
		delete IconOptions;
		delete IconAdd;
		delete actionMenuQuit;
		delete actionMenuAbout;
		delete actionOptions;
		delete copyMenu;
		delete actionCopy;
		delete actionMove;
		delete TheOptions;
                theHelpDialog=NULL;
	}
}

//the time is done
void UIcon::timeoutDectectedQLocalSocket()
{
	DEBUGCONSOLE(50,"UIcon::timeoutDectectedQLocalSocket","start");
	while(listDataClient.size()>0)
	{
		DEBUGCONSOLE(90,"UIcon::timeoutDectectedQLocalSocket","listDataClient.first().size: "+QString::number(listDataClient.first().size));
		listDataClient.removeFirst();
	}
	DEBUGCONSOLE(10,"UIcon::timeoutDectectedQLocalSocket","Time out detected while recompose data from client connected");
	QMessageBox::warning(NULL,tr("Warning"),tr("Time out detected while recompose data from client connected"));
}

//For for a delayed popup thread safe
void UIcon::showDelayedPopupThreadSafe(const QString& text)
{
	emit SignalPopup(text);
}

/** \brief For for a delayed popup
\param text The text should be show
\param icon Which icon (and style) use
*/
void UIcon::showDelayedPopup(const QString& text,QSystemTrayIcon::MessageIcon icon)
{
	//If not in listen mode is useless to continu
	if(UIconIsListen)
	{
		MessageIconTheDelayedPopup=icon;
		if(!TimerForTheDelayedPopup.isActive())
			TimerForTheDelayedPopup.start();
		if(TextOfTheDelayedPopup.isEmpty())
			TextOfTheDelayedPopup=text;
		else
		{
			TextOfTheDelayedPopup+="\n";
			TextOfTheDelayedPopup+=text;
		}
	}
}

//append the log
#if (DEBUG_ULTRACOPIER>0)
void UIcon::appendLog(QString htmlFormat)
{
	if(theHelpDialog!=NULL)
		theHelpDialog->new_html_log(htmlFormat);
}
#endif

/** \brief For give to UIcon the application arguments

Should be create a copy or moving threads
The argument should be for copy:
cp file.txt file2.txt
cp folder/ dest/
cp folder1/ folder2/ dest/
cp file1.txt file2.txt dest/
Same with mv for move
\note cp = direct file name, Copy = File list
\param argumentsUltracopier List of arguments give to the application
\param client the client
\param copyId The copy id
\param protocolVersionOfThisQuery The version protocol
*/
void UIcon::dispatchParam(QStringList argumentsUltracopier,QLocalSocket * client,quint32 copyId,quint32 protocolVersionOfThisQuery)
{
	if(argumentsUltracopier.size()<=0)
	{
		DEBUGCONSOLE(10,"UIcon::dispatchParam","argumentsUltracopier.size() is <=0, it's not normal!");
		return;
	}
	else
	{
		//If not in listen mode is useless to continu
		if(UIconIsListen)
		{
			bool isOk=true;
			if(argumentsUltracopier.size()<3)
				isOk=false;
			else
			{
				DEBUGCONSOLE(30,"UIcon::dispatchParam","argumentsUltracopier.last(): "+argumentsUltracopier.last());
				QFileInfo theDest(argumentsUltracopier.last());
				if(theDest.isFile() && argumentsUltracopier.size()>3)
					isOk=false;
			}
			if(!isOk)
			{
				#if (DEBUG_ULTRACOPIER>0)
					DEBUGCONSOLE(30,"UIcon::dispatchParam","number of argument: "+QString::number(argumentsUltracopier.size()));
					for (int i = 0; i < argumentsUltracopier.size(); ++i) {
						DEBUGCONSOLE(30,"UIcon::dispatchParam","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
					}
				#endif
				if(argumentsUltracopier.at(0)=="AddEmpty")
				{
					DEBUGCONSOLE(30,"UIcon::dispatchParam","Open new copy windows, and first param: AddEmpty");
					Main_window *main=NULL;
					main = CopyAction();
				}
				else if(argumentsUltracopier.at(0)=="Running")
				{
					DEBUGCONSOLE(30,"UIcon::dispatchParam","Ultracopier is runnning!");
					showDelayedPopup("Ultracopier is runnning!",QSystemTrayIcon::Information);
				}
				else
				{
					DEBUGCONSOLE(10,"UIcon::dispatchParam","The last parameters should a folder if you have more than 4 arguments! Show the online help.");
					showDelayedPopup("The last parameters should a folder if you have\nmore than 4 arguments! Show the online help.",QSystemTrayIcon::Warning);
				}
			}
			else
			{
				bool moveQuery=true;
				if(argumentsUltracopier.size()>3 ||(QFileInfo(argumentsUltracopier.last()).isDir()))
				{
					if(!argumentsUltracopier.last().endsWith('/') && !argumentsUltracopier.last().endsWith('\\'))
						argumentsUltracopier.last()+=QDir::separator();
				}
				QString theCurrentArgument=argumentsUltracopier.at(0);
				DEBUGCONSOLE(30,"UIcon::dispatchParam","number of argument: "+QString::number(argumentsUltracopier.size()));
				for (int i = 0; i < argumentsUltracopier.size(); ++i) {
					if(QFileInfo(argumentsUltracopier.at(i)).isDir() && !argumentsUltracopier.at(i).endsWith('/') && !argumentsUltracopier.at(i).endsWith('\\'))
						argumentsUltracopier[i]+=QDir::separator();
					DEBUGCONSOLE(90,"UIcon::dispatchParam","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
				}
				#if (DEBUG_ULTRACOPIER>0)
				if(!(theCurrentArgument=="cp" || theCurrentArgument=="Copy" || theCurrentArgument=="mv" || theCurrentArgument=="Move"))
				{
					DEBUGCONSOLE(10,"UIcon::dispatchParam","First param note understand!");
					showDelayedPopup("First param note understand!",QSystemTrayIcon::Warning);
				}
				#endif

				//load here the right copy or move windows
				Main_window *main=NULL;
				QString comboBoxGroupWindows;
				QSettings *theSettings=getSettingsRes();
				if(theSettings->status()==QSettings::NoError)
				{
					theSettings->beginGroup("Interface");
					if(theSettings->contains("comboBoxGroupWindows"))
						comboBoxGroupWindows=theSettings->value("comboBoxGroupWindows").toString();
					theSettings->endGroup();
				}
				if(theCurrentArgument=="cp" || theCurrentArgument=="Copy")
					moveQuery=false;
				if(theCurrentArgument=="mv" || theCurrentArgument=="Move")
					moveQuery=true;
				//When same source
				//When same destination
				//When same source and destination
				QString destination,source="";
				if(QFileInfo(argumentsUltracopier.last()).isDir())
					destination=argumentsUltracopier.last();
				else
					destination=QFileInfo(argumentsUltracopier.last()).absoluteDir().path();
				for (int i=1; i<argumentsUltracopier.size()-1; ++i) {
					QString source2(argumentsUltracopier.at(i));
					if(QFileInfo(source2).isDir())
						source2=argumentsUltracopier.last();
					else
						source2=QFileInfo(argumentsUltracopier.last()).absoluteDir().path();
					if(source=="")
						source=source2;
					else if(source!=source2)
						source="*";
				}
				if(comboBoxGroupWindows==tr("When same source")) //try group copy
				{
					int size=theMainWindowCopyMove.size();
					if(windowIsPreloaded)
						size--;
					for (int i=0; i<size; ++i) {
						if(theMainWindowCopyMove.at(i)->getMovingMode()==moveQuery && theMainWindowCopyMove.at(i)->getMainSource()==source)
							main=theMainWindowCopyMove.at(i);
					}
				}
				if(comboBoxGroupWindows==tr("When same destination")) //try group copy
				{
					int size=theMainWindowCopyMove.size();
					if(windowIsPreloaded)
						size--;
					DEBUGCONSOLE(90,"UIcon::dispatchParam","destination: "+destination);
					for (int i=0; i<size; ++i) {
						DEBUGCONSOLE(90,"UIcon::dispatchParam","theMainWindowCopyMove.at("+QString::number(i)+")->getMainDestination(): "+theMainWindowCopyMove.at(i)->getMainDestination());
						if(theMainWindowCopyMove.at(i)->getMovingMode()==moveQuery && theMainWindowCopyMove.at(i)->getMainDestination()==destination)
							main=theMainWindowCopyMove.at(i);
					}
				}
				if(comboBoxGroupWindows==tr("When same source and destination")) //try group copy
				{
					int size=theMainWindowCopyMove.size();
					if(windowIsPreloaded)
						size--;
					for (int i=0; i<size; ++i) {
						if(theMainWindowCopyMove.at(i)->getMovingMode()==moveQuery &&
						   theMainWindowCopyMove.at(i)->getMainSource()==source &&
						   theMainWindowCopyMove.at(i)->getMainDestination()==destination)
							main=theMainWindowCopyMove.at(i);
					}
				}
				if(comboBoxGroupWindows==tr("Always")) //try group copy
				{
					int size=theMainWindowCopyMove.size();
					if(windowIsPreloaded)
						size--;
					for (int i=0; i<size; ++i) {
						if(theMainWindowCopyMove.at(i)->getMovingMode()==moveQuery)
							main=theMainWindowCopyMove.at(i);
					}
				}
				if(main==NULL) //else use new windows
				{
					if(moveQuery)
						main = MoveAction();
					else
						main = CopyAction();
				}
				else
				{
					DEBUGCONSOLE(90,"UIcon::dispatchParam","found compatible copy/move window");
					main->show();
				}

				if(theCurrentArgument=="cp" || theCurrentArgument=="mv")
				{
					DEBUGCONSOLE(30,"UIcon::dispatchParam","Open the copy/move window");
					argumentsUltracopier.removeFirst();
					setArgumentMainWindow(main,argumentsUltracopier,client,copyId,protocolVersionOfThisQuery);
				}
				else if(theCurrentArgument=="Copy" || theCurrentArgument=="Move")
				{
					DEBUGCONSOLE(30,"UIcon::dispatchParam","Open the copy window (list mode)");
					for (int i = 1; i < argumentsUltracopier.size(); ++i) {
						if(argumentsUltracopier.at(i).startsWith("*"))
						{
							//load the file
							QFile theListFile(argumentsUltracopier.at(i).right(argumentsUltracopier.at(i).length()-1));
							DEBUGCONSOLE(50,"UIcon::dispatchParam","List found: "+theListFile.fileName());
							//for after delete the item from the list
							argumentsUltracopier.removeAt(i);
							if(theListFile.open(QIODevice::ReadOnly))
							{
								QString content;
								QTextStream contentStream(&theListFile);
								contentStream.setAutoDetectUnicode(true);
								content=contentStream.readAll();
								QStringList newList=content.split(QRegExp("\\r{0,1}\\n"));
								for (int j = 0; j < newList.size(); ++j) {
									if(newList.at(j)!="")
									{
										DEBUGCONSOLE(90,"UIcon::dispatchParam","insert at "+QString::number(i)+": "+newList.at(j));
										argumentsUltracopier.insert(i++,newList.at(j));
									}
									#if (DEBUG_ULTRACOPIER>0)
									else
									{
										DEBUGCONSOLE(30,"UIcon::dispatchParam","Empty arg for argumentsUltracopier["+QString::number(i)+"]");
									}
									#endif
								}
								theListFile.close();
								#if (DEBUG_ULTRACOPIER>0)
								theListFile.copy(giveWritablePath("CopyList/CopyList-"+QString::number(QCoreApplication::applicationPid())+".dat"));
								if(theListFile.remove())
									DEBUGCONSOLE(90,"UIcon::dispatchParam","File list successfully removed!");
								else
									DEBUGCONSOLE(30,"UIcon::dispatchParam","File list failed to remove!");
								#else
									theListFile.remove();
								#endif
							}
							else
							{
								if(QFile::exists(theListFile.fileName()))
									showDelayedPopup("Copy list file not found",QSystemTrayIcon::Warning);
								else
									showDelayedPopup("Copy list file not open in read mode",QSystemTrayIcon::Warning);
								DEBUGCONSOLE(10,"UIcon::dispatchParam","The List file cannot be open in read mode: "+theListFile.errorString());
								return;
							}
						}
					}
					#if (DEBUG_ULTRACOPIER>0)
						DEBUGCONSOLE(30,"UIcon::dispatchParam","number of argument: "+QString::number(argumentsUltracopier.size()));
						for (int i = 0; i < argumentsUltracopier.size(); ++i) {
							DEBUGCONSOLE(30,"UIcon::dispatchParam","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
						}
					#endif
					if(argumentsUltracopier.size()>=3)
					{
						argumentsUltracopier.removeFirst();
						setArgumentMainWindow(main,argumentsUltracopier,client,copyId,protocolVersionOfThisQuery);
					}
					else
					{
						showDelayedPopup("Number of arguments not greater than 3!",QSystemTrayIcon::Warning);
						DEBUGCONSOLE(10,"UIcon::dispatchParam","number of arguments not greater than 3!");
					}
				}
			}
		}
	}
}

//set arguement for the main window
void UIcon::setArgumentMainWindow(Main_window * window,QStringList list,QLocalSocket * client,quint32 copyId,quint32 protocolVersionOfThisQuery)
{
	if(copyId!=0 && client!=NULL && protocolVersionOfThisQuery>0)
	{
		DEBUGCONSOLE(90,"UIcon::setArgumentMainWindow","copyId!=0 && client!=NULL");
		bool ifFound=false;
		for (int i = 0; i < listCommand.size(); ++i) {
			if(listCommand.at(i).copyId==copyId && listCommand.at(i).client==client)
				ifFound=true;
		}
		if(!ifFound)
		{
			DEBUGCONSOLE(90,"UIcon::setArgumentMainWindow","protocolVersionOfThisQuery: "+QString::number(protocolVersionOfThisQuery));
			DEBUGCONSOLE(90,"UIcon::setArgumentMainWindow","copyId: "+QString::number(copyId));
			composedCommandId temp;
			temp.copyId=copyId;
			temp.window=window;
			temp.client=client;
			temp.protocolVersionOfThisQuery=protocolVersionOfThisQuery;
			listCommand.append(temp);
			DEBUGCONSOLE(90,"UIcon::setArgumentMainWindow","listCommand.size(): "+QString::number(listCommand.size()));
		}
	}
	#if (DEBUG_ULTRACOPIER>0)
	else
	{
		if(copyId==0)
			DEBUGCONSOLE(70,"UIcon::setArgumentMainWindow","copyId=0, then client not support the return");
		if(client==NULL)
			DEBUGCONSOLE(70,"UIcon::setArgumentMainWindow","client socket is null");
	}
	#endif
	window->setArguments(list);
}

//delete old windows
void UIcon::deleteClosedWindows()
{
	DEBUGCONSOLE(70,"UIcon::deleteClosedWindows","start");
	Main_window *oldWindow = qobject_cast<Main_window *>(sender());
	DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","listCommand.size(): "+QString::number(listCommand.size()));
	for (int i = 0; i < listCommand.size(); ++i) {
		#if (DEBUG_ULTRACOPIER>0)
		if(theMainWindowCopyMove.indexOf(listCommand.at(i).window)==-1)
			DEBUGCONSOLE(50,"UIcon::deleteClosedWindows","Unable to found the window of command id: "+QString::number(listCommand.at(i).copyId));
		#endif
		//send the order finish for the right window, with protocol v0001
		if(listCommand.at(i).window==oldWindow)
		{
			//delete listCommand.at(i) in this function
			theOrderIsFinished(i);
			i--;
		}
	}
	DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","loop finish");
	if(oldWindow!=NULL)
	{
		DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","check of can be deleted");
		if(oldWindow->canByDeleted())
		{
			DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","remove the entry in list");
			theMainWindowCopyMove.removeAll(oldWindow);
			disconnect(oldWindow);
			DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","delete the object");
			delete oldWindow;
		}
		DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","finish check");
	}
	DEBUGCONSOLE(90,"UIcon::deleteClosedWindows","stop");
}

/// \brief Show the popup message
void UIcon::ShowPopupMessage()
{
	//If not in listen mode is useless to continu
	if(UIconIsListen)
	{
		#if (DEBUG_ULTRACOPIER>0)
			QString TextOfTheDelayedPopupTemp=TextOfTheDelayedPopup;
			DEBUGCONSOLE(30,"UIcon::ShowPopupMessage","show this text: "+TextOfTheDelayedPopupTemp.replace("\n","\\n"));
		#endif
		
		switch(MessageIconTheDelayedPopup)
		{
			case QSystemTrayIcon::Warning:
				sysTrayIcon->showMessage("Warning",TextOfTheDelayedPopup,MessageIconTheDelayedPopup);
			break;
			case QSystemTrayIcon::Critical:
				sysTrayIcon->showMessage("Critical",TextOfTheDelayedPopup,MessageIconTheDelayedPopup);
			break;
			default:
				sysTrayIcon->showMessage("Information",TextOfTheDelayedPopup,MessageIconTheDelayedPopup);
		}
		TextOfTheDelayedPopup="";
	}
}

///< \brief Show the options windows
void UIcon::OptiAction()
{
	if(TheOptions==NULL)
	{
		//create the options window
		TheOptions = new optionsDialog();
		connect(TheOptions, SIGNAL(OrderUpdateStyle()), this, SLOT(UpdateStyle()));
		connect(this, SIGNAL(OrderUpdateStyle()), TheOptions, SLOT(UpdateStyle()));
		connect(TheOptions, SIGNAL(OptionsUpdated()), this, SLOT(DestroyAndReloadTheInstantce()));
	}
	TheOptions->show();
}

/** \brief Save pointer no QApplication
\param app the pointer on the application
*/
void UIcon::saveApp(QApplication * app)
{
	 ThisApp=app;
}

/// \brief Quit all the current application
void UIcon::QuitAction()
{
	DEBUGCONSOLE(30,"UIcon::QuitAction","quit");
	//before quit send order finish to all client, with protocol v0001
	while(listCommand.size()>0)
		theOrderIsFinished(0);
	ThisApp->quit();
	this->deleteLater();
}

/// \brief return what the order is finished
void UIcon::theOrderIsFinished(int index)
{
	switch(listCommand.at(index).protocolVersionOfThisQuery)
	{
		case 1:
		{
			QByteArray block;
			QDataStream out(&block, QIODevice::WriteOnly);
			out.setVersion(QDataStream::Qt_4_4);
			//reply the copyid
			out << quint32(listCommand.at(index).copyId);
			DEBUGCONSOLE(90,"UIcon::theOrderIsFinished","block: "+QString(block.toHex()));
			listCommand.at(index).client->write(block);
			listCommand.at(index).client->waitForBytesWritten(250);
			listCommand.removeAt(index);
			break;
		}
		default:
			DEBUGCONSOLE(90,"UIcon::theOrderIsFinished","Reply to this protocol not supported");
	}
}

/// \brief Show about box
void UIcon::HelpAction()
{
	if(theHelpDialog==NULL)
		theHelpDialog=new helpDialog();
	HelpText();
	connect(this,SIGNAL(OrderUpdateStyle()),theHelpDialog,SLOT(UpdateStyle()));
	theHelpDialog->show();
	#if (DEBUG_ULTRACOPIER>0)
	theHelpDialog->show_debug_console();
	#endif
}

/// \brief Show about box
void UIcon::HelpText()
{
	if(theHelpDialog!=NULL)
	{
		QString version_type;
		#ifdef ULTRACOPIER_MODE_WINDOWS
			version_type=tr("Windows version");
		#else
			#ifdef ULTRACOPIER_MODE_KDE4
				version_type=tr("KDE4 version");
			#else
				version_type=tr("Unix or generic version");
			#endif
		#endif
		theHelpDialog->SetText("<a href=\""+WEBSITE+"\">"+WEBSITE+"</a>",version_type,VERSION,DEBUG_ULTRACOPIER);
	}
}

/// \brief Preload 1 instance
void UIcon::preloadOneInstance()
{
	//preload 1 windows
	DEBUGCONSOLE(90,"UIcon::preloadOneInstance","start");
	theMainWindowCopyMove.append(new Main_window());
	connect(this,				SIGNAL(OrderUpdateStyle()),	theMainWindowCopyMove.last(),	SLOT(UpdateStyle()));
	connect(theMainWindowCopyMove.last(),	SIGNAL(copyFinish()),		this,				SLOT(orderLinkedWindowsIsFinish()));
	connect(theMainWindowCopyMove.last(),	SIGNAL(canDeleteTheObject()),	this,				SLOT(deleteClosedWindows()));
	windowIsPreloaded=true;
}

/// \brief New copy window
Main_window * UIcon::CopyAction()
{
	DEBUGCONSOLE(90,"UIcon::CopyAction","start");
	if(!windowIsPreloaded)
	{
		DEBUGCONSOLE(30,"UIcon::CopyAction","no time for prealocate the windows");
		preloadOneInstance();
	}
	theMainWindowCopyMove.last()->show();
	windowIsPreloaded=false;
	TimerForDelayedAllocation.start();
	return theMainWindowCopyMove.last();
}

/// \brief New move window
Main_window * UIcon::MoveAction()
{
	DEBUGCONSOLE(90,"UIcon::MoveAction","start");
	if(!windowIsPreloaded)
	{
		DEBUGCONSOLE(30,"UIcon::CopyAction","no time for prealocate the windows");
		preloadOneInstance();
	}
	theMainWindowCopyMove.last()->setMovingMode(true);
	theMainWindowCopyMove.last()->show();
	windowIsPreloaded=false;
	TimerForDelayedAllocation.start();
	return theMainWindowCopyMove.last();
}

/** \brief For catch an action on the systray icon
\param reason Why it activated
*/
void UIcon::CatchAction(QSystemTrayIcon::ActivationReason reason)
{
	DEBUGCONSOLE(90,"UIcon::CatchAction","start");
	if(reason==QSystemTrayIcon::DoubleClick)
	{
		iconActivBool=!iconActivBool;
		QString errorMessage=setSystemCopyCatched(iconActivBool);
		if(errorMessage!="")
		{
			iconActivBool=getSystemCopyCatched();
			showDelayedPopup(errorMessage,QSystemTrayIcon::Warning);
			DEBUGCONSOLE(50,"UIcon::CatchAction","errorMessage: "+errorMessage);
		}
		if(iconActivBool!=getSystemCopyCatched())
		{
			showDelayedPopup(tr("The interception of the copy is not correctly loaded"),QSystemTrayIcon::Warning);
			DEBUGCONSOLE(50,"UIcon::CatchAction","errorMessage: The interception of the copy is not correctly loaded");
			iconActivBool=getSystemCopyCatched();
		}
		UpdateSsystrayIcon();
		DEBUGCONSOLE(30,"UIcon::CatchAction","Double Click detected");
	}
}

/// \brief Update the style
void UIcon::UpdateStyle()
{
	//If not in listen mode is useless to continu
	if(UIconIsListen)
	{
		UpdateSsystrayIcon();
		IconQuit->addFile(loadFilePathIntheStyle("exit.png"));
		IconInfo->addFile(loadFilePathIntheStyle("info.png"));
		IconOptions->addFile(loadFilePathIntheStyle("tools.png"));
		IconAdd->addFile(loadFilePathIntheStyle("add.png"));
		#if (DEBUG_ULTRACOPIER>0)
		if(IconQuit->isNull() || IconInfo->isNull() || IconOptions->isNull() || IconAdd->isNull())
			DEBUGCONSOLE(10,"UIcon::UpdateStyle","error loading the icons");
		#endif
		actionCopy->setIcon(*IconAdd);
		actionMove->setIcon(*IconAdd);
		copyMenu->setIcon(*IconAdd);
		
		actionMenuQuit->setIcon(*IconQuit);
		actionMenuAbout->setIcon(*IconInfo);
		actionOptions->setIcon(*IconOptions);
		
		//query update style to the child
		emit OrderUpdateStyle();

		//update help action
		HelpText();
	}
}

/// \brief Update the systray icon
void UIcon::UpdateSsystrayIcon()
{
	QIcon theNewSystrayIcon;
	if(getSystemCopyCatched())
	{
		#ifdef Q_OS_WIN32
		theNewSystrayIcon.addFile(loadFilePathIntheStyle("systray/systray.png"));
		#else
		theNewSystrayIcon.addFile(loadFilePathIntheStyle("systray/systray_X11.png"));
		#endif
	}
	else
	{
		#ifdef Q_OS_WIN32
		theNewSystrayIcon.addFile(loadFilePathIntheStyle("systray/systray_disabled.png"));
		#else
		theNewSystrayIcon.addFile(loadFilePathIntheStyle("systray/systray_X11_disabled.png"));
		#endif
	}
	#if (DEBUG_ULTRACOPIER>0)
	if(theNewSystrayIcon.isNull())
		DEBUGCONSOLE(10,"UIcon::UpdateSsystrayIcon","Error loading the icons");
	#endif
	sysTrayIcon->setIcon(theNewSystrayIcon);
}

///< \brief after listen
bool UIcon::on_listen()
{
	UIconIsListen = localServer->listen(PATHSOCKET);
	#if (DEBUG_ULTRACOPIER>0)
	if(!UIconIsListen)
                DEBUGCONSOLE(10,"UIcon::on_listen","Cannot create local server: '"+localServer->errorString()+"' for: '"+PATHSOCKET+"'");
	else
		DEBUGCONSOLE(50,"UIcon::on_listen","Local server created");
	#endif
	return UIconIsListen;
}

//return if the socket is listening
bool UIcon::is_listen()
{
        return UIconIsListen;
}

/// \brief Data is incomming
void UIcon::dataincommingUI()
{
	DEBUGCONSOLE(90,"UIcon::dataincomming","start");
	// 1 : we get packets from client
	
	//Which client send the message (Search of the QLocalSocket of client)
	QLocalSocket *socket = qobject_cast<QLocalSocket *>(sender());
	if (socket == 0) // If not found
	{
		DEBUGCONSOLE(10,"UIcon::dataincomming","bad socket");
		return;
	}
	
	QStringList argumentsUltracopier;
	composedData tempComposed;
	tempComposed.idSocket=NULL;
	int index=-1;
	for (int i=0;i<listDataClient.size(); ++i) {
		if(listDataClient.at(i).idSocket==socket)
			index=i;
	}
	DEBUGCONSOLE(90,"UIcon::dataincomming","socket->bytesAvailable() "+QString::number(socket->bytesAvailable()));
	if(index!=-1)
	{
		listDataClient[index].data.append(socket->readAll());
		DEBUGCONSOLE(90,"UIcon::dataincomming","Query recomposed with this size: "+QString::number(listDataClient.at(index).data.size()));
		if(listDataClient.at(index).data.size()==listDataClient.at(index).size)
		{
			DEBUGCONSOLE(50,"UIcon::dataincomming","QByteArray reconstruction finished");
			parseTheCleanedTrame(listDataClient.at(index).data,socket,listDataClient.at(index).copyId);
			listDataClient.removeAt(index);
			if(listDataClient.size()<=0)
				TimeOutQLocalSocket.stop();
		}
		else
		{
			TimeOutQLocalSocket.start();
			DEBUGCONSOLE(90,"UIcon::dataincomming","Need wait to recomposite: "+QString::number(listDataClient.at(index).data.size())+", targeted: "+QString::number(listDataClient.at(index).size));
			return;
		}
	}
	else
	{
		DEBUGCONSOLE(90,"UIcon::dataincomming","tempComposed index not found, create new entry");
		// If all is ok we get the message
		QDataStream in(socket);
		in.setVersion(QDataStream::Qt_4_4);

		quint32 sizeMessage=0;
		if (socket->bytesAvailable() < (int)sizeof(quint32)*3) // We have not receveive all the message
		{
			socket->readAll();
			DEBUGCONSOLE(10,"UIcon::dataincomming","wrong size for set the message size");
			return;
		}
		in >> sizeMessage; // Store the size of the message
		quint32 sizeToDrop=sizeof(quint32)*2;//drop the first sizeof(quint32)*2 from data, for drop size && id
		if(sizeMessage<sizeToDrop)
		{
			socket->readAll();
			DEBUGCONSOLE(90,"UIcon::dataincomming","sizeMessage: "+QString::number(sizeMessage)+", because it's requiered: after the recomposition: (quint32) query id, (quint32) protocole version");
			QMessageBox::warning(NULL,"Warning","The minimal size is not present at the first checking");
			return;
		}

		/// \todo keep copy id for send reply when copy is finished
		/// \todo do multiple client management


		// Check if all the message size is the same as the size given
		if((socket->bytesAvailable()+sizeof(quint32)) < sizeMessage) // If not all get then stop it
		{
			tempComposed.idSocket=socket;
			tempComposed.size=sizeMessage-sizeToDrop;
			in >> tempComposed.copyId;//store the copy id
			tempComposed.data.append(socket->readAll());
			listDataClient.append(tempComposed);
			TimeOutQLocalSocket.start();
			DEBUGCONSOLE(90,"UIcon::dataincomming","Need wait to recomposite: "+QString::number(tempComposed.data.size())+", targeted: "+QString::number(tempComposed.size));
			DEBUGCONSOLE(90,"UIcon::dataincomming","tempComposed.data: "+QString(tempComposed.data.toHex()));
			return;
		}
		DEBUGCONSOLE(90,"UIcon::dataincomming","socket->bytesAvailable(): "+QString::number(socket->bytesAvailable())+", for total of: "+QString::number(socket->bytesAvailable()+sizeof(quint32)));

		// Get the full message
		quint32 copyId=0;
		in >> copyId;//store the copy id
		parseTheCleanedTrame(socket->readAll(),socket,copyId);
	}
}

/// \brief quint32* to quint32 with QDataStream
quint32 UIcon::QByteArrayToquint32(QByteArray temp)
{
	if(temp.size()!=sizeof(quint32))
	{
		DEBUGCONSOLE(70,"UIcon::QByteArrayToquint32","trame: "+QString(temp.toHex()));
		DEBUGCONSOLE(70,"UIcon::QByteArrayToquint32","temp.size()!=sizeof(quint32)");
		return 0;
	}
	DEBUGCONSOLE(70,"UIcon::QByteArrayToquint32","trame: "+QString(temp.toHex()));
	QDataStream in(temp);
	quint32 numberToReturn;
	in >> numberToReturn;
	return numberToReturn;
}

/// \brief parse the cleaned trame
void UIcon::parseTheCleanedTrame(QByteArray trame,QLocalSocket * client,quint32 copyId)
{
	QStringList argumentsUltracopier;
	QDataStream in(trame);
	quint32 protocolVersionOfThisQuery=0;
	in >> protocolVersionOfThisQuery; //store the protocol version
	DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","request id: "+QString::number(copyId)+": protocol "+QString::number(protocolVersionOfThisQuery));
	switch(protocolVersionOfThisQuery)
	{
		case 1:
		{
			uint trameSize=trame.size();
			DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","request id: "+QString::number(copyId)+": trame.size(): "+QString::number(trameSize));
			if(trameSize<=sizeof(quint32)*3) //check the minimal trame size
			{
				QMessageBox::warning(NULL,"Warning",tr("The minimal size is not present"));
				DEBUGCONSOLE(50,"UIcon::parseTheCleanedTrame","The minimal size is not present for the request id: "+QString::number(copyId)+", trame.size()"+QString::number(trame.size()));
				return;
			}

			char * tempCurs=trame.data();
			quint32 formatedSize;
			formatedSize=QByteArrayToquint32(QByteArray(tempCurs+sizeof(quint32),sizeof(quint32)));
			if(formatedSize>(65536*2))
			{
				QMessageBox::warning(NULL,"Warning",tr("For prevent memory overflow the string should have size < 65536 Char"));
				DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","trame: "+QString(trame.toHex()));
				DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","formatedSize: "+QString::number(formatedSize));
				DEBUGCONSOLE(50,"UIcon::parseTheCleanedTrame","For prevent memory overflow the string should have size < 65536 Char, copyId: "+QString::number(copyId)+", trame.size(): "+QString::number(trame.size()));
				return;
			}

			QString theClientName;
			in >> theClientName;
			DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","request id: "+QString::number(copyId)+": theClientName:\""+theClientName+"\"");

			formatedSize=QByteArrayToquint32(QByteArray(tempCurs+sizeof(quint32)*2+sizeof(char)*2*theClientName.size(),sizeof(quint32)));
			int listSize=formatedSize-1;

			if(formatedSize>(1024*16))
			{
				QMessageBox::warning(NULL,"Warning",tr("For prevent memory overflow the list should have size less than 1024 entries"));
				DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","trame: "+QString(trame.toHex()));
				DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","formatedSize: "+QString::number(formatedSize));
				DEBUGCONSOLE(50,"UIcon::parseTheCleanedTrame","For prevent memory overflow the list should have size less than 1024 entries, copyId: "+QString::number(copyId)+", trame.size(): "+QString::number(trame.size()));
				return;
			}

			formatedSize=QByteArrayToquint32(QByteArray(tempCurs+sizeof(quint32)*3+sizeof(char)*2*theClientName.size(),sizeof(quint32)));
			if(formatedSize>(65536*2))
			{
				QMessageBox::warning(NULL,"Warning",tr("For prevent memory overflow the string should have size < 65536 Char"));
				DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","trame: "+QString(trame.toHex()));
				DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","formatedSize: "+QString::number(formatedSize));
				DEBUGCONSOLE(50,"UIcon::parseTheCleanedTrame","For prevent memory overflow the string should have size < 65536 Char, copyId: "+QString::number(copyId)+", trame.size(): "+QString::number(trame.size()));
				return;
			}


			tempCurs=tempCurs+sizeof(quint32)*3+sizeof(char)*2*theClientName.size();
			formatedSize=QByteArrayToquint32(QByteArray(tempCurs,sizeof(quint32)));
			DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","listSize: "+QString::number(listSize));
			while(listSize>0)
			{
				DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","listSize: "+QString::number(listSize));
				listSize--;
				tempCurs+=sizeof(quint32)+sizeof(char)*(formatedSize);
				formatedSize=QByteArrayToquint32(QByteArray(tempCurs,sizeof(quint32)));
				if(formatedSize>(65536*2))
				{
					QMessageBox::warning(NULL,"Warning",tr("For prevent memory overflow the string should have size < 65536 Char"));
					DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","trame: "+QString(trame.toHex()));
					DEBUGCONSOLE(70,"UIcon::parseTheCleanedTrame","formatedSize: "+QString::number(formatedSize));
					DEBUGCONSOLE(50,"UIcon::parseTheCleanedTrame","For prevent memory overflow the string should have size < 65536 Char, copyId: "+QString::number(copyId)+", trame.size(): "+QString::number(trame.size()));
					return;
				}
			}

			in.setVersion(QDataStream::Qt_4_4);
			in >> argumentsUltracopier;
			#if (DEBUG_ULTRACOPIER>0)
				DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","number of argument: "+QString::number(argumentsUltracopier.size()));
				for (int i = 0; i < argumentsUltracopier.size(); ++i) {
					DEBUGCONSOLE(90,"UIcon::parseTheCleanedTrame","argument["+QString::number(i)+"]: "+argumentsUltracopier.at(i));
				}
			#endif
			dispatchParam(argumentsUltracopier,client,copyId,protocolVersionOfThisQuery);
		}
		break;
		default:
			QMessageBox::warning(NULL,"Warning","The protocol version "+QString::number(protocolVersionOfThisQuery)+" is not supported by this version of ultracopier");
			DEBUGCONSOLE(10,"UIcon::dataincomming","The protocol version "+QString::number(protocolVersionOfThisQuery)+" is not supported by this version of ultracopier");
		break;
	}
}

/// \brief Deconnexion client
/// \todo Remove the data in wait linker with this socket
void UIcon::deconnectClientUI()
{
	DEBUGCONSOLE(70,"UIcon::deconnectClient","start");
	
	// Wich client leave
	QLocalSocket *socket = qobject_cast<QLocalSocket *>(sender());
	if (socket == 0) // If not found
		return;

	for (int i = 0; i < listCommand.size(); ++i) {
		if(listCommand.at(i).client==socket)
			listCommand.removeAt(i);
	}
	for (int i = 0; i < listDataClient.size(); ++i) {
		if(listDataClient.at(i).idSocket==socket)
			listDataClient.removeAt(i);
	}
	clients.removeAll(socket);
	
	socket->deleteLater();
}

/// \brief New connexion
void UIcon::newConnexionUI()
{
	DEBUGCONSOLE(70,"UIcon::newConnexion","start");
	QLocalSocket *newClient = localServer->nextPendingConnection();
	#if (DEBUG_ULTRACOPIER>0)
	connect(newClient, SIGNAL(error(QLocalSocket::LocalSocketError)), this, SLOT(errorUI(QLocalSocket::LocalSocketError)));
	#endif
	connect(newClient, SIGNAL(readyRead()), this, SLOT(dataincommingUI()));
	connect(newClient, SIGNAL(disconnected()), this, SLOT(deconnectClientUI()));
	clients << newClient;
}

#if (DEBUG_ULTRACOPIER>0)
/** \brief If error occured at socket
\param theErrorDefine The error define */
void UIcon::errorUI(QLocalSocket::LocalSocketError theErrorDefine)
{
	if(theErrorDefine!=QLocalSocket::PeerClosedError)
	{
		QLocalSocket *client=qobject_cast<QLocalSocket *>(QObject::sender());
		if(client!=NULL)
			DEBUGCONSOLE(70,"UIcon::errorUI","Value:"+QString::number(theErrorDefine)+", Error message: "+client->errorString());
		else
			DEBUGCONSOLE(70,"UIcon::errorUI","Value:"+QString::number(theErrorDefine));
	}
}
#endif

/// \brief Destroy and reload the instance
void UIcon::DestroyAndReloadTheInstantce()
{
	preloadOneInstance();
}

//order Linked Windows Is Finish
void UIcon::orderLinkedWindowsIsFinish()
{
	DEBUGCONSOLE(70,"UIcon::orderLinkedWindowsIsFinish","start");
	Main_window *oldWindow = qobject_cast<Main_window *>(sender());
	DEBUGCONSOLE(90,"UIcon::orderLinkedWindowsIsFinish","listCommand.size(): "+QString::number(listCommand.size()));
	for (int i = 0; i < listCommand.size(); ++i) {
		#if (DEBUG_ULTRACOPIER>0)
		if(theMainWindowCopyMove.indexOf(listCommand.at(i).window)==-1)
			DEBUGCONSOLE(50,"UIcon::orderLinkedWindowsIsFinish","Unable to found the window of command id: "+QString::number(listCommand.at(i).copyId));
		#endif
		//send the order finish for the right window, with protocol v0001
		if(listCommand.at(i).window==oldWindow)
		{
			//delete listCommand.at(i) in this function
			theOrderIsFinished(i);
			i--;
		}
	}
}
