/***************************************************************************
                                   UIcon.h
                              -------------------
 
     Begin        : Sat May 3 2008 12:22 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the UIcon
 
****************************************************************************/

#ifndef INCLUDE_UICON_H
#define INCLUDE_UICON_H

#include <QSystemTrayIcon>
#include <QObject>
#include <QAction>
#include <QMenu>
#include <QTimer>
#include <QDir>
#include <QtNetwork/QLocalServer>
#include <QtNetwork/QLocalSocket>

#include "Mwindow.h"
#include "Options.h"
#include "helpdialog.h"
#include "structDef.h"

/** \brief The systray icon

This class provide a systray icon and it function
*/
class UIcon : public QObject
{
	Q_OBJECT
public:
	UIcon();
	// The destructor
	~UIcon();
	//save pointer to QApplication
	void saveApp(QApplication * app);
	//For for a delayed popup thread safe
	void showDelayedPopupThreadSafe(const QString& text);
	//For give to UIcon the application arguments
	void dispatchParam(QStringList argumentsUltracopier,QLocalSocket * client=NULL,quint32 copyId=0,quint32 protocolVersionOfThisQuery=0);
	//append the log
	#if (DEBUG_ULTRACOPIER>0)
	void appendLog(QString htmlFormat);
	#endif
        //return if the socket is listening
        bool is_listen();
signals:
	void OrderUpdateStyle();
	void RunTheCopy();
	void SignalPopup(QString);
private:
	QSystemTrayIcon* sysTrayIcon;		///< Pointer on the systray icon
	QMenu* systrayMenu;			///< Pointer on the menu
	QMenu* copyMenu;			///< Pointer on the copy menu (move or copy)
	QAction* actionMenuQuit;		///< Pointer on the Quit action
	QAction* actionMenuAbout;		///< Pointer on the About action
	QAction* actionCopy;			///< Pointer on the Copy action
	QAction* actionMove;			///< Pointer on the Move action
	QAction* actionOptions;			///< Pointer on the Options action
	QIcon* IconQuit;			///< Pointer on the icon for quit
	QIcon* IconInfo;			///< Pointer on the icon for info
	QIcon* IconAdd;				///< Pointer on the icon for add
	QIcon* IconOptions;			///< Pointer on the options
	QApplication* ThisApp;			///< Pointer on the application
	optionsDialog* TheOptions;		///< Pointer on the options dialog for keep only one instance opened
	bool iconActivBool;			///< Store the state of the systray icon, activated or not
	QTimer TimerForTheDelayedPopup;		///< Timer for the delayed popup
	QString TextOfTheDelayedPopup;		///< Text for the delayed popup
	QTimer TimerForDelayedAllocation;	///< Timer for delayed allocation
	QTimer TimeOutQLocalSocket;		///< Timer for detect time out on QLocalSocket
	QSystemTrayIcon::MessageIcon MessageIconTheDelayedPopup;///< Type of the popup
	bool UIconIsListen;			///< Store if it listen
	QLocalServer* localServer;		///< For create a local server
	QList<QLocalSocket *> clients;		///< For the local clients
	QList<composedData> listDataClient;	///< For compose data
	QList<Main_window *> theMainWindowCopyMove;///< Pointer on copy or move windows
	QList<composedCommandId> listCommand;	///< List of command linked with window
	helpDialog* theHelpDialog;		///< The help dialog
	bool windowIsPreloaded;			///< True if the last theMainWindowCopyMove it's preload of window
	/// \brief parse the cleaned trame
	void parseTheCleanedTrame(QByteArray trame,QLocalSocket * client,quint32 copyId);
	/// \brief return what the order is finished
	void theOrderIsFinished(int index);
	/// \brief quint32* to quint32 with QDataStream
	quint32 QByteArrayToquint32(QByteArray temp);
private slots:
	//quit all the current application
	void QuitAction();
	//show about box
	void HelpAction();
	/// \brief Show about box
	void HelpText();
	//new copy window
	Main_window * CopyAction();
	//new move window
	Main_window * MoveAction();
	//show the options windows
	void OptiAction();
	//for catch an action on the window
	void CatchAction(QSystemTrayIcon::ActivationReason reason);
	//show the popup message
	void ShowPopupMessage();
	//update the style
	void UpdateStyle();
	//update the systray icon
	void UpdateSsystrayIcon();
	//after listen
	bool on_listen();
	//Data is incomming
	void dataincommingUI();
	//Deconnexion client
	void deconnectClientUI();
	//New connexion
	void newConnexionUI();
	#if (DEBUG_ULTRACOPIER>0)
	//If error occured at socket
	void errorUI(QLocalSocket::LocalSocketError theErrorDefine);
	#endif
	//Preload 1 instance
	void preloadOneInstance();
	//Destroy and reload the instance
	void DestroyAndReloadTheInstantce();
	//For for a delayed popup
	void showDelayedPopup(const QString& text,QSystemTrayIcon::MessageIcon icon=QSystemTrayIcon::Critical);
	//delete old windows
	void deleteClosedWindows();
	//set arguement for the main window
	void setArgumentMainWindow(Main_window *,QStringList,QLocalSocket *,quint32,quint32);
	//the time is done
	void timeoutDectectedQLocalSocket();
	//order Linked Windows Is Finish
	void orderLinkedWindowsIsFinish();
};

#endif

