#include "stdlib.h"
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

Mix_Chunk *sound = NULL;		//Pointer to our sound, in memory

int init_audio()
{
    int audio_rate = 22050;			//Frequency of audio playback
    Uint16 audio_format = AUDIO_S16SYS; 	//Format of the audio we're playing
    int audio_channels = 2;			//2 channels = stereo
    int audio_buffers = 4096;		//Size of the audio buffers in memory
	
    //Initialize SDL audio
    if (SDL_Init(SDL_INIT_AUDIO) != 0) {
	printf("Unable to initialize SDL: %s\n", SDL_GetError());
	return 1;
    }

    //Initialize SDL_mixer with our chosen audio settings
    if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) != 0) {
    	printf("Unable to initialize audio: %s\n", Mix_GetError());
    	return 1;
    } else return 0;
}	

int load_sound (char *wav_file)

{
    //Load our WAV file from disk
    sound = Mix_LoadWAV(wav_file);
    if(sound == NULL) {
    	printf("Unable to load WAV file: %s\n", Mix_GetError());
	return 1;
    } else return 0;
}
	
int play_alarm()
{
    int channel;				//Channel on which our sound is played
    //Play our sound file, and capture the channel on which it is played
    channel = Mix_PlayChannel(-1, sound, -1);
    if(channel == -1) {
    	printf("Unable to play WAV file: %s\n", Mix_GetError());
    }
	
    //Wait until the sound has stopped playing
    //while(Mix_Playing(channel) != 0);
}

void close_audio()
{
    //Release the memory allocated to our sound
    Mix_FreeChunk(sound);
	
    //Need to make sure that SDL_mixer and SDL have a chance to clean up
    Mix_CloseAudio();
    SDL_Quit();	
}
