/* umockdev.c generated by valac 0.38.2, the Vala compiler
 * generated from umockdev.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * SECTION:umockdev
 * @title: umockdev
 * @short_description: Build a test bed for testing software that handles Linux
 * hardware devices.
 *
 * Please see README.rst about an overview of the parts of umockdev, and how
 * they fit together.
 */
/**
 * SECTION:functions
 * @title: global functions
 * @short_description: Global functions
 *
 * These work independently from #Testbed objects.
 */
/**
 * SECTION:umockdeverror
 * @title: umockdev errors
 * @short_description: #GError types for parsing umockdev files
 * hardware devices.
 *
 * See #GError for more information on error domains.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "uevent_sender.h"
#include <unistd.h>
#include <glib/gstdio.h>
#include <errno.h>
#include <gio/gio.h>
#include <stdarg.h>
#include <sys/socket.h>
#include <linux/input.h>
#include <time.h>
#include <pty.h>
#include <termios.h>
#include <stdio.h>
#include <sys/select.h>
#include <sys/time.h>
#include <gio/gunixsocketaddress.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gobject/gvaluecollector.h>


#define UMOCKDEV_TYPE_TESTBED (umockdev_testbed_get_type ())
#define UMOCKDEV_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbed))
#define UMOCKDEV_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))
#define UMOCKDEV_IS_TESTBED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_IS_TESTBED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_TESTBED))
#define UMOCKDEV_TESTBED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedClass))

typedef struct _UMockdevTestbed UMockdevTestbed;
typedef struct _UMockdevTestbedClass UMockdevTestbedClass;
typedef struct _UMockdevTestbedPrivate UMockdevTestbedPrivate;

#define UMOCKDEV_TYPE_SCRIPT_RUNNER (umockdev_script_runner_get_type ())
#define UMOCKDEV_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner))
#define UMOCKDEV_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))
#define UMOCKDEV_IS_SCRIPT_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_IS_SCRIPT_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SCRIPT_RUNNER))
#define UMOCKDEV_SCRIPT_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerClass))

typedef struct _UMockdevScriptRunner UMockdevScriptRunner;
typedef struct _UMockdevScriptRunnerClass UMockdevScriptRunnerClass;

#define UMOCKDEV_TYPE_SOCKET_SERVER (umockdev_socket_server_get_type ())
#define UMOCKDEV_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer))
#define UMOCKDEV_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))
#define UMOCKDEV_IS_SOCKET_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_IS_SOCKET_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UMOCKDEV_TYPE_SOCKET_SERVER))
#define UMOCKDEV_SOCKET_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerClass))

typedef struct _UMockdevSocketServer UMockdevSocketServer;
typedef struct _UMockdevSocketServerClass UMockdevSocketServerClass;
enum  {
	UMOCKDEV_TESTBED_DUMMY_PROPERTY,
	UMOCKDEV_TESTBED_LAST_PROPERTY
};
static GParamSpec* umockdev_testbed_properties[UMOCKDEV_TESTBED_LAST_PROPERTY];
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _umockdev_socket_server_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_socket_server_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _uevent_sender_close0(var) ((var == NULL) ? NULL : (var = (uevent_sender_close (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _umockdev_script_runner_unref0(var) ((var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _UMockdevScriptRunnerPrivate UMockdevScriptRunnerPrivate;
enum  {
	UMOCKDEV_SCRIPT_RUNNER_DUMMY_PROPERTY,
	UMOCKDEV_SCRIPT_RUNNER_LAST_PROPERTY
};
static GParamSpec* umockdev_script_runner_properties[UMOCKDEV_SCRIPT_RUNNER_LAST_PROPERTY];
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _UMockdevParamSpecScriptRunner UMockdevParamSpecScriptRunner;
typedef struct _UMockdevSocketServerPrivate UMockdevSocketServerPrivate;
enum  {
	UMOCKDEV_SOCKET_SERVER_DUMMY_PROPERTY,
	UMOCKDEV_SOCKET_SERVER_LAST_PROPERTY
};
static GParamSpec* umockdev_socket_server_properties[UMOCKDEV_SOCKET_SERVER_LAST_PROPERTY];
typedef struct _UMockdevParamSpecSocketServer UMockdevParamSpecSocketServer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UMockdevTestbed {
	GObject parent_instance;
	UMockdevTestbedPrivate * priv;
};

struct _UMockdevTestbedClass {
	GObjectClass parent_class;
};

struct _UMockdevTestbedPrivate {
	gchar* root_dir;
	gchar* sys_dir;
	GRegex* re_record_val;
	GRegex* re_record_keyval;
	GRegex* re_record_optval;
	uevent_sender* ev_sender;
	GHashTable* dev_fd;
	GHashTable* dev_script_runner;
	UMockdevSocketServer* socket_server;
};

typedef enum  {
	UMOCKDEV_ERROR_PARSE,
	UMOCKDEV_ERROR_VALUE
} UMockdevError;
#define UMOCKDEV_ERROR umockdev_error_quark ()
struct _UMockdevScriptRunner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevScriptRunnerPrivate * priv;
};

struct _UMockdevScriptRunnerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevScriptRunner *self);
};

struct _UMockdevScriptRunnerPrivate {
	gchar* _device;
	gchar* script_file;
	GThread* thread;
	FILE* script;
	gint fd;
	gboolean running;
	guint fuzz;
};

struct _UMockdevParamSpecScriptRunner {
	GParamSpec parent_instance;
};

struct _UMockdevSocketServer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UMockdevSocketServerPrivate * priv;
};

struct _UMockdevSocketServerClass {
	GTypeClass parent_class;
	void (*finalize) (UMockdevSocketServer *self);
};

struct _UMockdevSocketServerPrivate {
	GSocket** listen_sockets;
	gint listen_sockets_length1;
	gint _listen_sockets_size_;
	GHashTable* socket_scriptfile;
	GHashTable* script_runners;
	GThread* thread;
	gboolean running;
	gint ctrl_r;
	gint ctrl_w;
};

struct _UMockdevParamSpecSocketServer {
	GParamSpec parent_instance;
};

/**
 * UMockdevError:
 * @UMOCKDEV_ERROR_PARSE:
 * There is a malformed or missing line in the device description.
 * @UMOCKDEV_ERROR_VALUE:
 * A value in the device description has an invalid value, for example a device
 * path does not start with "/devices/".
 *
 * Error codes for parsing umockdev files.
 */

extern gboolean umockdev___in_mock_env_initialized;
gboolean umockdev___in_mock_env_initialized = FALSE;
extern gboolean umockdev___in_mock_env_result;
gboolean umockdev___in_mock_env_result = FALSE;
static gpointer umockdev_testbed_parent_class = NULL;
static gpointer umockdev_script_runner_parent_class = NULL;
static gpointer umockdev_socket_server_parent_class = NULL;

GType umockdev_testbed_get_type (void) G_GNUC_CONST;
gpointer umockdev_script_runner_ref (gpointer instance);
void umockdev_script_runner_unref (gpointer instance);
GParamSpec* umockdev_param_spec_script_runner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void umockdev_value_set_script_runner (GValue* value, gpointer v_object);
void umockdev_value_take_script_runner (GValue* value, gpointer v_object);
gpointer umockdev_value_get_script_runner (const GValue* value);
GType umockdev_script_runner_get_type (void) G_GNUC_CONST;
gpointer umockdev_socket_server_ref (gpointer instance);
void umockdev_socket_server_unref (gpointer instance);
GParamSpec* umockdev_param_spec_socket_server (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void umockdev_value_set_socket_server (GValue* value, gpointer v_object);
void umockdev_value_take_socket_server (GValue* value, gpointer v_object);
gpointer umockdev_value_get_socket_server (const GValue* value);
GType umockdev_socket_server_get_type (void) G_GNUC_CONST;
#define UMOCKDEV_TESTBED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UMOCKDEV_TYPE_TESTBED, UMockdevTestbedPrivate))
void umockdev_script_runner_stop (UMockdevScriptRunner* self);
void umockdev_socket_server_stop (UMockdevSocketServer* self);
void umockdev_remove_dir (const gchar* path, gboolean remove_toplevel);
UMockdevTestbed* umockdev_testbed_new (void);
UMockdevTestbed* umockdev_testbed_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _umockdev_script_runner_unref0_ (gpointer var);
gchar* umockdev_testbed_get_root_dir (UMockdevTestbed* self);
gchar* umockdev_testbed_get_sys_dir (UMockdevTestbed* self);
void umockdev_testbed_set_attribute (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value);
void umockdev_testbed_set_attribute_binary (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint8* value, int value_length1);
void umockdev_testbed_set_attribute_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value);
void umockdev_testbed_set_attribute_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value);
void umockdev_testbed_set_attribute_link (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value);
gchar* umockdev_testbed_get_property (UMockdevTestbed* self, const gchar* devpath, const gchar* name);
void umockdev_testbed_set_property (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value);
void umockdev_testbed_set_property_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value);
void umockdev_testbed_set_property_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value);
gchar* umockdev_testbed_add_devicev (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, gchar** attributes, gchar** properties);
gchar* umockdev_make_dotdots (const gchar* path);
gboolean umockdev_in_mock_environment (void);
void umockdev_testbed_uevent (UMockdevTestbed* self, const gchar* devpath, const gchar* action);
gchar* umockdev_testbed_add_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, ...);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
void umockdev_testbed_remove_device (UMockdevTestbed* self, const gchar* syspath);
gchar* umockdev_find_devnode (const gchar* devpath);
GQuark umockdev_error_quark (void);
gboolean umockdev_testbed_add_from_string (UMockdevTestbed* self, const gchar* data, GError** error);
static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self, const gchar* data, GError** error);
gboolean umockdev_testbed_add_from_file (UMockdevTestbed* self, const gchar* path, GError** error);
gboolean umockdev_testbed_load_ioctl (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error);
static guint8* _vala_array_dup1 (guint8* self, int length);
gboolean umockdev_testbed_load_script (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error);
gint umockdev_testbed_get_dev_fd (UMockdevTestbed* self, const gchar* devnode);
UMockdevScriptRunner* umockdev_script_runner_new (const gchar* device, const gchar* script_file, gint fd, GError** error);
UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type, const gchar* device, const gchar* script_file, gint fd, GError** error);
gboolean umockdev_testbed_load_socket_script (UMockdevTestbed* self, const gchar* path, gint type, const gchar* recordfile, GError** error);
UMockdevSocketServer* umockdev_socket_server_new (void);
UMockdevSocketServer* umockdev_socket_server_construct (GType object_type);
void umockdev_socket_server_add (UMockdevSocketServer* self, const gchar* sock_path, gint fd, const gchar* record_file);
gboolean umockdev_testbed_load_evemu_events (UMockdevTestbed* self, const gchar* dev, const gchar* eventsfile, GError** error);
gchar* umockdev_script_runner_encode (guint8* data, int data_length1);
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self, const gchar* data, gchar* type, gchar* * key, gchar* * val);
static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar** * array, int* length, int* size, gchar* value);
guint8* umockdev_decode_hex (const gchar* data, int* result_length1, GError** error);
static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* node_path, guint8* node_contents, int node_contents_length1, const gchar* majmin, GError** error);
void umockdev_testbed_disable (UMockdevTestbed* self);
void umockdev_testbed_enable (UMockdevTestbed* self);
void umockdev_testbed_clear (UMockdevTestbed* self);
static void umockdev_testbed_finalize (GObject * obj);
guint8 umockdev_hexdigit (gchar c);
#define UMOCKDEV_SCRIPT_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunnerPrivate))
static void umockdev_script_runner_set_device (UMockdevScriptRunner* self, const gchar* value);
static void* umockdev_script_runner_run (UMockdevScriptRunner* self);
static gpointer _umockdev_script_runner_run_gthread_func (gpointer self);
const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self);
static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self, gchar* op, guint32* delta, int* result_length1);
static void umockdev_script_runner_op_write (UMockdevScriptRunner* self, guint8* data, int data_length1, guint32 delta);
static guint8* umockdev_script_runner_decode (const gchar* quoted, int* result_length1);
static guint umockdev_script_runner_hamming (guint8* d1, int d1_length1, guint8* d2, int d2_length1);
static void _vala_array_add11 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add12 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add13 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add14 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add15 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add16 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add17 (guint8* * array, int* length, int* size, guint8 value);
static void _vala_array_add18 (guint8* * array, int* length, int* size, guint8 value);
static void umockdev_script_runner_finalize (UMockdevScriptRunner * obj);
#define UMOCKDEV_SOCKET_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServerPrivate))
static void* umockdev_socket_server_run (UMockdevSocketServer* self);
static gpointer _umockdev_socket_server_run_gthread_func (gpointer self);
static void _vala_array_add19 (GSocket** * array, int* length, int* size, GSocket* value);
static void umockdev_socket_server_finalize (UMockdevSocketServer * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * umockdev_testbed_new:
     *
     * Create a new #UMockdevTestbed object. This is initially empty, call
     * methods like #umockdev_testbed_add_device or
     * #umockdev_testbed_add_from_string to fill it.
     *
     * Returns: The newly created #UMockdevTestbed object.
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _umockdev_script_runner_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (umockdev_script_runner_unref (var), NULL));
}


UMockdevTestbed* umockdev_testbed_construct (GType object_type) {
	UMockdevTestbed * self = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (UMockdevTestbed*) g_object_new (object_type, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_dir_make_tmp ("umockdev.XXXXXX", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->root_dir);
		self->priv->root_dir = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("umockdev.vala:70: Cannot create temporary directory: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = self->priv->root_dir;
	_tmp5_ = g_build_filename (_tmp4_, "sys", NULL);
	_g_free0 (self->priv->sys_dir);
	self->priv->sys_dir = _tmp5_;
	_tmp6_ = self->priv->sys_dir;
	g_mkdir (_tmp6_, 0755);
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->dev_fd);
	self->priv->dev_fd = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	self->priv->dev_script_runner = _tmp12_;
	_tmp13_ = self->priv->root_dir;
	g_setenv ("UMOCKDEV_DIR", _tmp13_, TRUE);
	_tmp14_ = self->priv->root_dir;
	g_debug ("umockdev.vala:79: Created udev test bed %s", _tmp14_);
	return self;
}


UMockdevTestbed* umockdev_testbed_new (void) {
	return umockdev_testbed_construct (UMOCKDEV_TYPE_TESTBED);
}


/**
     * umockdev_testbed_get_root_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the root directory for the testbed. This is mostly useful for
     * setting up the "dev/" or "proc/" testbed directories in this root
     * directory. For getting the mocked "sys/" dir, use
     * #umockdev_testbed_get_sys_dir.
     *
     * Returns: The testbed's root directory.
     */
gchar* umockdev_testbed_get_root_dir (UMockdevTestbed* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * umockdev_testbed_get_sys_dir:
     * @self: A #UMockdevTestbed.
     *
     * Get the sysfs directory for the testbed.
     *
     * Returns: The testbed's sysfs directory.
     */
gchar* umockdev_testbed_get_sys_dir (UMockdevTestbed* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sys_dir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * umockdev_testbed_set_attribute:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute string value
     *
     * Set a text sysfs attribute for a device.
     */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void umockdev_testbed_set_attribute (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	umockdev_testbed_set_attribute_binary (self, _tmp0_, _tmp1_, _tmp4_, _tmp4__length1);
}


/**
     * umockdev_testbed_set_attribute_binary:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute binary value
     * @value_length1: Length of @value in bytes.
     *
     * Set a binary sysfs attribute for a device.
     */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void umockdev_testbed_set_attribute_binary (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint8* value, int value_length1) {
	gchar* attr_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = devpath;
	_tmp2_ = name;
	_tmp3_ = g_build_filename (_tmp0_, _tmp1_, _tmp2_, NULL);
	attr_path = _tmp3_;
	_tmp4_ = name;
	_tmp5_ = string_contains (_tmp4_, "/");
	if (_tmp5_) {
		gchar* d = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		_tmp6_ = attr_path;
		_tmp7_ = g_path_get_dirname (_tmp6_);
		d = _tmp7_;
		_tmp8_ = d;
		_tmp9_ = g_mkdir_with_parents (_tmp8_, 0755);
		if (_tmp9_ != 0) {
			const gchar* _tmp10_;
			gint _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = d;
			_tmp11_ = errno;
			_tmp12_ = g_strerror (_tmp11_);
			g_error ("umockdev.vala:165: cannot create attribute subdir '%s': %s", _tmp10_, _tmp12_);
		}
		_g_free0 (d);
	}
	{
		const gchar* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = attr_path;
		_tmp14_ = value;
		_tmp14__length1 = value_length1;
		g_file_set_contents (_tmp13_, (const char*) _tmp14_, (size_t) _tmp14__length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (attr_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e->message;
		g_error ("umockdev.vala:171: Cannot write attribute file: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (attr_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (attr_path);
}


/**
     * umockdev_testbed_set_attribute_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name (may contain leading directories like
     *        "queue/rotational")
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device.
     */
void umockdev_testbed_set_attribute_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_attribute (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_set_attribute_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute integer value
     *
     * Set an integer sysfs attribute for a device. Set an integer udev
     * property for a device. @value is interpreted as a hexadecimal number.
     * For example, for value==31 this sets the attribute contents to "1f".
     */
void umockdev_testbed_set_attribute_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%x", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_attribute (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_set_attribute_link:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Attribute name
     * @value: Attribute link target value
     *
     * Set a symlink sysfs attribute for a device; this is primarily important
     * for setting "driver" links.
     */
void umockdev_testbed_set_attribute_link (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value) {
	gchar* path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dir = NULL;
	gchar* _tmp4_;
	gint _tmp5_;
	const gchar* _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = devpath;
	_tmp2_ = name;
	_tmp3_ = g_build_filename (_tmp0_, _tmp1_, _tmp2_, NULL);
	path = _tmp3_;
	_tmp4_ = g_path_get_dirname (path);
	dir = _tmp4_;
	_tmp5_ = g_mkdir_with_parents (dir, 0755);
	if (_tmp5_ != 0) {
		gint _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = errno;
		_tmp7_ = g_strerror (_tmp6_);
		g_error ("umockdev.vala:221: cannot create attribute dir '%s': %s", dir, _tmp7_);
	}
	_tmp8_ = value;
	_tmp9_ = symlink (_tmp8_, path);
	if (_tmp9_ < 0) {
		gint _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = errno;
		_tmp11_ = g_strerror (_tmp10_);
		g_error ("umockdev.vala:223: Cannot create symlink %s: %s", path, _tmp11_);
	}
	_g_free0 (dir);
	_g_free0 (path);
}


/**
     * umockdev_testbed_get_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     *
     * Get a string udev property for a device. Note that this is mostly for
     * testing umockdev itself; for real application testing, use
     * libudev/gudev.
     *
     * Returns: property value, or %NULL if it does not exist
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* umockdev_testbed_get_property (UMockdevTestbed* self, const gchar* devpath, const gchar* name) {
	gchar* result = NULL;
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* ret = NULL;
	GFile* f = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	gchar* prefix = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (devpath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = devpath;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "uevent", NULL);
	uevent_path = _tmp2_;
	ret = NULL;
	_tmp3_ = uevent_path;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	f = _tmp4_;
	_tmp5_ = name;
	_tmp6_ = g_strconcat (_tmp5_, "=", NULL);
	prefix = _tmp6_;
	{
		GFileInputStream* _tmp7_ = NULL;
		GFile* _tmp8_;
		GFileInputStream* _tmp9_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp10_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp25_;
		_tmp8_ = f;
		_tmp9_ = g_file_read (_tmp8_, NULL, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
		inp = _tmp10_;
		while (TRUE) {
			gchar* _tmp11_ = NULL;
			GDataInputStream* _tmp12_;
			gsize _tmp13_ = 0UL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp12_ = inp;
			_tmp14_ = g_data_input_stream_read_line (_tmp12_, &_tmp13_, NULL, &_inner_error_);
			len = _tmp13_;
			_tmp11_ = _tmp14_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp7_);
				goto __catch2_g_error;
			}
			_tmp15_ = _tmp11_;
			_tmp11_ = NULL;
			_g_free0 (line);
			line = _tmp15_;
			_tmp16_ = line;
			if (!(_tmp16_ != NULL)) {
				_g_free0 (_tmp11_);
				break;
			}
			_tmp17_ = line;
			_tmp18_ = prefix;
			_tmp19_ = g_str_has_prefix (_tmp17_, _tmp18_);
			if (_tmp19_) {
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gchar* _tmp24_;
				_tmp20_ = line;
				_tmp21_ = prefix;
				_tmp22_ = strlen (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = string_substring (_tmp20_, (glong) _tmp23_, (glong) -1);
				_g_free0 (ret);
				ret = _tmp24_;
				_g_free0 (_tmp11_);
				break;
			}
			_g_free0 (_tmp11_);
		}
		_tmp25_ = inp;
		g_input_stream_close ((GInputStream*) _tmp25_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp7_);
			goto __catch2_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp7_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e->message;
		g_error ("umockdev.vala:258: Cannot read uevent file: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (ret);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (uevent_path);
	return result;
}


/**
     * umockdev_testbed_set_property:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property string value
     *
     * Set a string udev property for a device.
     */
void umockdev_testbed_set_property (UMockdevTestbed* self, const gchar* devpath, const gchar* name, const gchar* value) {
	gchar* uevent_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* props = NULL;
	gchar* _tmp3_;
	gchar* real_value = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GFile* f = NULL;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean existing = FALSE;
	gchar* prefix = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = devpath;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, "uevent", NULL);
	uevent_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	props = _tmp3_;
	_tmp5_ = name;
	if (g_strcmp0 (_tmp5_, "DEVNAME") == 0) {
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = value;
		_tmp7_ = g_str_has_prefix (_tmp6_, "/dev/");
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = value;
		_tmp9_ = string_substring (_tmp8_, (glong) 5, (glong) -1);
		_g_free0 (real_value);
		real_value = _tmp9_;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = value;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (real_value);
		real_value = _tmp11_;
	}
	_tmp12_ = uevent_path;
	_tmp13_ = g_file_new_for_path (_tmp12_);
	f = _tmp13_;
	existing = FALSE;
	_tmp14_ = name;
	_tmp15_ = g_strconcat (_tmp14_, "=", NULL);
	prefix = _tmp15_;
	{
		GFileInputStream* _tmp16_ = NULL;
		GFile* _tmp17_;
		GFileInputStream* _tmp18_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp19_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp42_;
		gboolean _tmp43_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		guint8* _tmp54_;
		gint _tmp54__length1;
		guint8* _tmp55_;
		gint _tmp55__length1;
		_tmp17_ = f;
		_tmp18_ = g_file_read (_tmp17_, NULL, &_inner_error_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp19_ = g_data_input_stream_new ((GInputStream*) _tmp16_);
		inp = _tmp19_;
		while (TRUE) {
			gchar* _tmp20_ = NULL;
			GDataInputStream* _tmp21_;
			gsize _tmp22_ = 0UL;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gboolean _tmp28_;
			_tmp21_ = inp;
			_tmp23_ = g_data_input_stream_read_line (_tmp21_, &_tmp22_, NULL, &_inner_error_);
			len = _tmp22_;
			_tmp20_ = _tmp23_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp16_);
				goto __catch3_g_error;
			}
			_tmp24_ = _tmp20_;
			_tmp20_ = NULL;
			_g_free0 (line);
			line = _tmp24_;
			_tmp25_ = line;
			if (!(_tmp25_ != NULL)) {
				_g_free0 (_tmp20_);
				break;
			}
			_tmp26_ = line;
			_tmp27_ = prefix;
			_tmp28_ = g_str_has_prefix (_tmp26_, _tmp27_);
			if (_tmp28_) {
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				existing = TRUE;
				_tmp29_ = props;
				_tmp30_ = prefix;
				_tmp31_ = real_value;
				_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat (_tmp33_, "\n", NULL);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strconcat (_tmp29_, _tmp35_, NULL);
				_g_free0 (props);
				props = _tmp36_;
				_g_free0 (_tmp35_);
				_g_free0 (_tmp33_);
			} else {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp37_ = props;
				_tmp38_ = line;
				_tmp39_ = g_strconcat (_tmp38_, "\n", NULL);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strconcat (_tmp37_, _tmp40_, NULL);
				_g_free0 (props);
				props = _tmp41_;
				_g_free0 (_tmp40_);
			}
			_g_free0 (_tmp20_);
		}
		_tmp42_ = inp;
		g_input_stream_close ((GInputStream*) _tmp42_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp16_);
			goto __catch3_g_error;
		}
		_tmp43_ = existing;
		if (!_tmp43_) {
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp44_ = props;
			_tmp45_ = prefix;
			_tmp46_ = real_value;
			_tmp47_ = g_strconcat (_tmp45_, _tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat (_tmp48_, "\n", NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp44_, _tmp50_, NULL);
			_g_free0 (props);
			props = _tmp51_;
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
		}
		_tmp52_ = uevent_path;
		_tmp53_ = props;
		_tmp54_ = string_get_data (_tmp53_, &_tmp54__length1);
		_tmp55_ = _tmp54_;
		_tmp55__length1 = _tmp54__length1;
		g_file_set_contents (_tmp52_, (const char*) _tmp55_, (size_t) _tmp55__length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp16_);
			goto __catch3_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp16_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp56_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp56_ = e->message;
		g_error ("umockdev.vala:311: Cannot update uevent file: %s", _tmp56_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (prefix);
		_g_object_unref0 (f);
		_g_free0 (real_value);
		_g_free0 (props);
		_g_free0 (uevent_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (prefix);
	_g_object_unref0 (f);
	_g_free0 (real_value);
	_g_free0 (props);
	_g_free0 (uevent_path);
}


/**
     * umockdev_testbed_set_property_int:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device.
     */
void umockdev_testbed_set_property_int (UMockdevTestbed* self, const gchar* devpath, const gchar* name, gint value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_property (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_set_property_hex:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @name: Property name
     * @value: Property integer value
     *
     * Set an integer udev property for a device. @value is interpreted as a
     * hexadecimal number. For example, for value==31 this sets the property's
     * value to "1f".
     */
void umockdev_testbed_set_property_hex (UMockdevTestbed* self, const gchar* devpath, const gchar* name, guint value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = devpath;
	_tmp1_ = name;
	_tmp2_ = value;
	_tmp3_ = g_strdup_printf ("%x", _tmp2_);
	_tmp4_ = _tmp3_;
	umockdev_testbed_set_property (self, _tmp0_, _tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
}


/**
     * umockdev_testbed_add_devicev:
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @attributes: (array zero-terminated=1):
     *              A list of device sysfs attributes, alternating names and
     *              values, terminated with %NULL:
     *              { "key1", "value1", "key2", "value2", ..., NULL }
     * @properties: (array zero-terminated=1):
     *              A list of device udev properties; same format as @attributes
     *
     * This method is mostly meant for language bindings (where it is named
     * umockdev_testbed_add_device()). For C programs it is usually more convenient to
     * use umockdev_testbed_add_device().
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     *
     * Rename to: umockdev_testbed_add_device
     */
static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* umockdev_testbed_add_devicev (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, gchar** attributes, gchar** properties) {
	gchar* result = NULL;
	gchar* dev_path = NULL;
	gchar* dev_node = NULL;
	const gchar* _tmp0_;
	gchar* dev_dir = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	gchar* dev_path_no_sys = NULL;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	const gchar* _tmp88_;
	gchar* props = NULL;
	gchar* _tmp106_;
	gchar** _tmp144_;
	gint _tmp144__length1;
	const gchar* _tmp148_;
	const gchar* _tmp149_;
	gchar** _tmp211_;
	gint _tmp211__length1;
	gboolean _tmp215_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	dev_node = NULL;
	_tmp0_ = parent;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gboolean _tmp2_;
		const gchar* _tmp4_;
		gboolean _tmp5_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = parent;
		_tmp2_ = g_str_has_prefix (_tmp1_, "/sys/");
		if (!_tmp2_) {
			const gchar* _tmp3_;
			_tmp3_ = parent;
			g_critical ("umockdev.vala:386: add_devicev(): parent device %s does not start with" \
" /sys/", _tmp3_);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp4_ = parent;
		_tmp5_ = g_file_test (_tmp4_, G_FILE_TEST_IS_DIR);
		if (!_tmp5_) {
			const gchar* _tmp6_;
			_tmp6_ = parent;
			g_critical ("umockdev.vala:390: add_devicev(): parent device %s does not exist", _tmp6_);
			result = NULL;
			_g_free0 (dev_node);
			_g_free0 (dev_path);
			return result;
		}
		_tmp7_ = parent;
		_tmp8_ = name;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp9_;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = name;
		_tmp11_ = g_build_filename ("/sys/devices", _tmp10_, NULL);
		_g_free0 (dev_path);
		dev_path = _tmp11_;
	}
	_tmp12_ = self->priv->root_dir;
	_tmp13_ = dev_path;
	_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
	dev_dir = _tmp14_;
	_tmp16_ = dev_dir;
	_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_EXISTS);
	if (_tmp17_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp18_ = dev_dir;
		_tmp19_ = g_build_filename (_tmp18_, "uevent", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_file_test (_tmp20_, G_FILE_TEST_EXISTS);
		_tmp15_ = _tmp21_;
		_g_free0 (_tmp20_);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp22_;
		_tmp22_ = dev_dir;
		g_error ("umockdev.vala:401: device %s already exists", _tmp22_);
	}
	_tmp23_ = dev_path;
	_tmp24_ = dev_path;
	_tmp25_ = string_index_of (_tmp24_, "/devices/", 0);
	_tmp26_ = string_substring (_tmp23_, (glong) _tmp25_, (glong) -1);
	dev_path_no_sys = _tmp26_;
	_tmp27_ = dev_dir;
	_tmp28_ = g_mkdir_with_parents (_tmp27_, 0755);
	if (_tmp28_ != 0) {
		const gchar* _tmp29_;
		gint _tmp30_;
		const gchar* _tmp31_;
		_tmp29_ = dev_dir;
		_tmp30_ = errno;
		_tmp31_ = g_strerror (_tmp30_);
		g_error ("umockdev.vala:407: cannot create dev dir '%s': %s", _tmp29_, _tmp31_);
	}
	_tmp33_ = subsystem;
	if (g_strcmp0 (_tmp33_, "usb") != 0) {
		const gchar* _tmp34_;
		_tmp34_ = subsystem;
		_tmp32_ = g_strcmp0 (_tmp34_, "pci") != 0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		gchar* class_dir = NULL;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		gint _tmp39_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gint _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gint _tmp62_;
		_tmp35_ = self->priv->sys_dir;
		_tmp36_ = subsystem;
		_tmp37_ = g_build_filename (_tmp35_, "class", _tmp36_, NULL);
		class_dir = _tmp37_;
		_tmp38_ = class_dir;
		_tmp39_ = g_mkdir_with_parents (_tmp38_, 0755);
		if (_tmp39_ != 0) {
			const gchar* _tmp40_;
			gint _tmp41_;
			const gchar* _tmp42_;
			_tmp40_ = class_dir;
			_tmp41_ = errno;
			_tmp42_ = g_strerror (_tmp41_);
			g_error ("umockdev.vala:412: cannot create class dir '%s': %s", _tmp40_, _tmp42_);
		}
		_tmp43_ = dev_path;
		_tmp44_ = umockdev_make_dotdots (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = subsystem;
		_tmp47_ = g_build_filename (_tmp45_, "class", _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = dev_dir;
		_tmp50_ = g_build_filename (_tmp49_, "subsystem", NULL);
		_tmp51_ = _tmp50_;
		_tmp52_ = symlink (_tmp48_, _tmp51_);
		_vala_assert (_tmp52_ == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"class\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp51_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp45_);
		_tmp53_ = dev_path_no_sys;
		_tmp54_ = g_build_filename ("..", "..", _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = class_dir;
		_tmp57_ = name;
		_tmp58_ = g_path_get_basename (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_build_filename (_tmp56_, _tmp59_, NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = symlink (_tmp55_, _tmp61_);
		_vala_assert (_tmp62_ == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(class_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp61_);
		_g_free0 (_tmp59_);
		_g_free0 (_tmp55_);
		_g_free0 (class_dir);
	} else {
		gchar* bus_dir = NULL;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		const gchar* _tmp66_;
		gint _tmp67_;
		const gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		const gchar* _tmp71_;
		const gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gint _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		const gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gint _tmp87_;
		_tmp63_ = self->priv->sys_dir;
		_tmp64_ = subsystem;
		_tmp65_ = g_build_filename (_tmp63_, "bus", _tmp64_, "devices", NULL);
		bus_dir = _tmp65_;
		_tmp66_ = bus_dir;
		_tmp67_ = g_mkdir_with_parents (_tmp66_, 0755);
		_vala_assert (_tmp67_ == 0, "DirUtils.create_with_parents(bus_dir, 0755) == 0");
		_tmp68_ = dev_path_no_sys;
		_tmp69_ = g_build_filename ("..", "..", "..", _tmp68_, NULL);
		_tmp70_ = _tmp69_;
		_tmp71_ = bus_dir;
		_tmp72_ = name;
		_tmp73_ = g_path_get_basename (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_build_filename (_tmp71_, _tmp74_, NULL);
		_tmp76_ = _tmp75_;
		_tmp77_ = symlink (_tmp70_, _tmp76_);
		_vala_assert (_tmp77_ == 0, "FileUtils.symlink(Path.build_filename(\"..\", \"..\", \"..\", dev_path_no_sys),                                      Path.build_filename(bus_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp76_);
		_g_free0 (_tmp74_);
		_g_free0 (_tmp70_);
		_tmp78_ = dev_path;
		_tmp79_ = umockdev_make_dotdots (_tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = subsystem;
		_tmp82_ = g_build_filename (_tmp80_, "bus", _tmp81_, NULL);
		_tmp83_ = _tmp82_;
		_tmp84_ = dev_dir;
		_tmp85_ = g_build_filename (_tmp84_, "subsystem", NULL);
		_tmp86_ = _tmp85_;
		_tmp87_ = symlink (_tmp83_, _tmp86_);
		_vala_assert (_tmp87_ == 0, "FileUtils.symlink(Path.build_filename(make_dotdots(dev_path), \"bus\", subsystem),                                      Path.build_filename(dev_dir, \"subsystem\")) == 0");
		_g_free0 (_tmp86_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp80_);
		_g_free0 (bus_dir);
	}
	_tmp88_ = subsystem;
	if (g_strcmp0 (_tmp88_, "block") == 0) {
		gchar* block_dir = NULL;
		const gchar* _tmp89_;
		gchar* _tmp90_;
		const gchar* _tmp91_;
		gint _tmp92_;
		const gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		const gchar* _tmp99_;
		const gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gint _tmp105_;
		_tmp89_ = self->priv->sys_dir;
		_tmp90_ = g_build_filename (_tmp89_, "block", NULL);
		block_dir = _tmp90_;
		_tmp91_ = block_dir;
		_tmp92_ = g_mkdir_with_parents (_tmp91_, 0755);
		if (_tmp92_ != 0) {
			const gchar* _tmp93_;
			gint _tmp94_;
			const gchar* _tmp95_;
			_tmp93_ = block_dir;
			_tmp94_ = errno;
			_tmp95_ = g_strerror (_tmp94_);
			g_error ("umockdev.vala:439: cannot create block dir '%s': %s", _tmp93_, _tmp95_);
		}
		_tmp96_ = dev_path_no_sys;
		_tmp97_ = g_build_filename ("..", _tmp96_, NULL);
		_tmp98_ = _tmp97_;
		_tmp99_ = block_dir;
		_tmp100_ = name;
		_tmp101_ = g_path_get_basename (_tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = g_build_filename (_tmp99_, _tmp102_, NULL);
		_tmp104_ = _tmp103_;
		_tmp105_ = symlink (_tmp98_, _tmp104_);
		_vala_assert (_tmp105_ == 0, "FileUtils.symlink(Path.build_filename(\"..\", dev_path_no_sys),                                      Path.build_filename(block_dir, Path.get_basename(name))) == 0");
		_g_free0 (_tmp104_);
		_g_free0 (_tmp102_);
		_g_free0 (_tmp98_);
		_g_free0 (block_dir);
	}
	_tmp106_ = g_strdup ("");
	props = _tmp106_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp107_ = FALSE;
			_tmp107_ = TRUE;
			while (TRUE) {
				gint _tmp109_;
				gchar** _tmp110_;
				gint _tmp110__length1;
				gboolean _tmp111_ = FALSE;
				gchar** _tmp112_;
				gint _tmp112__length1;
				gint _tmp113_;
				const gchar* _tmp114_;
				if (!_tmp107_) {
					gint _tmp108_;
					_tmp108_ = i;
					i = _tmp108_ + 2;
				}
				_tmp107_ = FALSE;
				_tmp109_ = i;
				_tmp110_ = properties;
				_tmp110__length1 = _vala_array_length (properties);
				if (!(_tmp109_ < (_tmp110__length1 - 1))) {
					break;
				}
				_tmp112_ = properties;
				_tmp112__length1 = _vala_array_length (properties);
				_tmp113_ = i;
				_tmp114_ = _tmp112_[_tmp113_];
				if (g_strcmp0 (_tmp114_, "DEVNAME") == 0) {
					gchar** _tmp115_;
					gint _tmp115__length1;
					gint _tmp116_;
					const gchar* _tmp117_;
					gboolean _tmp118_;
					_tmp115_ = properties;
					_tmp115__length1 = _vala_array_length (properties);
					_tmp116_ = i;
					_tmp117_ = _tmp115_[_tmp116_ + 1];
					_tmp118_ = g_str_has_prefix (_tmp117_, "/dev/");
					_tmp111_ = _tmp118_;
				} else {
					_tmp111_ = FALSE;
				}
				if (_tmp111_) {
					gchar** _tmp119_;
					gint _tmp119__length1;
					gint _tmp120_;
					const gchar* _tmp121_;
					gchar* _tmp122_;
					const gchar* _tmp123_;
					const gchar* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					gchar* _tmp127_;
					gchar* _tmp128_;
					gchar* _tmp129_;
					_tmp119_ = properties;
					_tmp119__length1 = _vala_array_length (properties);
					_tmp120_ = i;
					_tmp121_ = _tmp119_[_tmp120_ + 1];
					_tmp122_ = string_substring (_tmp121_, (glong) 5, (glong) -1);
					_g_free0 (dev_node);
					dev_node = _tmp122_;
					_tmp123_ = props;
					_tmp124_ = dev_node;
					_tmp125_ = g_strconcat ("DEVNAME=", _tmp124_, NULL);
					_tmp126_ = _tmp125_;
					_tmp127_ = g_strconcat (_tmp126_, "\n", NULL);
					_tmp128_ = _tmp127_;
					_tmp129_ = g_strconcat (_tmp123_, _tmp128_, NULL);
					_g_free0 (props);
					props = _tmp129_;
					_g_free0 (_tmp128_);
					_g_free0 (_tmp126_);
				} else {
					const gchar* _tmp130_;
					gchar** _tmp131_;
					gint _tmp131__length1;
					gint _tmp132_;
					const gchar* _tmp133_;
					gchar* _tmp134_;
					gchar* _tmp135_;
					gchar** _tmp136_;
					gint _tmp136__length1;
					gint _tmp137_;
					const gchar* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					gchar* _tmp142_;
					gchar* _tmp143_;
					_tmp130_ = props;
					_tmp131_ = properties;
					_tmp131__length1 = _vala_array_length (properties);
					_tmp132_ = i;
					_tmp133_ = _tmp131_[_tmp132_];
					_tmp134_ = g_strconcat (_tmp133_, "=", NULL);
					_tmp135_ = _tmp134_;
					_tmp136_ = properties;
					_tmp136__length1 = _vala_array_length (properties);
					_tmp137_ = i;
					_tmp138_ = _tmp136_[_tmp137_ + 1];
					_tmp139_ = g_strconcat (_tmp135_, _tmp138_, NULL);
					_tmp140_ = _tmp139_;
					_tmp141_ = g_strconcat (_tmp140_, "\n", NULL);
					_tmp142_ = _tmp141_;
					_tmp143_ = g_strconcat (_tmp130_, _tmp142_, NULL);
					_g_free0 (props);
					props = _tmp143_;
					_g_free0 (_tmp142_);
					_g_free0 (_tmp140_);
					_g_free0 (_tmp135_);
				}
			}
		}
	}
	_tmp144_ = properties;
	_tmp144__length1 = _vala_array_length (properties);
	if ((_tmp144__length1 % 2) != 0) {
		gchar** _tmp145_;
		gint _tmp145__length1;
		gchar** _tmp146_;
		gint _tmp146__length1;
		const gchar* _tmp147_;
		_tmp145_ = properties;
		_tmp145__length1 = _vala_array_length (properties);
		_tmp146_ = properties;
		_tmp146__length1 = _vala_array_length (properties);
		_tmp147_ = _tmp145_[_tmp146__length1 - 1];
		g_warning ("umockdev.vala:455: add_devicev: Ignoring property key '%s' without val" \
"ue", _tmp147_);
	}
	_tmp148_ = dev_path;
	_tmp149_ = props;
	umockdev_testbed_set_attribute (self, _tmp148_, "uevent", _tmp149_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp150_ = FALSE;
			_tmp150_ = TRUE;
			while (TRUE) {
				gint _tmp152_;
				gchar** _tmp153_;
				gint _tmp153__length1;
				const gchar* _tmp154_;
				gchar** _tmp155_;
				gint _tmp155__length1;
				gint _tmp156_;
				const gchar* _tmp157_;
				gchar** _tmp158_;
				gint _tmp158__length1;
				gint _tmp159_;
				const gchar* _tmp160_;
				gboolean _tmp161_ = FALSE;
				gchar** _tmp162_;
				gint _tmp162__length1;
				gint _tmp163_;
				const gchar* _tmp164_;
				if (!_tmp150_) {
					gint _tmp151_;
					_tmp151_ = i;
					i = _tmp151_ + 2;
				}
				_tmp150_ = FALSE;
				_tmp152_ = i;
				_tmp153_ = attributes;
				_tmp153__length1 = _vala_array_length (attributes);
				if (!(_tmp152_ < (_tmp153__length1 - 1))) {
					break;
				}
				_tmp154_ = dev_path;
				_tmp155_ = attributes;
				_tmp155__length1 = _vala_array_length (attributes);
				_tmp156_ = i;
				_tmp157_ = _tmp155_[_tmp156_];
				_tmp158_ = attributes;
				_tmp158__length1 = _vala_array_length (attributes);
				_tmp159_ = i;
				_tmp160_ = _tmp158_[_tmp159_ + 1];
				umockdev_testbed_set_attribute (self, _tmp154_, _tmp157_, _tmp160_);
				_tmp162_ = attributes;
				_tmp162__length1 = _vala_array_length (attributes);
				_tmp163_ = i;
				_tmp164_ = _tmp162_[_tmp163_];
				if (g_strcmp0 (_tmp164_, "dev") == 0) {
					const gchar* _tmp165_;
					_tmp165_ = dev_node;
					_tmp161_ = _tmp165_ != NULL;
				} else {
					_tmp161_ = FALSE;
				}
				if (_tmp161_) {
					gchar* infodir = NULL;
					const gchar* _tmp166_;
					gchar* _tmp167_;
					const gchar* _tmp168_;
					gchar** _tmp169_;
					gint _tmp169__length1;
					gint _tmp170_;
					const gchar* _tmp171_;
					const gchar* _tmp172_;
					const gchar* _tmp173_;
					gchar* _tmp174_;
					gchar* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					gint _tmp178_;
					const gchar* _tmp179_ = NULL;
					const gchar* _tmp180_;
					gboolean _tmp181_;
					gchar* sysdev_dir = NULL;
					const gchar* _tmp182_;
					gchar* _tmp183_;
					const gchar* _tmp184_;
					gint _tmp185_;
					gchar* dest = NULL;
					const gchar* _tmp189_;
					gchar** _tmp190_;
					gint _tmp190__length1;
					gint _tmp191_;
					const gchar* _tmp192_;
					gchar* _tmp193_;
					const gchar* _tmp194_;
					gboolean _tmp195_;
					_tmp166_ = self->priv->root_dir;
					_tmp167_ = g_build_filename (_tmp166_, "dev", ".node", NULL);
					infodir = _tmp167_;
					_tmp168_ = infodir;
					g_mkdir_with_parents (_tmp168_, 0755);
					_tmp169_ = attributes;
					_tmp169__length1 = _vala_array_length (attributes);
					_tmp170_ = i;
					_tmp171_ = _tmp169_[_tmp170_ + 1];
					_tmp172_ = infodir;
					_tmp173_ = dev_node;
					_tmp174_ = string_replace (_tmp173_, "/", "_");
					_tmp175_ = _tmp174_;
					_tmp176_ = g_build_filename (_tmp172_, _tmp175_, NULL);
					_tmp177_ = _tmp176_;
					_tmp178_ = symlink (_tmp171_, _tmp177_);
					_vala_assert (_tmp178_ == 0, "FileUtils.symlink(attributes[i+1],                                          Path.build_filename(infodir, dev_node.replace(\"/\", \"_\"))) == 0");
					_g_free0 (_tmp177_);
					_g_free0 (_tmp175_);
					_tmp180_ = dev_path;
					_tmp181_ = string_contains (_tmp180_, "/block/");
					if (_tmp181_) {
						_tmp179_ = "block";
					} else {
						_tmp179_ = "char";
					}
					_tmp182_ = self->priv->sys_dir;
					_tmp183_ = g_build_filename (_tmp182_, "dev", _tmp179_, NULL);
					sysdev_dir = _tmp183_;
					_tmp184_ = sysdev_dir;
					_tmp185_ = g_mkdir_with_parents (_tmp184_, 0755);
					if (_tmp185_ != 0) {
						const gchar* _tmp186_;
						gint _tmp187_;
						const gchar* _tmp188_;
						_tmp186_ = sysdev_dir;
						_tmp187_ = errno;
						_tmp188_ = g_strerror (_tmp187_);
						g_error ("umockdev.vala:472: cannot create dir '%s': %s", _tmp186_, _tmp188_);
					}
					_tmp189_ = sysdev_dir;
					_tmp190_ = attributes;
					_tmp190__length1 = _vala_array_length (attributes);
					_tmp191_ = i;
					_tmp192_ = _tmp190_[_tmp191_ + 1];
					_tmp193_ = g_build_filename (_tmp189_, _tmp192_, NULL);
					dest = _tmp193_;
					_tmp194_ = dest;
					_tmp195_ = g_file_test (_tmp194_, G_FILE_TEST_EXISTS);
					if (!_tmp195_) {
						const gchar* _tmp196_;
						gchar* _tmp197_;
						gchar* _tmp198_;
						gchar* _tmp199_;
						gchar* _tmp200_;
						const gchar* _tmp201_;
						gint _tmp202_;
						gboolean _tmp203_;
						_tmp196_ = dev_path;
						_tmp197_ = string_substring (_tmp196_, (glong) 5, (glong) -1);
						_tmp198_ = _tmp197_;
						_tmp199_ = g_strconcat ("../../", _tmp198_, NULL);
						_tmp200_ = _tmp199_;
						_tmp201_ = dest;
						_tmp202_ = symlink (_tmp200_, _tmp201_);
						_tmp203_ = _tmp202_ < 0;
						_g_free0 (_tmp200_);
						_g_free0 (_tmp198_);
						if (_tmp203_) {
							const gchar* _tmp204_;
							const gchar* _tmp205_;
							const gchar* _tmp206_;
							gchar* _tmp207_;
							gchar* _tmp208_;
							gint _tmp209_;
							const gchar* _tmp210_;
							_tmp204_ = name;
							_tmp205_ = dest;
							_tmp206_ = dev_path;
							_tmp207_ = string_substring (_tmp206_, (glong) 5, (glong) -1);
							_tmp208_ = _tmp207_;
							_tmp209_ = errno;
							_tmp210_ = g_strerror (_tmp209_);
							g_error ("umockdev.vala:476: add_device %s: failed to symlink %s to %s: %s\n", _tmp204_, _tmp205_, _tmp208_, _tmp210_);
							_g_free0 (_tmp208_);
						}
					}
					_g_free0 (dest);
					_g_free0 (sysdev_dir);
					_g_free0 (infodir);
				}
			}
		}
	}
	_tmp211_ = attributes;
	_tmp211__length1 = _vala_array_length (attributes);
	if ((_tmp211__length1 % 2) != 0) {
		gchar** _tmp212_;
		gint _tmp212__length1;
		gchar** _tmp213_;
		gint _tmp213__length1;
		const gchar* _tmp214_;
		_tmp212_ = attributes;
		_tmp212__length1 = _vala_array_length (attributes);
		_tmp213_ = attributes;
		_tmp213__length1 = _vala_array_length (attributes);
		_tmp214_ = _tmp212_[_tmp213__length1 - 1];
		g_warning ("umockdev.vala:482: add_devicev: Ignoring attribute key '%s' without va" \
"lue", _tmp214_);
	}
	_tmp215_ = umockdev_in_mock_environment ();
	if (_tmp215_) {
		const gchar* _tmp216_;
		_tmp216_ = dev_path;
		umockdev_testbed_uevent (self, _tmp216_, "add");
	}
	result = dev_path;
	_g_free0 (props);
	_g_free0 (dev_path_no_sys);
	_g_free0 (dev_dir);
	_g_free0 (dev_node);
	return result;
}


/**
     * umockdev_testbed_add_device: (skip)
     * @self: A #UMockdevTestbed.
     * @subsystem: The subsystem name, e. g. "usb"
     * @name: The device name; arbitrary, but needs to be unique within the testbed
     * @parent: (allow-none): device path of the parent device. Use %NULL for a
     *          top-level device.
     * @...: Arbitrarily many pairs of sysfs attributes (alternating names and
     *       values), terminated by %NULL, followed by arbitrarily many pairs of udev
     *       properties, terminated by another %NULL.
     *
     * Add a new device to the testbed. A Linux kernel device always has a
     * subsystem (such as "usb" or "pci"), and a device name. The test bed only
     * builds a very simple sysfs structure without nested namespaces, so it
     * requires device names to be unique. Some gudev client programs might make
     * assumptions about the name (e. g. a SCSI disk block device should be called
     * sdaN). A device also has an arbitrary number of sysfs attributes and udev
     * properties; usually you should specify them upon creation, but it is also
     * possible to change them later on with umockdev_testbed_set_attribute() and
     * umockdev_testbed_set_property().
     *
     * Example:
     *   |[
     *   umockdev_testbed_add_device (testbed, "usb", "dev1", NULL,
     *                              "idVendor", "0815", "idProduct", "AFFE", NULL,
     *                              "ID_MODEL", "KoolGadget", NULL);
     *   ]|
     *
     * Returns: The sysfs path for the newly created device. Free with g_free().
     */
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* umockdev_testbed_add_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* name, const gchar* parent, ...) {
	gchar* result = NULL;
	gchar** attributes = NULL;
	gchar** _tmp0_;
	gint attributes_length1;
	gint _attributes_size_;
	gchar** properties = NULL;
	gchar** _tmp1_;
	gint properties_length1;
	gint _properties_size_;
	gint arg_set = 0;
	va_list l = {0};
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	attributes = _tmp0_;
	attributes_length1 = 0;
	_attributes_size_ = attributes_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	properties = _tmp1_;
	properties_length1 = 0;
	_properties_size_ = properties_length1;
	arg_set = 0;
	va_start (l, parent);
	while (TRUE) {
		gchar* arg = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp7_;
		_tmp2_ = va_arg (l, gchar*);
		_tmp3_ = g_strdup (_tmp2_);
		arg = _tmp3_;
		_tmp4_ = arg;
		if (_tmp4_ == NULL) {
			gint _tmp5_;
			gint _tmp6_;
			_tmp5_ = arg_set;
			arg_set = _tmp5_ + 1;
			_tmp6_ = arg_set;
			if (_tmp6_ > 1) {
				_g_free0 (arg);
				break;
			} else {
				_g_free0 (arg);
				continue;
			}
		}
		_tmp7_ = arg_set;
		if (_tmp7_ == 0) {
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = attributes;
			_tmp8__length1 = attributes_length1;
			_tmp9_ = arg;
			_tmp10_ = g_strdup (_tmp9_);
			_vala_array_add1 (&attributes, &attributes_length1, &_attributes_size_, _tmp10_);
		} else {
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp11_ = properties;
			_tmp11__length1 = properties_length1;
			_tmp12_ = arg;
			_tmp13_ = g_strdup (_tmp12_);
			_vala_array_add2 (&properties, &properties_length1, &_properties_size_, _tmp13_);
		}
		_g_free0 (arg);
	}
	_tmp14_ = subsystem;
	_tmp15_ = name;
	_tmp16_ = parent;
	_tmp17_ = attributes;
	_tmp17__length1 = attributes_length1;
	_tmp18_ = properties;
	_tmp18__length1 = properties_length1;
	_tmp19_ = umockdev_testbed_add_devicev (self, _tmp14_, _tmp15_, _tmp16_, _tmp17_, _tmp18_);
	result = _tmp19_;
	va_end (l);
	properties = (_vala_array_free (properties, properties_length1, (GDestroyNotify) g_free), NULL);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
     * umockdev_testbed_remove_device:
     * @self: A #UMockdevTestbed.
     * @syspath: Sysfs path of device
     *
     * Remove a device from the testbed. This removes the sysfs directory, the
     * /sys/class/ link, the device node, and all other information related to
     * it. Note that this will also remove all child devices (i. e.
     * subdirectories of @syspath).
     */
void umockdev_testbed_remove_device (UMockdevTestbed* self, const gchar* syspath) {
	gchar* real_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* devname = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* subsystem = NULL;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gboolean _tmp56_ = FALSE;
	const gchar* _tmp57_;
	const gchar* _tmp72_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (syspath != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = syspath;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	real_path = _tmp2_;
	_tmp3_ = syspath;
	_tmp4_ = g_path_get_basename (_tmp3_);
	devname = _tmp4_;
	_tmp5_ = real_path;
	_tmp6_ = g_file_test (_tmp5_, G_FILE_TEST_IS_DIR);
	if (!_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = syspath;
		g_critical ("umockdev.vala:562: umockdev_testbed_remove_device(): device %s does no" \
"t exist", _tmp7_);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	{
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = real_path;
		_tmp10_ = g_build_filename (_tmp9_, "subsystem", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_read_link (_tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_tmp8_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp14_ = g_path_get_basename (_tmp8_);
		_g_free0 (subsystem);
		subsystem = _tmp14_;
		_g_free0 (_tmp8_);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = syspath;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("umockdev.vala:572: umockdev_testbed_remove_device(): cannot determine " \
"subsystem of %s: %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		return;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* dev_maj_min = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_;
		gboolean _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* dev_node = NULL;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		_tmp18_ = real_path;
		_tmp19_ = g_build_filename (_tmp18_, "dev", NULL);
		_tmp20_ = _tmp19_;
		g_file_get_contents (_tmp20_, &_tmp21_, NULL, &_inner_error_);
		_g_free0 (dev_maj_min);
		dev_maj_min = _tmp21_;
		_g_free0 (_tmp20_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (dev_maj_min);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch6_g_file_error;
			}
			_g_free0 (dev_maj_min);
			_g_free0 (subsystem);
			_g_free0 (devname);
			_g_free0 (real_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = syspath;
		_tmp24_ = string_contains (_tmp23_, "/block/");
		if (_tmp24_) {
			_tmp22_ = "block";
		} else {
			_tmp22_ = "char";
		}
		_tmp25_ = self->priv->sys_dir;
		_tmp26_ = dev_maj_min;
		_tmp27_ = g_build_filename (_tmp25_, "dev", _tmp22_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		g_unlink (_tmp28_);
		_g_free0 (_tmp28_);
		_tmp29_ = real_path;
		_tmp30_ = umockdev_find_devnode (_tmp29_);
		dev_node = _tmp30_;
		_tmp31_ = dev_node;
		if (_tmp31_ != NULL) {
			gchar* real_node = NULL;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp32_ = self->priv->root_dir;
			_tmp33_ = dev_node;
			_tmp34_ = g_build_filename (_tmp32_, _tmp33_, NULL);
			real_node = _tmp34_;
			_tmp35_ = real_node;
			g_unlink (_tmp35_);
			_tmp36_ = real_node;
			_tmp37_ = g_path_get_dirname (_tmp36_);
			_tmp38_ = _tmp37_;
			g_rmdir (_tmp38_);
			_g_free0 (_tmp38_);
			_tmp39_ = self->priv->root_dir;
			_tmp40_ = dev_node;
			_tmp41_ = string_substring (_tmp40_, (glong) 5, (glong) -1);
			_tmp42_ = _tmp41_;
			_tmp43_ = string_replace (_tmp42_, "/", "_");
			_tmp44_ = _tmp43_;
			_tmp45_ = g_build_filename (_tmp39_, "dev", ".node", _tmp44_, NULL);
			_tmp46_ = _tmp45_;
			g_unlink (_tmp46_);
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (real_node);
		}
		_g_free0 (dev_node);
		_g_free0 (dev_maj_min);
	}
	goto __finally6;
	__catch6_g_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (subsystem);
		_g_free0 (devname);
		_g_free0 (real_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp47_ = self->priv->sys_dir;
	_tmp48_ = subsystem;
	_tmp49_ = devname;
	_tmp50_ = g_build_filename (_tmp47_, "class", _tmp48_, _tmp49_, NULL);
	_tmp51_ = _tmp50_;
	g_unlink (_tmp51_);
	_g_free0 (_tmp51_);
	_tmp52_ = self->priv->sys_dir;
	_tmp53_ = subsystem;
	_tmp54_ = g_build_filename (_tmp52_, "class", _tmp53_, NULL);
	_tmp55_ = _tmp54_;
	g_rmdir (_tmp55_);
	_g_free0 (_tmp55_);
	_tmp57_ = subsystem;
	if (g_strcmp0 (_tmp57_, "usb") == 0) {
		_tmp56_ = TRUE;
	} else {
		const gchar* _tmp58_;
		_tmp58_ = subsystem;
		_tmp56_ = g_strcmp0 (_tmp58_, "pci") == 0;
	}
	if (_tmp56_) {
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp59_ = self->priv->sys_dir;
		_tmp60_ = subsystem;
		_tmp61_ = devname;
		_tmp62_ = g_build_filename (_tmp59_, "bus", _tmp60_, "devices", _tmp61_, NULL);
		_tmp63_ = _tmp62_;
		g_unlink (_tmp63_);
		_g_free0 (_tmp63_);
		_tmp64_ = self->priv->sys_dir;
		_tmp65_ = subsystem;
		_tmp66_ = g_build_filename (_tmp64_, "bus", _tmp65_, "devices", NULL);
		_tmp67_ = _tmp66_;
		g_rmdir (_tmp67_);
		_g_free0 (_tmp67_);
		_tmp68_ = self->priv->sys_dir;
		_tmp69_ = subsystem;
		_tmp70_ = g_build_filename (_tmp68_, "bus", _tmp69_, NULL);
		_tmp71_ = _tmp70_;
		g_rmdir (_tmp71_);
		_g_free0 (_tmp71_);
	}
	_tmp72_ = real_path;
	umockdev_remove_dir (_tmp72_, TRUE);
	_g_free0 (subsystem);
	_g_free0 (devname);
	_g_free0 (real_path);
}


/**
     * umockdev_testbed_add_from_string:
     * @self: A #UMockdevTestbed.
     * @data: Description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This reads
     * the format generated by the umockdev-record tool.
     *
     * Each paragraph defines one device. A line starts with a type tag (like 'E'),
     * followed by a colon, followed by either a value or a "key=value" assignment,
     * depending on the type tag. A device description must start with a 'P:' line.
     * Available type tags are:
     * <itemizedlist>
     *   <listitem><type>P:</type> <emphasis>path</emphasis>: device path in sysfs, starting with
     *             <filename>/devices/</filename>; must occur exactly once at the
     *             start of device definition</listitem>
     *   <listitem><type>E:</type> <emphasis>key=value</emphasis>: udev property
     *             </listitem>
     *   <listitem><type>A:</type> <emphasis>key=value</emphasis>: ASCII sysfs
     *             attribute, with backslash-style escaping of \ (\\) and newlines
     *             (\n)</listitem>
     *   <listitem><type>H:</type> <emphasis>key=value</emphasis>: binary sysfs
     *             attribute, with the value being written as continuous hex string
     *             (e. g. 0081FE0A..)</listitem>
     *   <listitem><type>N:</type> <emphasis>devname</emphasis>[=<emphasis>contents</emphasis>]:
     *             device node name (without the <filename>/dev/</filename>
     *             prefix); if <emphasis>contents</emphasis> is given (encoded in a
     *             continuous hex string), it creates a
     *             <filename>/dev/devname</filename> in the mock environment with
     *             the given contents, otherwise the created dev file will be a
     *             pty; see #umockdev_testbed_get_dev_fd for details.</listitem>
     *   <listitem><type>S:</type> <emphasis>linkname</emphasis>: device node
     *             symlink (without the <filename>/dev/</filename> prefix); ignored right
     *             now.</listitem>
     * </itemizedlist>
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean umockdev_testbed_add_from_string (UMockdevTestbed* self, const gchar* data, GError** error) {
	gboolean result = FALSE;
	gchar* cur_data = NULL;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	{
		GRegex* _tmp0_;
		GRegex* _tmp5_;
		GRegex* _tmp10_;
		_tmp0_ = self->priv->re_record_val;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^([PS]): (.*)(?>\n|$)", 0, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (self->priv->re_record_val);
			self->priv->re_record_val = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
		_tmp5_ = self->priv->re_record_keyval;
		if (_tmp5_ == NULL) {
			GRegex* _tmp6_ = NULL;
			GRegex* _tmp7_;
			GRegex* _tmp9_;
			_tmp7_ = g_regex_new ("^([EAHL]): ([^=\n]+)=(.*)(?>\n|$)", 0, 0, &_inner_error_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp8_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp8_;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_regex_unref0 (self->priv->re_record_keyval);
			self->priv->re_record_keyval = _tmp9_;
			_g_regex_unref0 (_tmp6_);
		}
		_tmp10_ = self->priv->re_record_optval;
		if (_tmp10_ == NULL) {
			GRegex* _tmp11_ = NULL;
			GRegex* _tmp12_;
			GRegex* _tmp14_;
			_tmp12_ = g_regex_new ("^([N]): ([^=\n]+)(?>=([0-9A-F]+))?(?>\n|$)", 0, 0, &_inner_error_);
			_tmp11_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp13_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch7_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp13_;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_regex_unref0 (self->priv->re_record_optval);
			self->priv->re_record_optval = _tmp14_;
			_g_regex_unref0 (_tmp11_);
		}
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e->message;
		g_error ("umockdev.vala:657: Internal error, cannot create regex: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			gboolean _tmp16_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp16_;
		} else {
			gboolean _tmp17_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp17_;
		}
	}
	_tmp18_ = data;
	_tmp19_ = g_strdup (_tmp18_);
	cur_data = _tmp19_;
	while (TRUE) {
		const gchar* _tmp20_;
		gchar _tmp21_;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp27_;
		_tmp20_ = cur_data;
		_tmp21_ = string_get (_tmp20_, (glong) 0);
		if (!(_tmp21_ != '\0')) {
			break;
		}
		_tmp23_ = cur_data;
		_tmp24_ = umockdev_testbed_add_dev_from_string (self, _tmp23_, &_inner_error_);
		_tmp22_ = _tmp24_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				gboolean _tmp25_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_free0 (cur_data);
				return _tmp25_;
			} else {
				gboolean _tmp26_ = FALSE;
				_g_free0 (cur_data);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp26_;
			}
		}
		_tmp27_ = _tmp22_;
		_tmp22_ = NULL;
		_g_free0 (cur_data);
		cur_data = _tmp27_;
		_g_free0 (_tmp22_);
	}
	result = TRUE;
	_g_free0 (cur_data);
	return result;
}


/**
     * umockdev_testbed_add_from_file:
     * @self: A #UMockdevTestbed.
     * @path: Path to file with description of the device(s) as generated with umockdev-record
     * @error: return location for a GError, or %NULL
     *
     * Add a set of devices to the testbed from a textual description. This
     * reads a file with the format generated by the umockdev-record tool, and
     * is mostly a convenience wrapper around
     * @umockdev_testbed_add_from_string.
     *
     * Returns: %TRUE on success, %FALSE if the @path cannot be read or thhe
     *          data is invalid and an error occurred.
     */
gboolean umockdev_testbed_add_from_file (UMockdevTestbed* self, const gchar* path, GError** error) {
	gboolean result = FALSE;
	gchar* contents = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == UMOCKDEV_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			gboolean _tmp2_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			return _tmp2_;
		} else {
			gboolean _tmp3_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	_tmp5_ = contents;
	_tmp6_ = umockdev_testbed_add_from_string (self, _tmp5_, &_inner_error_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == UMOCKDEV_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (contents);
			return _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp8_;
		}
	}
	result = _tmp4_;
	_g_free0 (contents);
	return result;
}


/**
     * umockdev_testbed_uevent:
     * @self: A #UMockdevTestbed.
     * @devpath: The full device path, as returned by #umockdev_testbed_add_device()
     * @action: "add", "remove", or "change"
     *
     * Generate an uevent for a device.
     */
void umockdev_testbed_uevent (UMockdevTestbed* self, const gchar* devpath, const gchar* action) {
	uevent_sender* _tmp0_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	uevent_sender* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (devpath != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->ev_sender;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		uevent_sender* _tmp2_;
		uevent_sender* _tmp3_;
		g_debug ("umockdev.vala:700: umockdev_testbed_uevent: lazily initializing uevent" \
"_sender");
		_tmp1_ = self->priv->root_dir;
		_tmp2_ = uevent_sender_open (_tmp1_);
		_uevent_sender_close0 (self->priv->ev_sender);
		self->priv->ev_sender = _tmp2_;
		_tmp3_ = self->priv->ev_sender;
		_vala_assert (_tmp3_ != NULL, "this.ev_sender != null");
	}
	_tmp4_ = action;
	_tmp5_ = devpath;
	g_debug ("umockdev.vala:704: umockdev_testbed_uevent: sending uevent %s for devi" \
"ce %s", _tmp4_, _tmp5_);
	_tmp6_ = self->priv->ev_sender;
	_tmp7_ = devpath;
	_tmp8_ = action;
	uevent_sender_send (_tmp6_, _tmp7_, _tmp8_);
}


/**
     * umockdev_testbed_load_ioctl:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the ioctl record.
     *       %NULL is valid; in this case the ioctl record is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the ioctl record file.
     * @error: return location for a GError, or %NULL
     *
     * Load an ioctl record file for a particular device into the testbed.
     * ioctl records can be created with umockdev-record --ioctl.
     * They can optionally be xz compressed to save space (but then are
     * required to have an .xz file name suffix).
     *
     * Returns: %TRUE on success, %FALSE if the data is invalid and an error
     *          occurred.
     */
static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


gboolean umockdev_testbed_load_ioctl (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error) {
	gboolean result = FALSE;
	GDataInputStream* recording = NULL;
	gchar* owned_dev = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp32_;
	gchar* dest = NULL;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gint _tmp64_;
	gchar* contents = NULL;
	GDataInputStream* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp68_;
	gboolean _tmp70_ = FALSE;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	gboolean _tmp73_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = dev;
	_tmp1_ = g_strdup (_tmp0_);
	owned_dev = _tmp1_;
	_tmp2_ = recordfile;
	_tmp3_ = g_str_has_suffix (_tmp2_, ".xz");
	if (_tmp3_) {
		{
			gchar* contents = NULL;
			gint exit = 0;
			gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar** _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			gchar* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp13_;
			const gchar* _tmp14_;
			guint8* _tmp15_;
			gint _tmp15__length1;
			guint8* _tmp16_;
			gint _tmp16__length1;
			guint8* _tmp17_;
			gint _tmp17__length1;
			GMemoryInputStream* _tmp18_;
			GMemoryInputStream* _tmp19_;
			GDataInputStream* _tmp20_;
			_tmp4_ = g_strdup ("xz");
			_tmp5_ = g_strdup ("-cd");
			_tmp6_ = recordfile;
			_tmp7_ = g_strdup (_tmp6_);
			_tmp8_ = g_new0 (gchar*, 3 + 1);
			_tmp8_[0] = _tmp4_;
			_tmp8_[1] = _tmp5_;
			_tmp8_[2] = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp9__length1 = 3;
			g_spawn_sync (NULL, _tmp9_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp10_, NULL, &_tmp11_, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp10_;
			exit = _tmp11_;
			_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp12_ = FALSE;
				_g_free0 (contents);
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch8_g_spawn_error;
				}
				_g_free0 (contents);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp12_;
			}
			_tmp13_ = exit;
			_vala_assert (_tmp13_ == 0, "exit == 0");
			_tmp14_ = contents;
			_tmp15_ = string_get_data (_tmp14_, &_tmp15__length1);
			_tmp16_ = _tmp15_;
			_tmp16__length1 = _tmp15__length1;
			_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup1 (_tmp16_, _tmp16__length1) : ((gpointer) _tmp16_);
			_tmp17__length1 = _tmp16__length1;
			_tmp18_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp17_, _tmp17__length1, NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_data_input_stream_new ((GInputStream*) _tmp19_);
			_g_object_unref0 (recording);
			recording = _tmp20_;
			_g_object_unref0 (_tmp19_);
			_g_free0 (contents);
		}
		goto __finally8;
		__catch8_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = recordfile;
			_tmp22_ = e->message;
			g_error ("umockdev.vala:745: Cannot call xz to decompress %s: %s", _tmp21_, _tmp22_);
			_g_error_free0 (e);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp23_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp23_;
		}
	} else {
		GFileInputStream* _tmp24_ = NULL;
		const gchar* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		GFileInputStream* _tmp28_;
		GFileInputStream* _tmp29_;
		GDataInputStream* _tmp31_;
		_tmp25_ = recordfile;
		_tmp26_ = g_file_new_for_path (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_file_read (_tmp27_, NULL, &_inner_error_);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp27_);
		_tmp24_ = _tmp29_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp30_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp30_;
		}
		_tmp31_ = g_data_input_stream_new ((GInputStream*) _tmp24_);
		_g_object_unref0 (recording);
		recording = _tmp31_;
		_g_object_unref0 (_tmp24_);
	}
	_tmp32_ = owned_dev;
	if (_tmp32_ == NULL) {
		gchar* line = NULL;
		GDataInputStream* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp45_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp47_ = NULL;
		GRegex* _tmp48_;
		const gchar* _tmp50_;
		GMatchInfo* _tmp51_ = NULL;
		gboolean _tmp52_;
		GMatchInfo* _tmp54_;
		gchar* _tmp55_;
		GDataInputStream* _tmp56_;
		_tmp33_ = recording;
		_tmp34_ = g_data_input_stream_read_line (_tmp33_, NULL, NULL, &_inner_error_);
		line = _tmp34_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp35_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp35_;
		}
		while (TRUE) {
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp37_;
			gchar* _tmp40_ = NULL;
			GDataInputStream* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp44_;
			_tmp37_ = line;
			if (_tmp37_ != NULL) {
				const gchar* _tmp38_;
				gboolean _tmp39_;
				_tmp38_ = line;
				_tmp39_ = g_str_has_prefix (_tmp38_, "#");
				_tmp36_ = _tmp39_;
			} else {
				_tmp36_ = FALSE;
			}
			if (!_tmp36_) {
				break;
			}
			_tmp41_ = recording;
			_tmp42_ = g_data_input_stream_read_line (_tmp41_, NULL, NULL, &_inner_error_);
			_tmp40_ = _tmp42_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp43_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_free0 (line);
				_g_free0 (owned_dev);
				_g_object_unref0 (recording);
				return _tmp43_;
			}
			_tmp44_ = _tmp40_;
			_tmp40_ = NULL;
			_g_free0 (line);
			line = _tmp44_;
			_g_free0 (_tmp40_);
		}
		_tmp45_ = line;
		if (_tmp45_ == NULL) {
			const gchar* _tmp46_;
			_tmp46_ = recordfile;
			g_error ("umockdev.vala:760: ioctl recording file %s has no non-comment content", _tmp46_);
		}
		_tmp48_ = g_regex_new ("^@DEV (.*)(\n|$)", 0, 0, &_inner_error_);
		_tmp47_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp49_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp49_;
		}
		_tmp50_ = line;
		_tmp52_ = g_regex_match (_tmp47_, _tmp50_, 0, &_tmp51_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp51_;
		if (!_tmp52_) {
			const gchar* _tmp53_;
			_tmp53_ = recordfile;
			g_error ("umockdev.vala:764: null passed for device node, but recording %s has n" \
"o @DEV header", _tmp53_);
		}
		_tmp54_ = header_matcher;
		_tmp55_ = g_match_info_fetch (_tmp54_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp55_;
		_tmp56_ = recording;
		g_seekable_seek ((GSeekable*) _tmp56_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp57_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (_tmp47_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_free0 (owned_dev);
			_g_object_unref0 (recording);
			return _tmp57_;
		}
		_g_regex_unref0 (_tmp47_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
	}
	_tmp58_ = self->priv->root_dir;
	_tmp59_ = owned_dev;
	_tmp60_ = g_build_filename (_tmp58_, "ioctl", _tmp59_, NULL);
	dest = _tmp60_;
	_tmp61_ = dest;
	_tmp62_ = g_path_get_dirname (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = g_mkdir_with_parents (_tmp63_, 0755);
	_vala_assert (_tmp64_ == 0, "DirUtils.create_with_parents(Path.get_dirname(dest), 0755) == 0");
	_g_free0 (_tmp63_);
	_tmp65_ = recording;
	_tmp66_ = g_data_input_stream_read_upto (_tmp65_, "", (gssize) 0, NULL, NULL, &_inner_error_);
	contents = _tmp66_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp67_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return _tmp67_;
	}
	_tmp68_ = contents;
	if (_tmp68_ == NULL) {
		gchar* _tmp69_;
		_tmp69_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp69_;
	}
	_tmp71_ = dest;
	_tmp72_ = contents;
	_tmp73_ = g_file_set_contents (_tmp71_, _tmp72_, (gssize) -1, &_inner_error_);
	_tmp70_ = _tmp73_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp74_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (dest);
		_g_free0 (owned_dev);
		_g_object_unref0 (recording);
		return _tmp74_;
	}
	result = _tmp70_;
	_g_free0 (contents);
	_g_free0 (dest);
	_g_free0 (owned_dev);
	_g_object_unref0 (recording);
	return result;
}


/**
     * umockdev_testbed_load_script:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the script record.
     *       %NULL is valid; in this case the script is associated with
     *       the device node it was recorded from.
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Load a script record file for a particular device into the testbed.
     * script records can be created with umockdev-record --script.
     *
     * Returns: %TRUE on success, %FALSE if @recordfile is invalid and an error
     *          occurred.
     */
gboolean umockdev_testbed_load_script (UMockdevTestbed* self, const gchar* dev, const gchar* recordfile, GError** error) {
	gboolean result = FALSE;
	gchar* owned_dev = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp34_;
	const gchar* _tmp35_;
	gboolean _tmp36_;
	gint fd = 0;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	UMockdevScriptRunner* _tmp46_ = NULL;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gint _tmp49_;
	UMockdevScriptRunner* _tmp50_;
	GHashTable* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	UMockdevScriptRunner* _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = dev;
	_tmp1_ = g_strdup (_tmp0_);
	owned_dev = _tmp1_;
	_tmp2_ = owned_dev;
	if (_tmp2_ == NULL) {
		GFileInputStream* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFileInputStream* _tmp7_;
		GFileInputStream* _tmp8_;
		GDataInputStream* recording = NULL;
		GDataInputStream* _tmp10_;
		gchar* line = NULL;
		GDataInputStream* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp23_;
		GMatchInfo* header_matcher = NULL;
		GRegex* _tmp25_ = NULL;
		GRegex* _tmp26_;
		const gchar* _tmp28_;
		GMatchInfo* _tmp29_ = NULL;
		gboolean _tmp30_;
		GMatchInfo* _tmp32_;
		gchar* _tmp33_;
		_tmp4_ = recordfile;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp3_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (owned_dev);
			return _tmp9_;
		}
		_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
		recording = _tmp10_;
		_tmp11_ = recording;
		_tmp12_ = g_data_input_stream_read_line (_tmp11_, NULL, NULL, &_inner_error_);
		line = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp13_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (recording);
			_g_object_unref0 (_tmp3_);
			_g_free0 (owned_dev);
			return _tmp13_;
		}
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_;
			gchar* _tmp18_ = NULL;
			GDataInputStream* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp22_;
			_tmp15_ = line;
			if (_tmp15_ != NULL) {
				const gchar* _tmp16_;
				gboolean _tmp17_;
				_tmp16_ = line;
				_tmp17_ = g_str_has_prefix (_tmp16_, "#");
				_tmp14_ = _tmp17_;
			} else {
				_tmp14_ = FALSE;
			}
			if (!_tmp14_) {
				break;
			}
			_tmp19_ = recording;
			_tmp20_ = g_data_input_stream_read_line (_tmp19_, NULL, NULL, &_inner_error_);
			_tmp18_ = _tmp20_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp21_ = FALSE;
				g_propagate_error (error, _inner_error_);
				_g_free0 (line);
				_g_object_unref0 (recording);
				_g_object_unref0 (_tmp3_);
				_g_free0 (owned_dev);
				return _tmp21_;
			}
			_tmp22_ = _tmp18_;
			_tmp18_ = NULL;
			_g_free0 (line);
			line = _tmp22_;
			_g_free0 (_tmp18_);
		}
		_tmp23_ = line;
		if (_tmp23_ == NULL) {
			const gchar* _tmp24_;
			_tmp24_ = recordfile;
			g_error ("umockdev.vala:806: script recording %s has no non-comment content", _tmp24_);
		}
		_tmp26_ = g_regex_new ("^d 0 (.*)(\n|$)", 0, 0, &_inner_error_);
		_tmp25_ = _tmp26_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp27_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_match_info_unref0 (header_matcher);
			_g_free0 (line);
			_g_object_unref0 (recording);
			_g_object_unref0 (_tmp3_);
			_g_free0 (owned_dev);
			return _tmp27_;
		}
		_tmp28_ = line;
		_tmp30_ = g_regex_match (_tmp25_, _tmp28_, 0, &_tmp29_);
		_g_match_info_unref0 (header_matcher);
		header_matcher = _tmp29_;
		if (!_tmp30_) {
			const gchar* _tmp31_;
			_tmp31_ = recordfile;
			g_error ("umockdev.vala:810: null passed for device node, but recording %s has n" \
"o d 0 header", _tmp31_);
		}
		_tmp32_ = header_matcher;
		_tmp33_ = g_match_info_fetch (_tmp32_, 1);
		_g_free0 (owned_dev);
		owned_dev = _tmp33_;
		_g_regex_unref0 (_tmp25_);
		_g_match_info_unref0 (header_matcher);
		_g_free0 (line);
		_g_object_unref0 (recording);
		_g_object_unref0 (_tmp3_);
	}
	_tmp34_ = self->priv->dev_script_runner;
	_tmp35_ = owned_dev;
	_tmp36_ = g_hash_table_contains (_tmp34_, _tmp35_);
	_vala_assert (!_tmp36_, "!this.dev_script_runner.contains (owned_dev)");
	_tmp37_ = owned_dev;
	_tmp38_ = umockdev_testbed_get_dev_fd (self, _tmp37_);
	fd = _tmp38_;
	_tmp39_ = fd;
	if (_tmp39_ < 0) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GError* _tmp43_;
		GError* _tmp44_;
		gboolean _tmp45_ = FALSE;
		_tmp40_ = owned_dev;
		_tmp41_ = g_strconcat (_tmp40_, " is not a device suitable for scripts", NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp42_);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		_inner_error_ = _tmp44_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		return _tmp45_;
	}
	_tmp47_ = owned_dev;
	_tmp48_ = recordfile;
	_tmp49_ = fd;
	_tmp50_ = umockdev_script_runner_new (_tmp47_, _tmp48_, _tmp49_, &_inner_error_);
	_tmp46_ = _tmp50_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp51_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		return _tmp51_;
	}
	_tmp52_ = self->priv->dev_script_runner;
	_tmp53_ = owned_dev;
	_tmp54_ = g_strdup (_tmp53_);
	_tmp55_ = _tmp46_;
	_tmp46_ = NULL;
	g_hash_table_insert (_tmp52_, _tmp54_, _tmp55_);
	result = TRUE;
	_umockdev_script_runner_unref0 (_tmp46_);
	_g_free0 (owned_dev);
	return result;
}


/**
     * umockdev_testbed_load_socket_script:
     * @self: A #UMockdevTestbed.
     * @path: Unix socket path
     * @type: Unix socket type (#SOCK_STREAM, #SOCK_DGRAM)
     * @recordfile: Path of the script record file.
     * @error: return location for a GError, or %NULL
     *
     * Add an Unix socket to the testbed that is backed by a recorded script.
     * Clients can connect to the socket using @path (i. e. without the testbed
     * prefix).
     *
     * Returns: %TRUE on success, %FALSE if the @path or @type are
     *          invalid and an error occurred.
     */
gboolean umockdev_testbed_load_socket_script (UMockdevTestbed* self, const gchar* path, gint type, const gchar* recordfile, GError** error) {
	gboolean result = FALSE;
	gint fd = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* real_path = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_;
	UMockdevSocketServer* _tmp28_;
	UMockdevSocketServer* _tmp30_;
	const gchar* _tmp31_;
	gint _tmp32_;
	const gchar* _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (recordfile != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = socket (AF_UNIX, _tmp0_, 0);
	fd = _tmp1_;
	_tmp2_ = fd;
	if (_tmp2_ < 0) {
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp3_ = type;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		_tmp6_ = g_strdup_printf ("Cannot create socket type %i: %s", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			gboolean _tmp10_ = FALSE;
			g_propagate_error (error, _inner_error_);
			return _tmp10_;
		} else {
			gboolean _tmp11_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp11_;
		}
	}
	_tmp12_ = self->priv->root_dir;
	_tmp13_ = path;
	_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
	real_path = _tmp14_;
	_tmp15_ = real_path;
	_tmp16_ = g_path_get_dirname (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_mkdir_with_parents (_tmp17_, 0755);
	_tmp19_ = _tmp18_ != 0;
	_g_free0 (_tmp17_);
	if (_tmp19_) {
		gint _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		_tmp20_ = errno;
		_tmp21_ = g_strerror (_tmp20_);
		_tmp22_ = g_strdup_printf ("Cannot create socket path: %s", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_inner_error_ = _tmp25_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			gboolean _tmp26_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (real_path);
			return _tmp26_;
		} else {
			gboolean _tmp27_ = FALSE;
			_g_free0 (real_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp27_;
		}
	}
	_tmp28_ = self->priv->socket_server;
	if (_tmp28_ == NULL) {
		UMockdevSocketServer* _tmp29_;
		_tmp29_ = umockdev_socket_server_new ();
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = _tmp29_;
	}
	_tmp30_ = self->priv->socket_server;
	_tmp31_ = real_path;
	_tmp32_ = fd;
	_tmp33_ = recordfile;
	umockdev_socket_server_add (_tmp30_, _tmp31_, _tmp32_, _tmp33_);
	result = TRUE;
	_g_free0 (real_path);
	return result;
}


/**
     * umockdev_testbed_load_evemu_events:
     * @self: A #UMockdevTestbed.
     * @dev: Device path (/dev/...) for which to load the evemu events.
     *       %NULL is valid; in this case the events are associated with
     *       the device node it was recorded from.
     * @eventsfile: Path of the evemu events file.
     * @error: return location for a GError, or %NULL
     *
     * Load an evemu event file for a particular device into the testbed. These
     * have a very simple line-based format with 4 fields that represent the
     * data in a struct input_event:
     *
     *  E: sec.usec evtype(hex) evcode(hex) evvalue
     *
     * The timestamps in those are absolute, and are usually as they were at
     * record time. When loading them into umockdev they are interpreted
     * relatively: the first event happens immediately, and the time to the
     * next event is the difference between the corresponding timestamps in the
     * .event file.
     *
     * Returns: %TRUE on success, %FALSE if @eventsfile is invalid and an error
     *          occurred.
     */
static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean umockdev_testbed_load_evemu_events (UMockdevTestbed* self, const gchar* dev, const gchar* eventsfile, GError** error) {
	gboolean result = FALSE;
	GFile* f_ev = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFileInputStream* _tmp4_;
	GDataInputStream* s_ev = NULL;
	GDataInputStream* _tmp6_;
	gchar* line = NULL;
	gchar* recorded_dev = NULL;
	gsize len = 0UL;
	GMatchInfo* match = NULL;
	struct input_event ev = {0};
	struct input_event _tmp7_ = {0};
	GRegex* default_dev_re = NULL;
	GRegex* _tmp8_;
	GRegex* event_re = NULL;
	GRegex* _tmp10_;
	gchar* script_file = NULL;
	gint script_fd = 0;
	gchar* _tmp12_ = NULL;
	gint _tmp13_;
	gint delay = 0;
	gboolean first = FALSE;
	gint _tmp92_;
	gchar* owned_dev = NULL;
	const gchar* _tmp93_;
	gchar* _tmp94_;
	const gchar* _tmp95_;
	gboolean ret = FALSE;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	gboolean _tmp102_;
	const gchar* _tmp104_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (eventsfile != NULL, FALSE);
	_tmp0_ = eventsfile;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	f_ev = _tmp1_;
	_tmp3_ = f_ev;
	_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (f_ev);
		return _tmp5_;
	}
	_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
	s_ev = _tmp6_;
	recorded_dev = NULL;
	ev = _tmp7_;
	_tmp8_ = g_regex_new ("^# device (.*)$", 0, 0, &_inner_error_);
	default_dev_re = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (f_ev);
		return _tmp9_;
	}
	_tmp10_ = g_regex_new ("^E: ([0-9]+)\\.([0-9]+) +([0-9a-fA-F]+) +([0-9a-fA-F]+) +(-?[0-9]+) *#" \
"?", 0, 0, &_inner_error_);
	event_re = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (f_ev);
		return _tmp11_;
	}
	_tmp13_ = g_file_open_tmp ("evemu.XXXXXX.script", &_tmp12_, &_inner_error_);
	_g_free0 (script_file);
	script_file = _tmp12_;
	script_fd = _tmp13_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (f_ev);
		return _tmp14_;
	}
	delay = 0;
	first = TRUE;
	while (TRUE) {
		gchar* _tmp15_ = NULL;
		GDataInputStream* _tmp16_;
		gsize _tmp17_ = 0UL;
		gchar* _tmp18_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GRegex* _tmp22_;
		const gchar* _tmp23_;
		GMatchInfo* _tmp24_ = NULL;
		gboolean _tmp25_;
		GRegex* _tmp28_;
		const gchar* _tmp29_;
		GMatchInfo* _tmp30_ = NULL;
		gboolean _tmp31_;
		time_t ev_sec = 0;
		GMatchInfo* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		guint64 _tmp39_;
		time_t _tmp40_;
		time_t ev_usec = 0;
		GMatchInfo* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		guint64 _tmp44_;
		time_t _tmp45_;
		gboolean _tmp46_;
		time_t _tmp56_;
		time_t _tmp57_;
		GMatchInfo* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gulong _tmp61_;
		GMatchInfo* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gulong _tmp65_;
		GMatchInfo* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gint _tmp69_;
		guint8* ev_data = NULL;
		guint8* _tmp70_;
		gint ev_data_length1;
		gint _ev_data_size_;
		guint8* _tmp71_;
		gint _tmp71__length1;
		guint8* _tmp72_;
		gint _tmp72__length1;
		gchar* script_line = NULL;
		gint _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		guint8* _tmp80_;
		gint _tmp80__length1;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gint _tmp87_;
		const gchar* _tmp88_;
		const gchar* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		_tmp16_ = s_ev;
		_tmp18_ = g_data_input_stream_read_line (_tmp16_, &_tmp17_, NULL, &_inner_error_);
		len = _tmp17_;
		_tmp15_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp19_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_free0 (script_file);
			_g_regex_unref0 (event_re);
			_g_regex_unref0 (default_dev_re);
			_g_match_info_unref0 (match);
			_g_free0 (recorded_dev);
			_g_free0 (line);
			_g_object_unref0 (s_ev);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (f_ev);
			return _tmp19_;
		}
		_tmp20_ = _tmp15_;
		_tmp15_ = NULL;
		_g_free0 (line);
		line = _tmp20_;
		_tmp21_ = line;
		if (!(_tmp21_ != NULL)) {
			_g_free0 (_tmp15_);
			break;
		}
		_tmp22_ = default_dev_re;
		_tmp23_ = line;
		_tmp25_ = g_regex_match (_tmp22_, _tmp23_, 0, &_tmp24_);
		_g_match_info_unref0 (match);
		match = _tmp24_;
		if (_tmp25_) {
			GMatchInfo* _tmp26_;
			gchar* _tmp27_;
			_tmp26_ = match;
			_tmp27_ = g_match_info_fetch (_tmp26_, 1);
			_g_free0 (recorded_dev);
			recorded_dev = _tmp27_;
			_g_free0 (_tmp15_);
			continue;
		}
		_tmp28_ = event_re;
		_tmp29_ = line;
		_tmp31_ = g_regex_match (_tmp28_, _tmp29_, 0, &_tmp30_);
		_g_match_info_unref0 (match);
		match = _tmp30_;
		if (!_tmp31_) {
			const gchar* _tmp32_;
			gboolean _tmp33_;
			_tmp32_ = line;
			_tmp33_ = g_str_has_prefix (_tmp32_, "#");
			if (!_tmp33_) {
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp34_ = eventsfile;
				_tmp35_ = line;
				g_warning ("umockdev.vala:909: Ignoring invalid line in %s: %s", _tmp34_, _tmp35_);
			}
			_g_free0 (_tmp15_);
			continue;
		}
		_tmp36_ = match;
		_tmp37_ = g_match_info_fetch (_tmp36_, 1);
		_tmp38_ = _tmp37_;
		_tmp39_ = uint64_parse (_tmp38_);
		_tmp40_ = (time_t) _tmp39_;
		_g_free0 (_tmp38_);
		ev_sec = _tmp40_;
		_tmp41_ = match;
		_tmp42_ = g_match_info_fetch (_tmp41_, 2);
		_tmp43_ = _tmp42_;
		_tmp44_ = uint64_parse (_tmp43_);
		_tmp45_ = (time_t) _tmp44_;
		_g_free0 (_tmp43_);
		ev_usec = _tmp45_;
		_tmp46_ = first;
		if (_tmp46_) {
			delay = 0;
			first = FALSE;
		} else {
			time_t _tmp47_;
			struct input_event _tmp48_;
			struct timeval _tmp49_;
			time_t _tmp50_;
			time_t _tmp51_;
			struct input_event _tmp52_;
			struct timeval _tmp53_;
			glong _tmp54_;
			gint _tmp55_;
			_tmp47_ = ev_sec;
			_tmp48_ = ev;
			_tmp49_ = _tmp48_.time;
			_tmp50_ = _tmp49_.tv_sec;
			_tmp51_ = ev_usec;
			_tmp52_ = ev;
			_tmp53_ = _tmp52_.time;
			_tmp54_ = _tmp53_.tv_usec;
			delay = (((gint) (_tmp47_ - _tmp50_)) * 1000) + (((gint) (_tmp51_ - _tmp54_)) / 1000);
			_tmp55_ = delay;
			if (_tmp55_ < 0) {
				delay = 0;
			}
		}
		_tmp56_ = ev_sec;
		ev.time.tv_sec = _tmp56_;
		_tmp57_ = ev_usec;
		ev.time.tv_usec = (glong) _tmp57_;
		_tmp58_ = match;
		_tmp59_ = g_match_info_fetch (_tmp58_, 3);
		_tmp60_ = _tmp59_;
		_tmp61_ = strtoul (_tmp60_, NULL, 16);
		ev.type = (guint16) _tmp61_;
		_g_free0 (_tmp60_);
		_tmp62_ = match;
		_tmp63_ = g_match_info_fetch (_tmp62_, 4);
		_tmp64_ = _tmp63_;
		_tmp65_ = strtoul (_tmp64_, NULL, 16);
		ev.code = (guint16) _tmp65_;
		_g_free0 (_tmp64_);
		_tmp66_ = match;
		_tmp67_ = g_match_info_fetch (_tmp66_, 5);
		_tmp68_ = _tmp67_;
		_tmp69_ = atoi (_tmp68_);
		ev.value = (gint32) _tmp69_;
		_g_free0 (_tmp68_);
		_tmp70_ = g_new0 (guint8, sizeof (struct input_event));
		ev_data = _tmp70_;
		ev_data_length1 = sizeof (struct input_event);
		_ev_data_size_ = ev_data_length1;
		_tmp71_ = ev_data;
		_tmp71__length1 = ev_data_length1;
		_tmp72_ = ev_data;
		_tmp72__length1 = ev_data_length1;
		memcpy (_tmp71_, &ev, (gsize) _tmp72__length1);
		_tmp73_ = delay;
		_tmp74_ = g_strdup_printf ("%i", _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strconcat ("r ", _tmp75_, NULL);
		_tmp77_ = _tmp76_;
		_tmp78_ = g_strconcat (_tmp77_, " ", NULL);
		_tmp79_ = _tmp78_;
		_tmp80_ = ev_data;
		_tmp80__length1 = ev_data_length1;
		_tmp81_ = umockdev_script_runner_encode (_tmp80_, _tmp80__length1);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strconcat (_tmp79_, _tmp82_, NULL);
		_tmp84_ = _tmp83_;
		_tmp85_ = g_strconcat (_tmp84_, "\n", NULL);
		_tmp86_ = _tmp85_;
		_g_free0 (_tmp84_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp79_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp75_);
		script_line = _tmp86_;
		_tmp87_ = script_fd;
		_tmp88_ = script_line;
		_tmp89_ = script_line;
		_tmp90_ = strlen (_tmp89_);
		_tmp91_ = _tmp90_;
		write (_tmp87_, _tmp88_, (gsize) _tmp91_);
		_g_free0 (script_line);
		ev_data = (g_free (ev_data), NULL);
		_g_free0 (_tmp15_);
	}
	_tmp92_ = script_fd;
	close (_tmp92_);
	_tmp93_ = dev;
	_tmp94_ = g_strdup (_tmp93_);
	owned_dev = _tmp94_;
	_tmp95_ = owned_dev;
	if (_tmp95_ == NULL) {
		const gchar* _tmp96_;
		const gchar* _tmp98_;
		gchar* _tmp99_;
		_tmp96_ = recorded_dev;
		if (_tmp96_ == NULL) {
			const gchar* _tmp97_;
			_tmp97_ = eventsfile;
			g_error ("umockdev.vala:939: null passed for device node, but recording %s has n" \
"o '# device' header", _tmp97_);
		}
		_tmp98_ = recorded_dev;
		_tmp99_ = g_strdup (_tmp98_);
		_g_free0 (owned_dev);
		owned_dev = _tmp99_;
	}
	_tmp100_ = owned_dev;
	_tmp101_ = script_file;
	_tmp102_ = umockdev_testbed_load_script (self, _tmp100_, _tmp101_, &_inner_error_);
	ret = _tmp102_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp103_ = FALSE;
		g_propagate_error (error, _inner_error_);
		_g_free0 (owned_dev);
		_g_free0 (script_file);
		_g_regex_unref0 (event_re);
		_g_regex_unref0 (default_dev_re);
		_g_match_info_unref0 (match);
		_g_free0 (recorded_dev);
		_g_free0 (line);
		_g_object_unref0 (s_ev);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (f_ev);
		return _tmp103_;
	}
	_tmp104_ = script_file;
	g_unlink (_tmp104_);
	result = ret;
	_g_free0 (owned_dev);
	_g_free0 (script_file);
	_g_regex_unref0 (event_re);
	_g_regex_unref0 (default_dev_re);
	_g_match_info_unref0 (match);
	_g_free0 (recorded_dev);
	_g_free0 (line);
	_g_object_unref0 (s_ev);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (f_ev);
	return result;
}


static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* umockdev_testbed_add_dev_from_string (UMockdevTestbed* self, const gchar* data, GError** error) {
	gchar* result = NULL;
	gchar type = '\0';
	gchar* key = NULL;
	gchar* val = NULL;
	gchar* devpath = NULL;
	gchar* subsystem = NULL;
	gchar* majmin = NULL;
	gchar* cur_data = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* devnode_path = NULL;
	guint8* devnode_contents = NULL;
	guint8* _tmp2_;
	gint devnode_contents_length1;
	gint _devnode_contents_size_;
	const gchar* _tmp3_;
	gchar _tmp4_ = '\0';
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	const gchar* _tmp16_;
	gchar** attrs = NULL;
	gchar** _tmp17_;
	gint attrs_length1;
	gint _attrs_size_;
	gchar** binattrs = NULL;
	gchar** _tmp18_;
	gint binattrs_length1;
	gint _binattrs_size_;
	gchar** linkattrs = NULL;
	gchar** _tmp19_;
	gint linkattrs_length1;
	gint _linkattrs_size_;
	gchar** props = NULL;
	gchar** _tmp20_;
	gint props_length1;
	gint _props_size_;
	const gchar* _tmp84_;
	const gchar* _tmp87_;
	const gchar* _tmp88_;
	gchar* syspath = NULL;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar** _tmp93_;
	gint _tmp93__length1;
	gchar** _tmp94_;
	gint _tmp94__length1;
	gchar* _tmp95_;
	gchar* _tmp96_;
	const gchar* _tmp122_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	devpath = NULL;
	subsystem = NULL;
	majmin = NULL;
	_tmp0_ = data;
	_tmp1_ = g_strdup (_tmp0_);
	cur_data = _tmp1_;
	devnode_path = NULL;
	_tmp2_ = g_new0 (guint8, 0);
	devnode_contents = _tmp2_;
	devnode_contents_length1 = 0;
	_devnode_contents_size_ = devnode_contents_length1;
	_tmp3_ = cur_data;
	_tmp7_ = umockdev_testbed_record_parse_line (self, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	type = _tmp4_;
	_g_free0 (key);
	key = _tmp5_;
	_g_free0 (devpath);
	devpath = _tmp6_;
	_g_free0 (cur_data);
	cur_data = _tmp7_;
	_tmp9_ = cur_data;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gchar _tmp10_;
		_tmp10_ = type;
		_tmp8_ = _tmp10_ != 'P';
	}
	if (_tmp8_) {
		GError* _tmp11_;
		_tmp11_ = g_error_new_literal (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "device descriptions must start with a \"P: /devices/path/...\" line");
		_inner_error_ = _tmp11_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp12_ = devpath;
	_tmp13_ = g_str_has_prefix (_tmp12_, "/devices/");
	if (!_tmp13_) {
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp14_ = devpath;
		_tmp15_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "invalid device path '%s': must start with /devices/", _tmp14_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = devpath;
	g_debug ("umockdev.vala:966: parsing device description for %s", _tmp16_);
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	attrs = _tmp17_;
	attrs_length1 = 0;
	_attrs_size_ = attrs_length1;
	_tmp18_ = g_new0 (gchar*, 0 + 1);
	binattrs = _tmp18_;
	binattrs_length1 = 0;
	_binattrs_size_ = binattrs_length1;
	_tmp19_ = g_new0 (gchar*, 0 + 1);
	linkattrs = _tmp19_;
	linkattrs_length1 = 0;
	_linkattrs_size_ = linkattrs_length1;
	_tmp20_ = g_new0 (gchar*, 0 + 1);
	props = _tmp20_;
	props_length1 = 0;
	_props_size_ = props_length1;
	while (TRUE) {
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		const gchar* _tmp27_;
		gchar _tmp28_ = '\0';
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar _tmp35_;
		_tmp22_ = cur_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp24_ > 0) {
			const gchar* _tmp25_;
			gchar _tmp26_;
			_tmp25_ = cur_data;
			_tmp26_ = string_get (_tmp25_, (glong) 0);
			_tmp21_ = _tmp26_ != '\n';
		} else {
			_tmp21_ = FALSE;
		}
		if (!_tmp21_) {
			break;
		}
		_tmp27_ = cur_data;
		_tmp31_ = umockdev_testbed_record_parse_line (self, _tmp27_, &_tmp28_, &_tmp29_, &_tmp30_);
		type = _tmp28_;
		_g_free0 (key);
		key = _tmp29_;
		_g_free0 (val);
		val = _tmp30_;
		_g_free0 (cur_data);
		cur_data = _tmp31_;
		_tmp32_ = cur_data;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			GError* _tmp34_;
			_tmp33_ = devpath;
			_tmp34_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed attribute or property line in description of device %s", _tmp33_);
			_inner_error_ = _tmp34_;
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp35_ = type;
		switch (_tmp35_) {
			case 'H':
			{
				gchar** _tmp36_;
				gint _tmp36__length1;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar** _tmp39_;
				gint _tmp39__length1;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp36_ = binattrs;
				_tmp36__length1 = binattrs_length1;
				_tmp37_ = key;
				_tmp38_ = g_strdup (_tmp37_);
				_vala_array_add3 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp38_);
				_tmp39_ = binattrs;
				_tmp39__length1 = binattrs_length1;
				_tmp40_ = val;
				_tmp41_ = g_strdup (_tmp40_);
				_vala_array_add4 (&binattrs, &binattrs_length1, &_binattrs_size_, _tmp41_);
				break;
			}
			case 'A':
			{
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp42_ = attrs;
				_tmp42__length1 = attrs_length1;
				_tmp43_ = key;
				_tmp44_ = g_strdup (_tmp43_);
				_vala_array_add5 (&attrs, &attrs_length1, &_attrs_size_, _tmp44_);
				_tmp45_ = val;
				_tmp46_ = g_strcompress (_tmp45_);
				_g_free0 (val);
				val = _tmp46_;
				_tmp47_ = attrs;
				_tmp47__length1 = attrs_length1;
				_tmp48_ = val;
				_tmp49_ = g_strdup (_tmp48_);
				_vala_array_add6 (&attrs, &attrs_length1, &_attrs_size_, _tmp49_);
				_tmp50_ = key;
				if (g_strcmp0 (_tmp50_, "dev") == 0) {
					const gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp51_ = val;
					_tmp52_ = g_strdup (_tmp51_);
					_g_free0 (majmin);
					majmin = _tmp52_;
				}
				break;
			}
			case 'L':
			{
				gchar** _tmp53_;
				gint _tmp53__length1;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar** _tmp56_;
				gint _tmp56__length1;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp53_ = linkattrs;
				_tmp53__length1 = linkattrs_length1;
				_tmp54_ = key;
				_tmp55_ = g_strdup (_tmp54_);
				_vala_array_add7 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp55_);
				_tmp56_ = linkattrs;
				_tmp56__length1 = linkattrs_length1;
				_tmp57_ = val;
				_tmp58_ = g_strdup (_tmp57_);
				_vala_array_add8 (&linkattrs, &linkattrs_length1, &_linkattrs_size_, _tmp58_);
				break;
			}
			case 'E':
			{
				gchar** _tmp59_;
				gint _tmp59__length1;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				gchar** _tmp62_;
				gint _tmp62__length1;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				const gchar* _tmp65_;
				_tmp59_ = props;
				_tmp59__length1 = props_length1;
				_tmp60_ = key;
				_tmp61_ = g_strdup (_tmp60_);
				_vala_array_add9 (&props, &props_length1, &_props_size_, _tmp61_);
				_tmp62_ = props;
				_tmp62__length1 = props_length1;
				_tmp63_ = val;
				_tmp64_ = g_strdup (_tmp63_);
				_vala_array_add10 (&props, &props_length1, &_props_size_, _tmp64_);
				_tmp65_ = key;
				if (g_strcmp0 (_tmp65_, "SUBSYSTEM") == 0) {
					const gchar* _tmp66_;
					const gchar* _tmp69_;
					gchar* _tmp70_;
					_tmp66_ = subsystem;
					if (_tmp66_ != NULL) {
						const gchar* _tmp67_;
						GError* _tmp68_;
						_tmp67_ = devpath;
						_tmp68_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "duplicate SUBSYSTEM property in description of device %s", _tmp67_);
						_inner_error_ = _tmp68_;
						if (_inner_error_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp69_ = val;
					_tmp70_ = g_strdup (_tmp69_);
					_g_free0 (subsystem);
					subsystem = _tmp70_;
				}
				break;
			}
			case 'P':
			{
				const gchar* _tmp71_;
				GError* _tmp72_;
				_tmp71_ = devpath;
				_tmp72_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "invalid P: line in description of device %s", _tmp71_);
				_inner_error_ = _tmp72_;
				if (_inner_error_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			case 'N':
			{
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				gchar* _tmp75_;
				const gchar* _tmp76_;
				_tmp73_ = self->priv->root_dir;
				_tmp74_ = key;
				_tmp75_ = g_build_filename (_tmp73_, "dev", _tmp74_, NULL);
				_g_free0 (devnode_path);
				devnode_path = _tmp75_;
				_tmp76_ = val;
				if (_tmp76_ != NULL) {
					guint8* _tmp77_ = NULL;
					const gchar* _tmp78_;
					gint _tmp79_;
					guint8* _tmp80_;
					gint _tmp77__length1;
					gint __tmp77__size_;
					guint8* _tmp81_;
					gint _tmp81__length1;
					_tmp78_ = val;
					_tmp80_ = umockdev_decode_hex (_tmp78_, &_tmp79_, &_inner_error_);
					_tmp77_ = _tmp80_;
					_tmp77__length1 = _tmp79_;
					__tmp77__size_ = _tmp77__length1;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == UMOCKDEV_ERROR) {
							g_propagate_error (error, _inner_error_);
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							return NULL;
						} else {
							props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
							linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
							binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
							attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
							devnode_contents = (g_free (devnode_contents), NULL);
							_g_free0 (devnode_path);
							_g_free0 (cur_data);
							_g_free0 (majmin);
							_g_free0 (subsystem);
							_g_free0 (devpath);
							_g_free0 (val);
							_g_free0 (key);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp81_ = _tmp77_;
					_tmp81__length1 = _tmp77__length1;
					_tmp77_ = NULL;
					_tmp77__length1 = 0;
					devnode_contents = (g_free (devnode_contents), NULL);
					devnode_contents = _tmp81_;
					devnode_contents_length1 = _tmp81__length1;
					_devnode_contents_size_ = devnode_contents_length1;
					_tmp77_ = (g_free (_tmp77_), NULL);
				}
				break;
			}
			case 'S':
			{
				break;
			}
			default:
			{
				gchar _tmp82_;
				GError* _tmp83_;
				_tmp82_ = type;
				_tmp83_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "Unknown line type '%c'\n", (gint) _tmp82_);
				_inner_error_ = _tmp83_;
				if (_inner_error_->domain == UMOCKDEV_ERROR) {
					g_propagate_error (error, _inner_error_);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					return NULL;
				} else {
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
					linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
					binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
					attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
					devnode_contents = (g_free (devnode_contents), NULL);
					_g_free0 (devnode_path);
					_g_free0 (cur_data);
					_g_free0 (majmin);
					_g_free0 (subsystem);
					_g_free0 (devpath);
					_g_free0 (val);
					_g_free0 (key);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp84_ = subsystem;
	if (_tmp84_ == NULL) {
		const gchar* _tmp85_;
		GError* _tmp86_;
		_tmp85_ = devpath;
		_tmp86_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_VALUE, "missing SUBSYSTEM property in description of device %s", _tmp85_);
		_inner_error_ = _tmp86_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			return NULL;
		} else {
			props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
			linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
			binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
			attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
			devnode_contents = (g_free (devnode_contents), NULL);
			_g_free0 (devnode_path);
			_g_free0 (cur_data);
			_g_free0 (majmin);
			_g_free0 (subsystem);
			_g_free0 (devpath);
			_g_free0 (val);
			_g_free0 (key);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp87_ = devpath;
	_tmp88_ = subsystem;
	g_debug ("umockdev.vala:1032: creating device %s (subsystem %s)", _tmp87_, _tmp88_);
	_tmp89_ = subsystem;
	_tmp90_ = devpath;
	_tmp91_ = string_substring (_tmp90_, (glong) 9, (glong) -1);
	_tmp92_ = _tmp91_;
	_tmp93_ = attrs;
	_tmp93__length1 = attrs_length1;
	_tmp94_ = props;
	_tmp94__length1 = props_length1;
	_tmp95_ = umockdev_testbed_add_devicev (self, _tmp89_, _tmp92_, NULL, _tmp93_, _tmp94_);
	_tmp96_ = _tmp95_;
	_g_free0 (_tmp92_);
	syspath = _tmp96_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp97_ = FALSE;
			_tmp97_ = TRUE;
			while (TRUE) {
				gint _tmp99_;
				gchar** _tmp100_;
				gint _tmp100__length1;
				guint8* _tmp101_ = NULL;
				gchar** _tmp102_;
				gint _tmp102__length1;
				gint _tmp103_;
				const gchar* _tmp104_;
				gint _tmp105_;
				guint8* _tmp106_;
				gint _tmp101__length1;
				gint __tmp101__size_;
				const gchar* _tmp107_;
				gchar** _tmp108_;
				gint _tmp108__length1;
				gint _tmp109_;
				const gchar* _tmp110_;
				if (!_tmp97_) {
					gint _tmp98_;
					_tmp98_ = i;
					i = _tmp98_ + 2;
				}
				_tmp97_ = FALSE;
				_tmp99_ = i;
				_tmp100_ = binattrs;
				_tmp100__length1 = binattrs_length1;
				if (!(_tmp99_ < _tmp100__length1)) {
					break;
				}
				_tmp102_ = binattrs;
				_tmp102__length1 = binattrs_length1;
				_tmp103_ = i;
				_tmp104_ = _tmp102_[_tmp103_ + 1];
				_tmp106_ = umockdev_decode_hex (_tmp104_, &_tmp105_, &_inner_error_);
				_tmp101_ = _tmp106_;
				_tmp101__length1 = _tmp105_;
				__tmp101__size_ = _tmp101__length1;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == UMOCKDEV_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						return NULL;
					} else {
						_g_free0 (syspath);
						props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
						linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
						binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
						attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
						devnode_contents = (g_free (devnode_contents), NULL);
						_g_free0 (devnode_path);
						_g_free0 (cur_data);
						_g_free0 (majmin);
						_g_free0 (subsystem);
						_g_free0 (devpath);
						_g_free0 (val);
						_g_free0 (key);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp107_ = syspath;
				_tmp108_ = binattrs;
				_tmp108__length1 = binattrs_length1;
				_tmp109_ = i;
				_tmp110_ = _tmp108_[_tmp109_];
				umockdev_testbed_set_attribute_binary (self, _tmp107_, _tmp110_, _tmp101_, _tmp101__length1);
				_tmp101_ = (g_free (_tmp101_), NULL);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp111_ = FALSE;
			_tmp111_ = TRUE;
			while (TRUE) {
				gint _tmp113_;
				gchar** _tmp114_;
				gint _tmp114__length1;
				const gchar* _tmp115_;
				gchar** _tmp116_;
				gint _tmp116__length1;
				gint _tmp117_;
				const gchar* _tmp118_;
				gchar** _tmp119_;
				gint _tmp119__length1;
				gint _tmp120_;
				const gchar* _tmp121_;
				if (!_tmp111_) {
					gint _tmp112_;
					_tmp112_ = i;
					i = _tmp112_ + 2;
				}
				_tmp111_ = FALSE;
				_tmp113_ = i;
				_tmp114_ = linkattrs;
				_tmp114__length1 = linkattrs_length1;
				if (!(_tmp113_ < _tmp114__length1)) {
					break;
				}
				_tmp115_ = syspath;
				_tmp116_ = linkattrs;
				_tmp116__length1 = linkattrs_length1;
				_tmp117_ = i;
				_tmp118_ = _tmp116_[_tmp117_];
				_tmp119_ = linkattrs;
				_tmp119__length1 = linkattrs_length1;
				_tmp120_ = i;
				_tmp121_ = _tmp119_[_tmp120_ + 1];
				umockdev_testbed_set_attribute_link (self, _tmp115_, _tmp118_, _tmp121_);
			}
		}
	}
	_tmp122_ = devnode_path;
	if (_tmp122_ != NULL) {
		const gchar* _tmp123_;
		const gchar* _tmp124_;
		guint8* _tmp125_;
		gint _tmp125__length1;
		const gchar* _tmp126_;
		_tmp123_ = subsystem;
		_tmp124_ = devnode_path;
		_tmp125_ = devnode_contents;
		_tmp125__length1 = devnode_contents_length1;
		_tmp126_ = majmin;
		umockdev_testbed_create_node_for_device (self, _tmp123_, _tmp124_, _tmp125_, _tmp125__length1, _tmp126_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				return NULL;
			} else {
				_g_free0 (syspath);
				props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
				linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
				binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
				attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
				devnode_contents = (g_free (devnode_contents), NULL);
				_g_free0 (devnode_path);
				_g_free0 (cur_data);
				_g_free0 (majmin);
				_g_free0 (subsystem);
				_g_free0 (devpath);
				_g_free0 (val);
				_g_free0 (key);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp127_ = FALSE;
		const gchar* _tmp128_;
		gchar _tmp129_;
		const gchar* _tmp132_;
		const gchar* _tmp133_;
		gchar* _tmp134_;
		_tmp128_ = cur_data;
		_tmp129_ = string_get (_tmp128_, (glong) 0);
		if (_tmp129_ != '\0') {
			const gchar* _tmp130_;
			gchar _tmp131_;
			_tmp130_ = cur_data;
			_tmp131_ = string_get (_tmp130_, (glong) 0);
			_tmp127_ = _tmp131_ == '\n';
		} else {
			_tmp127_ = FALSE;
		}
		if (!_tmp127_) {
			break;
		}
		_tmp132_ = cur_data;
		_tmp133_ = g_utf8_next_char (_tmp132_);
		_tmp134_ = g_strdup (_tmp133_);
		_g_free0 (cur_data);
		cur_data = _tmp134_;
	}
	result = cur_data;
	_g_free0 (syspath);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_free), NULL);
	linkattrs = (_vala_array_free (linkattrs, linkattrs_length1, (GDestroyNotify) g_free), NULL);
	binattrs = (_vala_array_free (binattrs, binattrs_length1, (GDestroyNotify) g_free), NULL);
	attrs = (_vala_array_free (attrs, attrs_length1, (GDestroyNotify) g_free), NULL);
	devnode_contents = (g_free (devnode_contents), NULL);
	_g_free0 (devnode_path);
	_g_free0 (majmin);
	_g_free0 (subsystem);
	_g_free0 (devpath);
	_g_free0 (val);
	_g_free0 (key);
	return result;
}


static void umockdev_testbed_create_node_for_device (UMockdevTestbed* self, const gchar* subsystem, const gchar* node_path, guint8* node_contents, int node_contents_length1, const gchar* majmin, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint ptym = 0;
	gint ptys = 0;
	gchar* ptyname_array = NULL;
	gchar* _tmp15_;
	gint ptyname_array_length1;
	gint _ptyname_array_size_;
	gchar* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_;
	gchar* ptyname = NULL;
	gchar* _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	struct termios ios = {0};
	gint _tmp25_;
	struct termios _tmp26_ = {0};
	gint _tmp27_;
	tcflag_t _tmp28_;
	tcflag_t _tmp29_;
	tcflag_t _tmp30_;
	gint _tmp31_;
	struct termios _tmp32_;
	gint _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gint _tmp36_;
	const gchar* _tmp37_;
	gchar* devname = NULL;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	gchar* _tmp55_;
	GHashTable* _tmp56_;
	const gchar* _tmp57_;
	gboolean _tmp58_;
	GHashTable* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gint _tmp62_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subsystem != NULL);
	g_return_if_fail (node_path != NULL);
	_tmp0_ = node_path;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_mkdir_with_parents (_tmp2_, 0755);
	_vala_assert (_tmp3_ == 0, "DirUtils.create_with_parents(Path.get_dirname(node_path), 0755) == 0");
	_g_free0 (_tmp2_);
	_tmp6_ = node_contents;
	_tmp6__length1 = node_contents_length1;
	if (_tmp6__length1 > 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = subsystem;
		_tmp5_ = g_strcmp0 (_tmp7_, "block") == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = subsystem;
		_tmp4_ = g_strcmp0 (_tmp8_, "usb") == 0;
	}
	if (_tmp4_) {
		{
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			guint8* _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			_tmp9_ = node_path;
			g_debug ("umockdev.vala:1065: create_node_for_device: creating file device %s", _tmp9_);
			_tmp10_ = node_path;
			_tmp11_ = node_contents;
			_tmp11__length1 = node_contents_length1;
			g_file_set_contents (_tmp10_, (const char*) _tmp11_, (size_t) _tmp11__length1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch9_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp12_ = subsystem;
			if (g_strcmp0 (_tmp12_, "block") == 0) {
				const gchar* _tmp13_;
				_tmp13_ = node_path;
				g_chmod (_tmp13_, 01644);
			}
		}
		goto __finally9;
		__catch9_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = e->message;
			g_error ("umockdev.vala:1072: Cannot create dev node file: %s", _tmp14_);
			_g_error_free0 (e);
		}
		__finally9:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == UMOCKDEV_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		return;
	}
	_tmp15_ = g_new0 (gchar, 8192);
	ptyname_array = _tmp15_;
	ptyname_array_length1 = 8192;
	_ptyname_array_size_ = ptyname_array_length1;
	_tmp16_ = ptyname_array;
	_tmp16__length1 = ptyname_array_length1;
	_tmp19_ = openpty (&_tmp17_, &_tmp18_, _tmp16_, NULL, NULL);
	ptym = _tmp17_;
	ptys = _tmp18_;
	_vala_assert (_tmp19_ == 0, "Linux.openpty (out ptym, out ptys, ptyname_array, null, null) == 0");
	_tmp20_ = ptyname_array;
	_tmp20__length1 = ptyname_array_length1;
	_tmp21_ = g_strdup ((const gchar*) _tmp20_);
	ptyname = _tmp21_;
	_tmp22_ = node_path;
	_tmp23_ = ptyname;
	g_debug ("umockdev.vala:1083: create_node_for_device: creating pty device %s: go" \
"t pty %s", _tmp22_, _tmp23_);
	_tmp24_ = ptys;
	close (_tmp24_);
	_tmp25_ = ptym;
	_tmp27_ = tcgetattr (_tmp25_, &_tmp26_);
	ios = _tmp26_;
	_vala_assert (_tmp27_ == 0, "Posix.tcgetattr (ptym, out ios) == 0");
	_tmp28_ = ios.c_iflag;
	ios.c_iflag = _tmp28_ & (~((IGNCR | INLCR) | ICRNL));
	_tmp29_ = ios.c_oflag;
	ios.c_oflag = _tmp29_ & (~(ONLCR | OCRNL));
	_tmp30_ = ios.c_lflag;
	ios.c_lflag = _tmp30_ & (~(ICANON | ECHO));
	cfmakeraw (&ios);
	_tmp31_ = ptym;
	_tmp32_ = ios;
	_tmp33_ = tcsetattr (_tmp31_, TCSANOW, &_tmp32_);
	_vala_assert (_tmp33_ == 0, "Posix.tcsetattr (ptym, Posix.TCSANOW, ios) == 0");
	_tmp34_ = ptyname;
	_tmp35_ = node_path;
	_tmp36_ = symlink (_tmp34_, _tmp35_);
	_vala_assert (_tmp36_ == 0, "FileUtils.symlink (ptyname, node_path) == 0");
	_tmp37_ = majmin;
	if (_tmp37_ != NULL) {
		gchar* mapdir = NULL;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* dest = NULL;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gint _tmp50_;
		_tmp38_ = self->priv->root_dir;
		_tmp39_ = g_build_filename (_tmp38_, "dev", ".ptymap", NULL);
		mapdir = _tmp39_;
		_tmp40_ = mapdir;
		g_mkdir_with_parents (_tmp40_, 0755);
		_tmp41_ = mapdir;
		_tmp42_ = ptyname;
		_tmp43_ = string_replace (_tmp42_, "/", "_");
		_tmp44_ = _tmp43_;
		_tmp45_ = g_build_filename (_tmp41_, _tmp44_, NULL);
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp44_);
		dest = _tmp46_;
		_tmp47_ = dest;
		g_debug ("umockdev.vala:1104: create_node_for_device: creating ptymap symlink %s", _tmp47_);
		_tmp48_ = majmin;
		_tmp49_ = dest;
		_tmp50_ = symlink (_tmp48_, _tmp49_);
		_vala_assert (_tmp50_ == 0, "FileUtils.symlink(majmin, dest) == 0");
		_g_free0 (dest);
		_g_free0 (mapdir);
	}
	_tmp51_ = node_path;
	_tmp52_ = self->priv->root_dir;
	_tmp53_ = strlen (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = string_substring (_tmp51_, (glong) _tmp54_, (glong) -1);
	devname = _tmp55_;
	_tmp56_ = self->priv->dev_fd;
	_tmp57_ = devname;
	_tmp58_ = g_hash_table_contains (_tmp56_, _tmp57_);
	_vala_assert (!_tmp58_, "!this.dev_fd.contains (devname)");
	_tmp59_ = self->priv->dev_fd;
	_tmp60_ = devname;
	_tmp61_ = g_strdup (_tmp60_);
	_tmp62_ = ptym;
	g_hash_table_insert (_tmp59_, _tmp61_, (gpointer) ((gintptr) _tmp62_));
	_g_free0 (devname);
	_g_free0 (ptyname);
	ptyname_array = (g_free (ptyname_array), NULL);
}


/**
     * umockdev_testbed_record_parse_line:
     * @data: String to parse
     * @type: Pointer to a gchar which will get the line type (one of P, N,
     *        S, E, or H)
     * @key:  Pointer to a string which will get the key name; this will be
     *        set to %NULL for line types which do not have a key (P, N, S). You
     *        need to free this with g_free().
     * @value: Pointer to a string which will get the value. You need to
     *         free this with g_free().
     *
     * Parse one line from a device record file.
     *
     * Returns: Pointer to the next line start in @data, or %NULL if the first line
     * is not valid.
     */
static gchar* umockdev_testbed_record_parse_line (UMockdevTestbed* self, const gchar* data, gchar* type, gchar* * key, gchar* * val) {
	gchar _vala_type = '\0';
	gchar* _vala_key = NULL;
	gchar* _vala_val = NULL;
	gchar* result = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp0_;
	const gchar* _tmp1_;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar _tmp28_;
	gint end_pos = 0;
	GMatchInfo* _tmp29_;
	gint _tmp30_ = 0;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	gint _tmp33_;
	gchar* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->priv->re_record_val;
	_tmp1_ = data;
	_tmp3_ = g_regex_match (_tmp0_, _tmp1_, 0, &_tmp2_);
	_g_match_info_unref0 (match);
	match = _tmp2_;
	if (_tmp3_) {
		GMatchInfo* _tmp4_;
		gchar* _tmp5_;
		_g_free0 (_vala_key);
		_vala_key = NULL;
		_tmp4_ = match;
		_tmp5_ = g_match_info_fetch (_tmp4_, 2);
		_g_free0 (_vala_val);
		_vala_val = _tmp5_;
	} else {
		GRegex* _tmp6_;
		const gchar* _tmp7_;
		GMatchInfo* _tmp8_ = NULL;
		gboolean _tmp9_;
		_tmp6_ = self->priv->re_record_keyval;
		_tmp7_ = data;
		_tmp9_ = g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
		_g_match_info_unref0 (match);
		match = _tmp8_;
		if (_tmp9_) {
			GMatchInfo* _tmp10_;
			gchar* _tmp11_;
			GMatchInfo* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp10_ = match;
			_tmp11_ = g_match_info_fetch (_tmp10_, 2);
			_g_free0 (_vala_key);
			_vala_key = _tmp11_;
			_tmp12_ = match;
			_tmp13_ = g_match_info_fetch (_tmp12_, 3);
			_g_free0 (_vala_val);
			_vala_val = _tmp13_;
			_tmp14_ = _vala_val;
			_vala_assert (_tmp14_ != NULL, "val != null");
		} else {
			GRegex* _tmp15_;
			const gchar* _tmp16_;
			GMatchInfo* _tmp17_ = NULL;
			gboolean _tmp18_;
			_tmp15_ = self->priv->re_record_optval;
			_tmp16_ = data;
			_tmp18_ = g_regex_match (_tmp15_, _tmp16_, 0, &_tmp17_);
			_g_match_info_unref0 (match);
			match = _tmp17_;
			if (_tmp18_) {
				GMatchInfo* _tmp19_;
				gchar* _tmp20_;
				GMatchInfo* _tmp21_;
				gchar* _tmp22_;
				_tmp19_ = match;
				_tmp20_ = g_match_info_fetch (_tmp19_, 2);
				_g_free0 (_vala_key);
				_vala_key = _tmp20_;
				_tmp21_ = match;
				_tmp22_ = g_match_info_fetch (_tmp21_, 3);
				_g_free0 (_vala_val);
				_vala_val = _tmp22_;
			} else {
				const gchar* _tmp23_;
				_tmp23_ = data;
				g_debug ("umockdev.vala:1146: record_parse_line: >%s< does not match anything, f" \
"ailing", _tmp23_);
				_vala_type = '\0';
				_g_free0 (_vala_key);
				_vala_key = NULL;
				_g_free0 (_vala_val);
				_vala_val = NULL;
				result = NULL;
				_g_match_info_unref0 (match);
				if (type) {
					*type = _vala_type;
				}
				if (key) {
					*key = _vala_key;
				} else {
					_g_free0 (_vala_key);
				}
				if (val) {
					*val = _vala_val;
				} else {
					_g_free0 (_vala_val);
				}
				return result;
			}
		}
	}
	_tmp24_ = match;
	_tmp25_ = g_match_info_fetch (_tmp24_, 1);
	type_str = _tmp25_;
	_tmp26_ = type_str;
	_vala_assert (_tmp26_ != NULL, "type_str != null");
	_tmp27_ = type_str;
	_tmp28_ = string_get (_tmp27_, (glong) 0);
	_vala_type = _tmp28_;
	_tmp29_ = match;
	_tmp31_ = g_match_info_fetch_pos (_tmp29_, 0, NULL, &_tmp30_);
	end_pos = _tmp30_;
	_vala_assert (_tmp31_, "match.fetch_pos(0, null, out end_pos)");
	_tmp32_ = data;
	_tmp33_ = end_pos;
	_tmp34_ = string_substring (_tmp32_, (glong) _tmp33_, (glong) -1);
	result = _tmp34_;
	_g_free0 (type_str);
	_g_match_info_unref0 (match);
	if (type) {
		*type = _vala_type;
	}
	if (key) {
		*key = _vala_key;
	} else {
		_g_free0 (_vala_key);
	}
	if (val) {
		*val = _vala_val;
	} else {
		_g_free0 (_vala_val);
	}
	return result;
}


/**
     * umockdev_testbed_disable:
     * @self: A #UMockdevTestbed.
     *
     * Disable the testbed.  This can be used for temporarily switching back to
     * the real /sys and /dev without having to destroy or change $UMOCKDEV_DIR
     * and the #UMockdevTestbed instance. Use @umockdev_testbed_enable() to
     * re-enable the testbed.
     */
void umockdev_testbed_disable (UMockdevTestbed* self) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "w");
	_tmp4_ = _tmp3_;
	_fclose0 (_tmp4_);
	_g_free0 (_tmp2_);
}


/**
     * umockdev_testbed_enable:
     * @self: A #UMockdevTestbed.
     *
     * Re-enable the testbed after @@umockdev_testbed_disable().
     */
void umockdev_testbed_enable (UMockdevTestbed* self) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	_tmp1_ = g_build_filename (_tmp0_, "disabled", NULL);
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}


/**
     * umockdev_testbed_clear:
     * @self: A #UMockdevTestbed.
     *
     * Remove all added devices from testbed directory.  After that, the
     * umockdev root directory will be in the same state as directly after the
     * constructor.
     */
void umockdev_testbed_clear (UMockdevTestbed* self) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp0_, FALSE);
	_tmp1_ = self->priv->sys_dir;
	g_mkdir (_tmp1_, 0755);
}


/**
     * umockdev_testbed_get_dev_fd:
     * @self: A #UMockdevTestbed.
     * @devnode: Device node name ("/dev/...")
     *
     * Simulated devices without a pre-defined contents are backed by a
     * stream-like device node (PTY). Return the file descriptor
     * for accessing their "master" side, i. e. the end that gets
     * controlled by test suites. The tested program opens the "slave" side,
     * which is just openening the device specified by @devnode, e. g.
     * /dev/ttyUSB2. Once that happened, your test can directly communicate
     * with the tested program over that descriptor.
     *
     * Returns: File descriptor for communicating with clients that connect to
     *           @devnode, or -1 if @devnode does not exist or is not a
     *           simulated stream device. This must not be closed!
     */
gint umockdev_testbed_get_dev_fd (UMockdevTestbed* self, const gchar* devnode) {
	gint result = 0;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (devnode != NULL, 0);
	_tmp0_ = self->priv->dev_fd;
	_tmp1_ = devnode;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GHashTable* _tmp3_;
		const gchar* _tmp4_;
		gconstpointer _tmp5_;
		_tmp3_ = self->priv->dev_fd;
		_tmp4_ = devnode;
		_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
		result = (gint) ((gintptr) _tmp5_);
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void umockdev_testbed_class_init (UMockdevTestbedClass * klass) {
	umockdev_testbed_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UMockdevTestbedPrivate));
	G_OBJECT_CLASS (klass)->finalize = umockdev_testbed_finalize;
}


static void umockdev_testbed_instance_init (UMockdevTestbed * self) {
	self->priv = UMOCKDEV_TESTBED_GET_PRIVATE (self);
	self->priv->ev_sender = NULL;
	self->priv->socket_server = NULL;
}


static void umockdev_testbed_finalize (GObject * obj) {
	UMockdevTestbed * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GList* _tmp5_;
	UMockdevSocketServer* _tmp8_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_TESTBED, UMockdevTestbed);
	_tmp0_ = self->priv->dev_script_runner;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp1_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp2_;
				_tmp2_ = r;
				umockdev_script_runner_stop (_tmp2_);
			}
		}
		_g_list_free0 (r_collection);
	}
	_tmp3_ = self->priv->dev_script_runner;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->dev_fd;
	_tmp5_ = g_hash_table_get_values (_tmp4_);
	{
		GList* fd_collection = NULL;
		GList* fd_it = NULL;
		fd_collection = _tmp5_;
		for (fd_it = fd_collection; fd_it != NULL; fd_it = fd_it->next) {
			gint fd = 0;
			fd = (gint) ((gintptr) fd_it->data);
			{
				gint _tmp6_;
				gint _tmp7_;
				_tmp6_ = fd;
				g_debug ("umockdev.vala:90: closing master pty fd %i for emulated device", _tmp6_);
				_tmp7_ = fd;
				close (_tmp7_);
			}
		}
		_g_list_free0 (fd_collection);
	}
	_tmp8_ = self->priv->socket_server;
	if (_tmp8_ != NULL) {
		UMockdevSocketServer* _tmp9_;
		g_debug ("umockdev.vala:95: shutting down socket server thread");
		_tmp9_ = self->priv->socket_server;
		umockdev_socket_server_stop (_tmp9_);
		_umockdev_socket_server_unref0 (self->priv->socket_server);
		self->priv->socket_server = NULL;
	}
	_tmp10_ = self->priv->root_dir;
	g_debug ("umockdev.vala:100: Removing test bed %s", _tmp10_);
	_tmp11_ = self->priv->root_dir;
	umockdev_remove_dir (_tmp11_, TRUE);
	g_unsetenv ("UMOCKDEV_DIR");
	_g_free0 (self->priv->root_dir);
	_g_free0 (self->priv->sys_dir);
	_g_regex_unref0 (self->priv->re_record_val);
	_g_regex_unref0 (self->priv->re_record_keyval);
	_g_regex_unref0 (self->priv->re_record_optval);
	_uevent_sender_close0 (self->priv->ev_sender);
	_g_hash_table_unref0 (self->priv->dev_fd);
	_g_hash_table_unref0 (self->priv->dev_script_runner);
	_umockdev_socket_server_unref0 (self->priv->socket_server);
	G_OBJECT_CLASS (umockdev_testbed_parent_class)->finalize (obj);
}


/**
 * UMockdevTestbed:
 *
 * The #UMockdevTestbed class builds a temporary sandbox for mock devices.
 * You can add a number of devices including arbitrary sysfs attributes and
 * udev properties, and then run your software in that test bed that is
 * independent of the actual hardware it is running on.  With this you can
 * simulate particular hardware in virtual environments up to some degree,
 * without needing any particular privileges or disturbing the whole system.
 *
 * You can either add devices by specifying individual device paths,
 * properties, and attributes, or use the umockdev-record tool to create a human
 * readable/editable record of a real device (and all its parents) and load
 * that into the testbed with umockdev_testbed_add_from_string().
 *
 * Instantiating a #UMockdevTestbed object creates a temporary directory with
 * an empty sysfs tree and sets the $UMOCKDEV_DIR environment variable so that
 * programs subsequently started under umockdev-wrapper will use the test bed
 * instead of the system's real sysfs.
 */
GType umockdev_testbed_get_type (void) {
	static volatile gsize umockdev_testbed_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_testbed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevTestbedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_testbed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevTestbed), 0, (GInstanceInitFunc) umockdev_testbed_instance_init, NULL };
		GType umockdev_testbed_type_id;
		umockdev_testbed_type_id = g_type_register_static (G_TYPE_OBJECT, "UMockdevTestbed", &g_define_type_info, 0);
		g_once_init_leave (&umockdev_testbed_type_id__volatile, umockdev_testbed_type_id);
	}
	return umockdev_testbed_type_id__volatile;
}


void umockdev_remove_dir (const gchar* path, gboolean remove_toplevel) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp1_ = path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_IS_DIR);
	if (_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = path;
		_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_IS_SYMLINK);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GDir* d = NULL;
		gchar* name = NULL;
		{
			GDir* _tmp5_ = NULL;
			const gchar* _tmp6_;
			GDir* _tmp7_;
			GDir* _tmp8_;
			_tmp6_ = path;
			_tmp7_ = g_dir_open (_tmp6_, (guint) 0, &_inner_error_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch10_g_file_error;
				}
				_g_dir_close0 (d);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_dir_close0 (d);
			d = _tmp8_;
			_g_dir_close0 (_tmp5_);
		}
		goto __finally10;
		__catch10_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = path;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("umockdev.vala:1251: cannot open: %s: %s", _tmp9_, _tmp11_);
			_g_error_free0 (e);
			_g_dir_close0 (d);
			return;
		}
		__finally10:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_dir_close0 (d);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			GDir* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp12_ = d;
			_tmp13_ = g_dir_read_name (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (name);
			name = _tmp14_;
			_tmp15_ = name;
			if (!(_tmp15_ != NULL)) {
				break;
			}
			_tmp16_ = path;
			_tmp17_ = name;
			_tmp18_ = g_build_filename (_tmp16_, _tmp17_, NULL);
			_tmp19_ = _tmp18_;
			umockdev_remove_dir (_tmp19_, TRUE);
			_g_free0 (_tmp19_);
		}
		_g_free0 (name);
		_g_dir_close0 (d);
	}
	_tmp20_ = remove_toplevel;
	if (_tmp20_) {
		const gchar* _tmp21_;
		gint _tmp22_;
		_tmp21_ = path;
		_tmp22_ = g_remove (_tmp21_);
		if (_tmp22_ < 0) {
			const gchar* _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_;
			_tmp23_ = path;
			_tmp24_ = errno;
			_tmp25_ = g_strerror (_tmp24_);
			g_warning ("umockdev.vala:1262: cannot remove %s: %s", _tmp23_, _tmp25_);
		}
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* umockdev_make_dotdots (const gchar* path) {
	gchar* result = NULL;
	gint offset = 0;
	guint count = 0U;
	gchar* dots = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (path != NULL, NULL);
	offset = 0;
	count = (guint) 0;
	while (TRUE) {
		const gchar* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		guint _tmp4_;
		gint _tmp5_;
		_tmp0_ = path;
		_tmp1_ = offset;
		_tmp2_ = string_index_of_char (_tmp0_, (gunichar) '/', _tmp1_);
		offset = _tmp2_;
		_tmp3_ = offset;
		if (!(_tmp3_ >= 0)) {
			break;
		}
		_tmp4_ = count;
		count = _tmp4_ + 1;
		_tmp5_ = offset;
		offset = _tmp5_ + 1;
	}
	_tmp6_ = g_strdup ("");
	dots = _tmp6_;
	while (TRUE) {
		guint _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		guint _tmp10_;
		_tmp7_ = count;
		if (!(_tmp7_ > ((guint) 1))) {
			break;
		}
		_tmp8_ = dots;
		_tmp9_ = g_strconcat (_tmp8_, "../", NULL);
		_g_free0 (dots);
		dots = _tmp9_;
		_tmp10_ = count;
		count = _tmp10_ - 1;
	}
	result = dots;
	return result;
}


guint8 umockdev_hexdigit (gchar c) {
	guint8 result = 0U;
	gint _tmp0_ = 0;
	gchar _tmp1_;
	_tmp1_ = c;
	if (_tmp1_ >= 'a') {
		gchar _tmp2_;
		_tmp2_ = c;
		_tmp0_ = (_tmp2_ - 'a') + 10;
	} else {
		gint _tmp3_ = 0;
		gchar _tmp4_;
		_tmp4_ = c;
		if (_tmp4_ >= 'A') {
			gchar _tmp5_;
			_tmp5_ = c;
			_tmp3_ = (_tmp5_ - 'A') + 10;
		} else {
			gchar _tmp6_;
			_tmp6_ = c;
			_tmp3_ = (gint) (_tmp6_ - '0');
		}
		_tmp0_ = _tmp3_;
	}
	result = (guint8) _tmp0_;
	return result;
}


guint8* umockdev_decode_hex (const gchar* data, int* result_length1, GError** error) {
	guint8* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint len = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guint8* bin = NULL;
	gint _tmp8_;
	guint8* _tmp9_;
	gint bin_length1;
	gint _bin_size_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if ((_tmp2_ % 2) != 0) {
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp3_ = data;
		_tmp4_ = g_error_new (UMOCKDEV_ERROR, UMOCKDEV_ERROR_PARSE, "malformed hexadecimal value: %s", _tmp3_);
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == UMOCKDEV_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = data;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	len = _tmp7_;
	_tmp8_ = len;
	_tmp9_ = g_new0 (guint8, _tmp8_ / 2);
	bin = _tmp9_;
	bin_length1 = _tmp8_ / 2;
	_bin_size_ = bin_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				guint _tmp12_;
				guint8* _tmp13_;
				gint _tmp13__length1;
				guint8* _tmp14_;
				gint _tmp14__length1;
				guint _tmp15_;
				const gchar* _tmp16_;
				guint _tmp17_;
				gchar _tmp18_;
				guint8 _tmp19_;
				const gchar* _tmp20_;
				guint _tmp21_;
				gchar _tmp22_;
				guint8 _tmp23_;
				guint8 _tmp24_;
				if (!_tmp10_) {
					guint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = bin;
				_tmp13__length1 = bin_length1;
				if (!(_tmp12_ < ((guint) _tmp13__length1))) {
					break;
				}
				_tmp14_ = bin;
				_tmp14__length1 = bin_length1;
				_tmp15_ = i;
				_tmp16_ = data;
				_tmp17_ = i;
				_tmp18_ = string_get (_tmp16_, (glong) (_tmp17_ * 2));
				_tmp19_ = umockdev_hexdigit (_tmp18_);
				_tmp20_ = data;
				_tmp21_ = i;
				_tmp22_ = string_get (_tmp20_, (glong) ((_tmp21_ * 2) + 1));
				_tmp23_ = umockdev_hexdigit (_tmp22_);
				_tmp14_[_tmp15_] = (guint8) ((_tmp19_ << 4) | _tmp23_);
				_tmp24_ = _tmp14_[_tmp15_];
			}
		}
	}
	_tmp25_ = bin;
	_tmp25__length1 = bin_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	return result;
}


gchar* umockdev_find_devnode (const gchar* devpath) {
	gchar* result = NULL;
	gchar* devname = NULL;
	GFile* f = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (devpath != NULL, NULL);
	devname = NULL;
	_tmp0_ = devpath;
	_tmp1_ = g_build_filename (_tmp0_, "uevent", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	f = _tmp4_;
	{
		GFileInputStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileInputStream* _tmp7_;
		GDataInputStream* inp = NULL;
		GDataInputStream* _tmp8_;
		gchar* line = NULL;
		gsize len = 0UL;
		GDataInputStream* _tmp23_;
		_tmp6_ = f;
		_tmp7_ = g_file_read (_tmp6_, NULL, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
		inp = _tmp8_;
		while (TRUE) {
			gchar* _tmp9_ = NULL;
			GDataInputStream* _tmp10_;
			gsize _tmp11_ = 0UL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gboolean _tmp16_;
			_tmp10_ = inp;
			_tmp12_ = g_data_input_stream_read_line (_tmp10_, &_tmp11_, NULL, &_inner_error_);
			len = _tmp11_;
			_tmp9_ = _tmp12_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (inp);
				_g_object_unref0 (_tmp5_);
				goto __catch11_g_error;
			}
			_tmp13_ = _tmp9_;
			_tmp9_ = NULL;
			_g_free0 (line);
			line = _tmp13_;
			_tmp14_ = line;
			if (!(_tmp14_ != NULL)) {
				_g_free0 (_tmp9_);
				break;
			}
			_tmp15_ = line;
			_tmp16_ = g_str_has_prefix (_tmp15_, "DEVNAME=");
			if (_tmp16_) {
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				gboolean _tmp20_;
				_tmp17_ = line;
				_tmp18_ = string_substring (_tmp17_, (glong) 8, (glong) -1);
				_g_free0 (devname);
				devname = _tmp18_;
				_tmp19_ = devname;
				_tmp20_ = g_str_has_prefix (_tmp19_, "/dev/");
				if (!_tmp20_) {
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp21_ = devname;
					_tmp22_ = g_strconcat ("/dev/", _tmp21_, NULL);
					_g_free0 (devname);
					devname = _tmp22_;
				}
				_g_free0 (_tmp9_);
				break;
			}
			_g_free0 (_tmp9_);
		}
		_tmp23_ = inp;
		g_input_stream_close ((GInputStream*) _tmp23_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (line);
			_g_object_unref0 (inp);
			_g_object_unref0 (_tmp5_);
			goto __catch11_g_error;
		}
		_g_free0 (line);
		_g_object_unref0 (inp);
		_g_object_unref0 (_tmp5_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("umockdev.vala:1330: Cannot read uevent file: %s\n", _tmp25_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (f);
		_g_free0 (devname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = devname;
	_g_object_unref0 (f);
	return result;
}


static gpointer _umockdev_script_runner_run_gthread_func (gpointer self) {
	gpointer result;
	result = umockdev_script_runner_run ((UMockdevScriptRunner*) self);
	umockdev_script_runner_unref (self);
	return result;
}


UMockdevScriptRunner* umockdev_script_runner_construct (GType object_type, const gchar* device, const gchar* script_file, gint fd, GError** error) {
	UMockdevScriptRunner* self = NULL;
	const gchar* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	GThread* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (script_file != NULL, NULL);
	self = (UMockdevScriptRunner*) g_type_create_instance (object_type);
	_tmp0_ = script_file;
	_tmp1_ = g_fopen (_tmp0_, "r");
	_fclose0 (self->priv->script);
	self->priv->script = _tmp1_;
	_tmp2_ = self->priv->script;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp3_ = script_file;
		_tmp4_ = g_strconcat ("Cannot open script record file ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == G_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_umockdev_script_runner_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = device;
	umockdev_script_runner_set_device (self, _tmp8_);
	_tmp9_ = script_file;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->script_file);
	self->priv->script_file = _tmp10_;
	_tmp11_ = fd;
	self->priv->fd = _tmp11_;
	self->priv->running = TRUE;
	_tmp12_ = device;
	_tmp13_ = g_thread_new (_tmp12_, _umockdev_script_runner_run_gthread_func, umockdev_script_runner_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp13_;
	return self;
}


UMockdevScriptRunner* umockdev_script_runner_new (const gchar* device, const gchar* script_file, gint fd, GError** error) {
	return umockdev_script_runner_construct (UMOCKDEV_TYPE_SCRIPT_RUNNER, device, script_file, fd, error);
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


void umockdev_script_runner_stop (UMockdevScriptRunner* self) {
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GThread* _tmp2_;
	GThread* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_device;
	g_debug ("umockdev.vala:1361: Stopping script runner for %s: joining thread", _tmp1_);
	self->priv->running = FALSE;
	_tmp2_ = self->priv->thread;
	_tmp3_ = _g_thread_ref0 (_tmp2_);
	g_thread_join (_tmp3_);
}


static void* umockdev_script_runner_run (UMockdevScriptRunner* self) {
	void* result = NULL;
	gchar op = '\0';
	guint32 delta = 0U;
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_;
	const gchar* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	g_debug ("umockdev.vala:1372: ScriptRunner[%s]: start", _tmp0_);
	while (TRUE) {
		gboolean _tmp1_;
		gchar _tmp2_ = '\0';
		guint32 _tmp3_ = 0U;
		gint _tmp4_;
		guint8* _tmp5_;
		gchar _tmp6_;
		_tmp1_ = self->priv->running;
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = umockdev_script_runner_next_line (self, &_tmp2_, &_tmp3_, &_tmp4_);
		op = _tmp2_;
		delta = _tmp3_;
		data = (g_free (data), NULL);
		data = _tmp5_;
		data_length1 = _tmp4_;
		_data_size_ = data_length1;
		_tmp6_ = op;
		switch (_tmp6_) {
			case 'r':
			{
				const gchar* _tmp7_;
				guint32 _tmp8_;
				guint32 _tmp9_;
				const gchar* _tmp10_;
				guint8* _tmp11_;
				gint _tmp11__length1;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gssize l = 0L;
				gint _tmp14_;
				guint8* _tmp15_;
				gint _tmp15__length1;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gssize _tmp17_;
				gssize _tmp18_;
				gssize _tmp22_;
				guint8* _tmp23_;
				gint _tmp23__length1;
				_tmp7_ = self->priv->_device;
				_tmp8_ = delta;
				g_debug ("ScriptRunner[%s]: read op; sleeping %" G_GUINT32_FORMAT " ms", _tmp7_, _tmp8_);
				_tmp9_ = delta;
				g_usleep ((gulong) (_tmp9_ * 1000));
				_tmp10_ = self->priv->_device;
				_tmp11_ = data;
				_tmp11__length1 = data_length1;
				_tmp12_ = umockdev_script_runner_encode (_tmp11_, _tmp11__length1);
				_tmp13_ = _tmp12_;
				g_debug ("umockdev.vala:1382: ScriptRunner[%s]: read op after sleep; writing dat" \
"a '%s'", _tmp10_, _tmp13_);
				_g_free0 (_tmp13_);
				_tmp14_ = self->priv->fd;
				_tmp15_ = data;
				_tmp15__length1 = data_length1;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				_tmp17_ = write (_tmp14_, _tmp15_, (gsize) _tmp16__length1);
				l = _tmp17_;
				_tmp18_ = l;
				if (_tmp18_ < ((gssize) 0)) {
					const gchar* _tmp19_;
					gint _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = self->priv->_device;
					_tmp20_ = errno;
					_tmp21_ = g_strerror (_tmp20_);
					g_error ("umockdev.vala:1385: ScriptRunner[%s]: write failed: %s", _tmp19_, _tmp21_);
				}
				_tmp22_ = l;
				_tmp23_ = data;
				_tmp23__length1 = data_length1;
				_vala_assert (_tmp22_ == ((gssize) _tmp23__length1), "l == data.length");
				break;
			}
			case 'w':
			{
				const gchar* _tmp24_;
				guint8* _tmp25_;
				gint _tmp25__length1;
				gchar* _tmp26_;
				gchar* _tmp27_;
				guint8* _tmp28_;
				gint _tmp28__length1;
				guint32 _tmp29_;
				_tmp24_ = self->priv->_device;
				_tmp25_ = data;
				_tmp25__length1 = data_length1;
				_tmp26_ = umockdev_script_runner_encode (_tmp25_, _tmp25__length1);
				_tmp27_ = _tmp26_;
				g_debug ("umockdev.vala:1390: ScriptRunner[%s]: write op, data '%s'", _tmp24_, _tmp27_);
				_g_free0 (_tmp27_);
				_tmp28_ = data;
				_tmp28__length1 = data_length1;
				_tmp29_ = delta;
				umockdev_script_runner_op_write (self, _tmp28_, _tmp28__length1, _tmp29_);
				break;
			}
			case 'Q':
			{
				self->priv->running = FALSE;
				break;
			}
			case 'f':
			{
				guint32 _tmp30_;
				guint32 _tmp33_;
				const gchar* _tmp34_;
				guint _tmp35_;
				_tmp30_ = delta;
				if (_tmp30_ > ((guint32) 100)) {
					const gchar* _tmp31_;
					guint32 _tmp32_;
					_tmp31_ = self->priv->_device;
					_tmp32_ = delta;
					g_error ("umockdev.vala:1400: ScriptRunner[%s]: fuzz value %u is invalid (must b" \
"e between 0 and 100)", _tmp31_, (guint) _tmp32_);
				}
				_tmp33_ = delta;
				self->priv->fuzz = (guint) _tmp33_;
				_tmp34_ = self->priv->_device;
				_tmp35_ = self->priv->fuzz;
				g_debug ("umockdev.vala:1403: ScriptRunner[%s]: setting fuzz level to %u%%", _tmp34_, _tmp35_);
				break;
			}
			case 'd':
			{
				break;
			}
			default:
			{
				const gchar* _tmp36_;
				gchar _tmp37_;
				_tmp36_ = self->priv->_device;
				_tmp37_ = op;
				g_debug ("umockdev.vala:1411: ScriptRunner[%s]: got unknown line op %c, ignoring", _tmp36_, (gint) _tmp37_);
				break;
			}
		}
	}
	_tmp38_ = self->priv->_device;
	g_debug ("umockdev.vala:1416: ScriptRunner[%s]: not running any more, ending thr" \
"ead", _tmp38_);
	result = NULL;
	data = (g_free (data), NULL);
	return result;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static guint8* umockdev_script_runner_next_line (UMockdevScriptRunner* self, gchar* op, guint32* delta, int* result_length1) {
	gchar _vala_op = '\0';
	guint32 _vala_delta = 0U;
	guint8* result = NULL;
	gint c = 0;
	glong cur_pos = 0L;
	FILE* _tmp14_;
	glong _tmp15_;
	FILE* _tmp16_;
	gint _tmp17_;
	FILE* _tmp20_;
	glong _tmp21_;
	FILE* _tmp22_;
	gint _tmp23_;
	gchar* line = NULL;
	FILE* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	guint8* _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			FILE* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = self->priv->script;
			_tmp2_ = fgetc (_tmp1_);
			c = _tmp2_;
			_tmp3_ = c;
			if (_tmp3_ == EOF) {
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				guint8* _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				_tmp4_ = self->priv->_device;
				_tmp5_ = self->priv->script_file;
				g_debug ("umockdev.vala:1427: ScriptRunner[%s]: end of script %s, closing", _tmp4_, _tmp5_);
				_vala_op = 'Q';
				_vala_delta = (guint32) 0;
				_tmp6_ = g_new0 (guint8, 0);
				_tmp7_ = _tmp6_;
				_tmp7__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp7__length1;
				}
				result = _tmp7_;
				if (op) {
					*op = _vala_op;
				}
				if (delta) {
					*delta = _vala_delta;
				}
				return result;
			} else {
				gint _tmp8_;
				_tmp8_ = c;
				if (_tmp8_ == ((gint) '#')) {
					FILE* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = self->priv->script;
					_tmp10_ = g_file_stream_read_line (_tmp9_);
					_tmp11_ = _tmp10_;
					_vala_assert (_tmp11_ != NULL, "this.script.read_line () != null");
					_g_free0 (_tmp11_);
				} else {
					gint _tmp12_;
					_tmp12_ = c;
					if (_tmp12_ != ((gint) '\n')) {
						gint _tmp13_;
						_tmp13_ = c;
						_vala_op = (gchar) _tmp13_;
						break;
					}
				}
			}
		}
	}
	_tmp14_ = self->priv->script;
	_tmp15_ = ftell (_tmp14_);
	cur_pos = _tmp15_;
	_tmp16_ = self->priv->script;
	_tmp17_ = fgetc (_tmp16_);
	if (_tmp17_ != ((gint) ' ')) {
		const gchar* _tmp18_;
		glong _tmp19_;
		_tmp18_ = self->priv->script_file;
		_tmp19_ = cur_pos;
		g_error ("umockdev.vala:1441: Missing space after operation code in %s at positi" \
"on %li", _tmp18_, _tmp19_);
	}
	_tmp20_ = self->priv->script;
	_tmp21_ = ftell (_tmp20_);
	cur_pos = _tmp21_;
	_tmp22_ = self->priv->script;
	_tmp23_ = fscanf (_tmp22_, "%" G_GUINT32_FORMAT " ", &_vala_delta);
	if (_tmp23_ != 1) {
		const gchar* _tmp24_;
		glong _tmp25_;
		_tmp24_ = self->priv->script_file;
		_tmp25_ = cur_pos;
		g_error ("umockdev.vala:1446: Cannot parse time in %s at position %li", _tmp24_, _tmp25_);
	}
	_tmp26_ = self->priv->script;
	_tmp27_ = g_file_stream_read_line (_tmp26_);
	line = _tmp27_;
	_tmp28_ = line;
	_vala_assert (_tmp28_ != NULL, "line != null");
	_tmp29_ = line;
	_tmp31_ = umockdev_script_runner_decode (_tmp29_, &_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _tmp30_;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	_g_free0 (line);
	if (op) {
		*op = _vala_op;
	}
	if (delta) {
		*delta = _vala_delta;
	}
	return result;
}


static void umockdev_script_runner_op_write (UMockdevScriptRunner* self, guint8* data, int data_length1, guint32 delta) {
	fd_set fds = {0};
	struct timeval timeout = {0};
	struct timeval _tmp0_ = {0};
	gsize offset = 0UL;
	guint8* buf = NULL;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint buf_length1;
	gint _buf_size_;
	g_return_if_fail (self != NULL);
	_tmp0_.tv_sec = (time_t) 0;
	_tmp0_.tv_usec = (glong) 200000;
	timeout = _tmp0_;
	offset = (gsize) 0;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = g_new0 (guint8, _tmp1__length1);
	buf = _tmp2_;
	buf_length1 = _tmp1__length1;
	_buf_size_ = buf_length1;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		fd_set _tmp7_ = {0};
		gint _tmp8_;
		gint res = 0;
		gint _tmp9_;
		struct timeval _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp17_;
		gssize len = 0L;
		gint _tmp24_;
		guint8* _tmp25_;
		gint _tmp25__length1;
		guint8* _tmp26_;
		gint _tmp26__length1;
		gsize _tmp27_;
		gssize _tmp28_;
		gssize _tmp29_;
		guint _tmp37_;
		gsize _tmp78_;
		gssize _tmp79_;
		const gchar* _tmp80_;
		gssize _tmp81_;
		gsize _tmp82_;
		guint8* _tmp83_;
		gint _tmp83__length1;
		_tmp4_ = self->priv->running;
		if (_tmp4_) {
			gsize _tmp5_;
			guint8* _tmp6_;
			gint _tmp6__length1;
			_tmp5_ = offset;
			_tmp6_ = data;
			_tmp6__length1 = data_length1;
			_tmp3_ = _tmp5_ < ((gsize) _tmp6__length1);
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		FD_ZERO (&_tmp7_);
		fds = _tmp7_;
		_tmp8_ = self->priv->fd;
		FD_SET (_tmp8_, &fds);
		_tmp9_ = self->priv->fd;
		_tmp10_ = timeout;
		_tmp11_ = select (_tmp9_ + 1, &fds, NULL, NULL, &_tmp10_);
		res = _tmp11_;
		_tmp12_ = res;
		if (_tmp12_ < 0) {
			gint _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = errno;
			if (_tmp13_ == EINTR) {
				continue;
			}
			_tmp14_ = self->priv->_device;
			_tmp15_ = errno;
			_tmp16_ = g_strerror (_tmp15_);
			g_error ("umockdev.vala:1471: ScriptRunner op_write[%s]: select() failed: %s", _tmp14_, _tmp16_);
		}
		_tmp17_ = res;
		if (_tmp17_ == 0) {
			const gchar* _tmp18_;
			guint8* _tmp19_;
			gint _tmp19__length1;
			gsize _tmp20_;
			guint8* _tmp21_;
			gint _tmp21__length1;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = self->priv->_device;
			_tmp19_ = data;
			_tmp19__length1 = data_length1;
			_tmp20_ = offset;
			_tmp21_ = data;
			_tmp21__length1 = data_length1;
			_tmp22_ = umockdev_script_runner_encode (_tmp19_ + ((gint) _tmp20_), _tmp21__length1 - ((gint) _tmp20_));
			_tmp23_ = _tmp22_;
			g_debug ("umockdev.vala:1476: ScriptRunner[%s]: timed out on read operation on e" \
"xpected block '%s', trying again", _tmp18_, _tmp23_);
			_g_free0 (_tmp23_);
			continue;
		}
		_tmp24_ = self->priv->fd;
		_tmp25_ = buf;
		_tmp25__length1 = buf_length1;
		_tmp26_ = data;
		_tmp26__length1 = data_length1;
		_tmp27_ = offset;
		_tmp28_ = read (_tmp24_, _tmp25_, _tmp26__length1 - _tmp27_);
		len = _tmp28_;
		_tmp29_ = len;
		if (_tmp29_ <= ((gssize) 0)) {
			const gchar* _tmp30_;
			guint8* _tmp31_;
			gint _tmp31__length1;
			gsize _tmp32_;
			guint8* _tmp33_;
			gint _tmp33__length1;
			gchar* _tmp34_;
			gchar* _tmp35_;
			FILE* _tmp36_;
			_tmp30_ = self->priv->_device;
			_tmp31_ = data;
			_tmp31__length1 = data_length1;
			_tmp32_ = offset;
			_tmp33_ = data;
			_tmp33__length1 = data_length1;
			_tmp34_ = umockdev_script_runner_encode (_tmp31_ + ((gint) _tmp32_), _tmp33__length1 - ((gint) _tmp32_));
			_tmp35_ = _tmp34_;
			g_debug ("umockdev.vala:1484: ScriptRunner[%s]: got failure or EOF on read opera" \
"tion on expected block '%s', resetting", _tmp30_, _tmp35_);
			_g_free0 (_tmp35_);
			_tmp36_ = self->priv->script;
			fseek (_tmp36_, (glong) 0, SEEK_SET);
			buf = (g_free (buf), NULL);
			return;
		}
		_tmp37_ = self->priv->fuzz;
		if (_tmp37_ == ((guint) 0)) {
			guint8* _tmp38_;
			gint _tmp38__length1;
			guint8* _tmp39_;
			gint _tmp39__length1;
			gsize _tmp40_;
			guint8* _tmp41_;
			gint _tmp41__length1;
			gssize _tmp42_;
			gint _tmp43_;
			_tmp38_ = buf;
			_tmp38__length1 = buf_length1;
			_tmp39_ = data;
			_tmp39__length1 = data_length1;
			_tmp40_ = offset;
			_tmp41_ = data;
			_tmp41__length1 = data_length1;
			_tmp42_ = len;
			_tmp43_ = memcmp (_tmp38_, _tmp39_ + ((gint) _tmp40_), (gsize) _tmp42_);
			if (_tmp43_ != 0) {
				const gchar* _tmp44_;
				guint8* _tmp45_;
				gint _tmp45__length1;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gssize _tmp48_;
				guint8* _tmp49_;
				gint _tmp49__length1;
				gsize _tmp50_;
				gsize _tmp51_;
				gssize _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp44_ = self->priv->_device;
				_tmp45_ = buf;
				_tmp45__length1 = buf_length1;
				_tmp46_ = umockdev_script_runner_encode (_tmp45_, _tmp45__length1);
				_tmp47_ = _tmp46_;
				_tmp48_ = len;
				_tmp49_ = data;
				_tmp49__length1 = data_length1;
				_tmp50_ = offset;
				_tmp51_ = offset;
				_tmp52_ = len;
				_tmp53_ = umockdev_script_runner_encode (_tmp49_ + ((gint) _tmp50_), ((gint) (_tmp51_ + _tmp52_)) - ((gint) _tmp50_));
				_tmp54_ = _tmp53_;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s'", _tmp44_, _tmp47_, _tmp48_, _tmp54_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp47_);
			}
		} else {
			guint d = 0U;
			guint8* _tmp55_;
			gint _tmp55__length1;
			guint8* _tmp56_;
			gint _tmp56__length1;
			gsize _tmp57_;
			gsize _tmp58_;
			gssize _tmp59_;
			guint _tmp60_;
			guint _tmp61_;
			guint _tmp62_;
			gssize _tmp63_;
			_tmp55_ = buf;
			_tmp55__length1 = buf_length1;
			_tmp56_ = data;
			_tmp56__length1 = data_length1;
			_tmp57_ = offset;
			_tmp58_ = offset;
			_tmp59_ = len;
			_tmp60_ = umockdev_script_runner_hamming (_tmp55_, _tmp55__length1, _tmp56_ + ((gint) _tmp57_), ((gint) (_tmp58_ + _tmp59_)) - ((gint) _tmp57_));
			d = _tmp60_;
			_tmp61_ = d;
			_tmp62_ = self->priv->fuzz;
			_tmp63_ = len;
			if (((gssize) (_tmp61_ * 100)) > (_tmp62_ * _tmp63_)) {
				const gchar* _tmp64_;
				guint8* _tmp65_;
				gint _tmp65__length1;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gssize _tmp68_;
				guint8* _tmp69_;
				gint _tmp69__length1;
				gsize _tmp70_;
				gsize _tmp71_;
				gssize _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				guint _tmp75_;
				gssize _tmp76_;
				guint _tmp77_;
				_tmp64_ = self->priv->_device;
				_tmp65_ = buf;
				_tmp65__length1 = buf_length1;
				_tmp66_ = umockdev_script_runner_encode (_tmp65_, _tmp65__length1);
				_tmp67_ = _tmp66_;
				_tmp68_ = len;
				_tmp69_ = data;
				_tmp69__length1 = data_length1;
				_tmp70_ = offset;
				_tmp71_ = offset;
				_tmp72_ = len;
				_tmp73_ = umockdev_script_runner_encode (_tmp69_ + ((gint) _tmp70_), ((gint) (_tmp71_ + _tmp72_)) - ((gint) _tmp70_));
				_tmp74_ = _tmp73_;
				_tmp75_ = d;
				_tmp76_ = len;
				_tmp77_ = self->priv->fuzz;
				g_error ("ScriptRunner op_write[%s]: data mismatch; got block '%s' (%" G_GSSIZE_FORMAT " bytes), expected block '%s', difference %u%% > fuzz level %u%%", _tmp64_, _tmp67_, _tmp68_, _tmp74_, ((guint) (((_tmp75_ * 1000) / _tmp76_) + 5)) / 10, _tmp77_);
				_g_free0 (_tmp74_);
				_g_free0 (_tmp67_);
			}
		}
		_tmp78_ = offset;
		_tmp79_ = len;
		offset = _tmp78_ + _tmp79_;
		_tmp80_ = self->priv->_device;
		_tmp81_ = len;
		_tmp82_ = offset;
		_tmp83_ = data;
		_tmp83__length1 = data_length1;
		g_debug ("ScriptRunner[%s]: op_write, got %" G_GSSIZE_FORMAT " bytes; offset: %" G_GSIZE_FORMAT ", full block size %i", _tmp80_, _tmp81_, _tmp82_, _tmp83__length1);
	}
	buf = (g_free (buf), NULL);
}


static void _vala_array_add11 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add12 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static guint8* umockdev_script_runner_decode (const gchar* quoted, int* result_length1) {
	guint8* result = NULL;
	guint8* data = NULL;
	guint8* _tmp0_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	g_return_val_if_fail (quoted != NULL, NULL);
	_tmp0_ = g_new0 (guint8, 0);
	data = _tmp0_;
	data_length1 = 0;
	_data_size_ = data_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* _tmp7_;
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				guint8 _tmp11_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = quoted;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = quoted;
				_tmp8_ = string_get_data (_tmp7_, &_tmp8__length1);
				_tmp9_ = _tmp8_;
				_tmp9__length1 = _tmp8__length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				if (_tmp11_ == ((guint8) '^')) {
					gint _tmp12_;
					const gchar* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gchar _tmp16_ = '\0';
					const gchar* _tmp17_;
					guint8* _tmp18_;
					gint _tmp18__length1;
					guint8* _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					guint8 _tmp21_;
					guint8* _tmp27_;
					gint _tmp27__length1;
					gint _tmp28_;
					_tmp12_ = i;
					_tmp13_ = quoted;
					_tmp14_ = strlen (_tmp13_);
					_tmp15_ = _tmp14_;
					_vala_assert ((_tmp12_ + 1) < _tmp15_, "i + 1 < quoted.length");
					_tmp17_ = quoted;
					_tmp18_ = string_get_data (_tmp17_, &_tmp18__length1);
					_tmp19_ = _tmp18_;
					_tmp19__length1 = _tmp18__length1;
					_tmp20_ = i;
					_tmp21_ = _tmp19_[_tmp20_ + 1];
					if (_tmp21_ == ((guint8) '`')) {
						_tmp16_ = '^';
					} else {
						const gchar* _tmp22_;
						guint8* _tmp23_;
						gint _tmp23__length1;
						guint8* _tmp24_;
						gint _tmp24__length1;
						gint _tmp25_;
						guint8 _tmp26_;
						_tmp22_ = quoted;
						_tmp23_ = string_get_data (_tmp22_, &_tmp23__length1);
						_tmp24_ = _tmp23_;
						_tmp24__length1 = _tmp23__length1;
						_tmp25_ = i;
						_tmp26_ = _tmp24_[_tmp25_ + 1];
						_tmp16_ = (gchar) (_tmp26_ - 64);
					}
					_tmp27_ = data;
					_tmp27__length1 = data_length1;
					_vala_array_add11 (&data, &data_length1, &_data_size_, (guint8) _tmp16_);
					_tmp28_ = i;
					i = _tmp28_ + 1;
				} else {
					guint8* _tmp29_;
					gint _tmp29__length1;
					const gchar* _tmp30_;
					guint8* _tmp31_;
					gint _tmp31__length1;
					guint8* _tmp32_;
					gint _tmp32__length1;
					gint _tmp33_;
					guint8 _tmp34_;
					_tmp29_ = data;
					_tmp29__length1 = data_length1;
					_tmp30_ = quoted;
					_tmp31_ = string_get_data (_tmp30_, &_tmp31__length1);
					_tmp32_ = _tmp31_;
					_tmp32__length1 = _tmp31__length1;
					_tmp33_ = i;
					_tmp34_ = _tmp32_[_tmp33_];
					_vala_array_add12 (&data, &data_length1, &_data_size_, _tmp34_);
				}
			}
		}
	}
	_tmp35_ = data;
	_tmp35__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	return result;
}


static void _vala_array_add13 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add17 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add18 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


gchar* umockdev_script_runner_encode (guint8* data, int data_length1) {
	gchar* result = NULL;
	guint8* quoted = NULL;
	guint8* _tmp0_;
	gint quoted_length1;
	gint _quoted_size_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	_tmp0_ = g_new0 (guint8, 0);
	quoted = _tmp0_;
	quoted_length1 = 0;
	_quoted_size_ = quoted_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				guint8* _tmp4_;
				gint _tmp4__length1;
				guint8* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				guint8 _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = data;
				_tmp4__length1 = data_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = data;
				_tmp5__length1 = data_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				if (((gint) _tmp7_) < 32) {
					guint8* _tmp8_;
					gint _tmp8__length1;
					guint8* _tmp9_;
					gint _tmp9__length1;
					guint8* _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					guint8 _tmp12_;
					_tmp8_ = quoted;
					_tmp8__length1 = quoted_length1;
					_vala_array_add13 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
					_tmp9_ = quoted;
					_tmp9__length1 = quoted_length1;
					_tmp10_ = data;
					_tmp10__length1 = data_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					_vala_array_add14 (&quoted, &quoted_length1, &_quoted_size_, (guint8) (_tmp12_ + 64));
				} else {
					guint8* _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					guint8 _tmp15_;
					_tmp13_ = data;
					_tmp13__length1 = data_length1;
					_tmp14_ = i;
					_tmp15_ = _tmp13_[_tmp14_];
					if (_tmp15_ == ((guint8) '^')) {
						guint8* _tmp16_;
						gint _tmp16__length1;
						guint8* _tmp17_;
						gint _tmp17__length1;
						_tmp16_ = quoted;
						_tmp16__length1 = quoted_length1;
						_vala_array_add15 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '^');
						_tmp17_ = quoted;
						_tmp17__length1 = quoted_length1;
						_vala_array_add16 (&quoted, &quoted_length1, &_quoted_size_, (guint8) '`');
					} else {
						guint8* _tmp18_;
						gint _tmp18__length1;
						guint8* _tmp19_;
						gint _tmp19__length1;
						gint _tmp20_;
						guint8 _tmp21_;
						_tmp18_ = quoted;
						_tmp18__length1 = quoted_length1;
						_tmp19_ = data;
						_tmp19__length1 = data_length1;
						_tmp20_ = i;
						_tmp21_ = _tmp19_[_tmp20_];
						_vala_array_add17 (&quoted, &quoted_length1, &_quoted_size_, _tmp21_);
					}
				}
			}
		}
	}
	_tmp22_ = quoted;
	_tmp22__length1 = quoted_length1;
	_vala_array_add18 (&quoted, &quoted_length1, &_quoted_size_, (guint8) 0);
	_tmp23_ = quoted;
	_tmp23__length1 = quoted_length1;
	_tmp24_ = g_strdup ((const gchar*) _tmp23_);
	result = _tmp24_;
	quoted = (g_free (quoted), NULL);
	return result;
}


static guint umockdev_script_runner_hamming (guint8* d1, int d1_length1, guint8* d2, int d2_length1) {
	guint result = 0U;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint d = 0U;
	guint i = 0U;
	_tmp0_ = d1;
	_tmp0__length1 = d1_length1;
	_tmp1_ = d2;
	_tmp1__length1 = d2_length1;
	_vala_assert (_tmp0__length1 == _tmp1__length1, "d1.length == d2.length");
	d = (guint) 0;
	{
		gboolean _tmp2_ = FALSE;
		i = (guint) 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			guint _tmp4_;
			guint8* _tmp5_;
			gint _tmp5__length1;
			guint _tmp6_;
			guint8* _tmp7_;
			gint _tmp7__length1;
			guint _tmp8_;
			guint8 _tmp9_;
			guint8* _tmp10_;
			gint _tmp10__length1;
			guint _tmp11_;
			guint8 _tmp12_;
			if (!_tmp2_) {
				guint _tmp3_;
				_tmp3_ = i;
				i = _tmp3_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp4_ = i;
			_tmp5_ = d1;
			_tmp5__length1 = d1_length1;
			if (!(_tmp4_ < ((guint) _tmp5__length1))) {
				break;
			}
			_tmp6_ = d;
			_tmp7_ = d1;
			_tmp7__length1 = d1_length1;
			_tmp8_ = i;
			_tmp9_ = _tmp7_[_tmp8_];
			_tmp10_ = d2;
			_tmp10__length1 = d2_length1;
			_tmp11_ = i;
			_tmp12_ = _tmp10_[_tmp11_];
			d = _tmp6_ + ((guint) (((gint) (_tmp9_ ^ _tmp12_)) > 0));
		}
	}
	result = d;
	return result;
}


const gchar* umockdev_script_runner_get_device (UMockdevScriptRunner* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static void umockdev_script_runner_set_device (UMockdevScriptRunner* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_device);
	self->priv->_device = _tmp1_;
}


static void umockdev_value_script_runner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void umockdev_value_script_runner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		umockdev_script_runner_unref (value->data[0].v_pointer);
	}
}


static void umockdev_value_script_runner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_script_runner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer umockdev_value_script_runner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* umockdev_value_script_runner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UMockdevScriptRunner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_script_runner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* umockdev_value_script_runner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UMockdevScriptRunner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_script_runner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* umockdev_param_spec_script_runner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UMockdevParamSpecScriptRunner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer umockdev_value_get_script_runner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER), NULL);
	return value->data[0].v_pointer;
}


void umockdev_value_set_script_runner (GValue* value, gpointer v_object) {
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_script_runner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}


void umockdev_value_take_script_runner (GValue* value, gpointer v_object) {
	UMockdevScriptRunner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SCRIPT_RUNNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SCRIPT_RUNNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_script_runner_unref (old);
	}
}


static void umockdev_script_runner_class_init (UMockdevScriptRunnerClass * klass) {
	umockdev_script_runner_parent_class = g_type_class_peek_parent (klass);
	((UMockdevScriptRunnerClass *) klass)->finalize = umockdev_script_runner_finalize;
	g_type_class_add_private (klass, sizeof (UMockdevScriptRunnerPrivate));
}


static void umockdev_script_runner_instance_init (UMockdevScriptRunner * self) {
	self->priv = UMOCKDEV_SCRIPT_RUNNER_GET_PRIVATE (self);
	self->priv->fuzz = (guint) 0;
	self->ref_count = 1;
}


static void umockdev_script_runner_finalize (UMockdevScriptRunner * obj) {
	UMockdevScriptRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SCRIPT_RUNNER, UMockdevScriptRunner);
	g_signal_handlers_destroy (self);
	umockdev_script_runner_stop (self);
	_g_free0 (self->priv->_device);
	_g_free0 (self->priv->script_file);
	_g_thread_unref0 (self->priv->thread);
	_fclose0 (self->priv->script);
}


GType umockdev_script_runner_get_type (void) {
	static volatile gsize umockdev_script_runner_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_script_runner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_script_runner_init, umockdev_value_script_runner_free_value, umockdev_value_script_runner_copy_value, umockdev_value_script_runner_peek_pointer, "p", umockdev_value_script_runner_collect_value, "p", umockdev_value_script_runner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevScriptRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_script_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevScriptRunner), 0, (GInstanceInitFunc) umockdev_script_runner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_script_runner_type_id;
		umockdev_script_runner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevScriptRunner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&umockdev_script_runner_type_id__volatile, umockdev_script_runner_type_id);
	}
	return umockdev_script_runner_type_id__volatile;
}


gpointer umockdev_script_runner_ref (gpointer instance) {
	UMockdevScriptRunner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void umockdev_script_runner_unref (gpointer instance) {
	UMockdevScriptRunner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SCRIPT_RUNNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _umockdev_socket_server_run_gthread_func (gpointer self) {
	gpointer result;
	result = umockdev_socket_server_run ((UMockdevSocketServer*) self);
	umockdev_socket_server_unref (self);
	return result;
}


UMockdevSocketServer* umockdev_socket_server_construct (GType object_type) {
	UMockdevSocketServer* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GThread* _tmp6_;
	gint* fds = NULL;
	gint* _tmp7_;
	gint fds_length1;
	gint _fds_size_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	self = (UMockdevSocketServer*) g_type_create_instance (object_type);
	self->priv->running = TRUE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	self->priv->socket_scriptfile = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _umockdev_script_runner_unref0_);
	_g_hash_table_unref0 (self->priv->script_runners);
	self->priv->script_runners = _tmp5_;
	_tmp6_ = g_thread_new ("SocketServer", _umockdev_socket_server_run_gthread_func, umockdev_socket_server_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp6_;
	_tmp7_ = g_new0 (gint, 2);
	fds = _tmp7_;
	fds_length1 = 2;
	_fds_size_ = fds_length1;
	_tmp8_ = pipe (fds);
	_vala_assert (_tmp8_ == 0, "Posix.pipe (fds) == 0");
	_tmp9_ = fds[0];
	self->priv->ctrl_r = _tmp9_;
	_tmp10_ = fds[1];
	self->priv->ctrl_w = _tmp10_;
	fds = (g_free (fds), NULL);
	return self;
}


UMockdevSocketServer* umockdev_socket_server_new (void) {
	return umockdev_socket_server_construct (UMOCKDEV_TYPE_SOCKET_SERVER);
}


void umockdev_socket_server_stop (UMockdevSocketServer* self) {
	gboolean _tmp0_;
	gchar b = '\0';
	gint _tmp1_;
	gssize _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	GHashTable* _tmp6_;
	GThread* _tmp7_;
	GThread* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->running;
	if (!_tmp0_) {
		return;
	}
	self->priv->running = FALSE;
	g_debug ("umockdev.vala:1604: Stopping SocketServer: signalling thread");
	b = '1';
	_tmp1_ = self->priv->ctrl_w;
	_tmp2_ = write (_tmp1_, &b, (gsize) 1);
	_vala_assert (_tmp2_ == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
	_tmp3_ = self->priv->script_runners;
	_tmp4_ = g_hash_table_get_values (_tmp3_);
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp4_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			UMockdevScriptRunner* r = NULL;
			r = (UMockdevScriptRunner*) r_it->data;
			{
				UMockdevScriptRunner* _tmp5_;
				_tmp5_ = r;
				umockdev_script_runner_stop (_tmp5_);
			}
		}
		_g_list_free0 (r_collection);
	}
	_tmp6_ = self->priv->script_runners;
	g_hash_table_remove_all (_tmp6_);
	g_debug ("umockdev.vala:1613: Stopping SocketServer: joining thread");
	_tmp7_ = self->priv->thread;
	_tmp8_ = _g_thread_ref0 (_tmp7_);
	g_thread_join (_tmp8_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add19 (GSocket** * array, int* length, int* size, GSocket* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GSocket*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void umockdev_socket_server_add (UMockdevSocketServer* self, const gchar* sock_path, gint fd, const gchar* record_file) {
	const gchar* _tmp17_;
	gint _tmp18_;
	GHashTable* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar b = '\0';
	gint _tmp24_;
	gssize _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sock_path != NULL);
	g_return_if_fail (record_file != NULL);
	{
		GSocket* s = NULL;
		gint _tmp0_;
		GSocket* _tmp1_;
		GSocket* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GSocket* _tmp4_;
		const gchar* _tmp5_;
		GUnixSocketAddress* _tmp6_;
		GUnixSocketAddress* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_ = FALSE;
		GSocket* _tmp11_;
		gboolean _tmp12_;
		GSocket** _tmp13_;
		gint _tmp13__length1;
		GSocket* _tmp14_;
		GSocket* _tmp15_;
		_tmp0_ = fd;
		_tmp1_ = g_socket_new_from_fd (_tmp0_, &_inner_error_);
		s = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp2_ = s;
		_vala_assert (_tmp2_ != NULL, "s != null");
		_tmp4_ = s;
		_tmp5_ = sock_path;
		_tmp6_ = (GUnixSocketAddress*) g_unix_socket_address_new (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_socket_bind (_tmp4_, (GSocketAddress*) _tmp7_, TRUE, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_tmp3_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch12_g_error;
		}
		_vala_assert (_tmp3_, "s.bind (new UnixSocketAddress (sock_path), true)");
		_tmp11_ = s;
		_tmp12_ = g_socket_listen (_tmp11_, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (s);
			goto __catch12_g_error;
		}
		_vala_assert (_tmp10_, "s.listen ()");
		_tmp13_ = self->priv->listen_sockets;
		_tmp13__length1 = self->priv->listen_sockets_length1;
		_tmp14_ = s;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_vala_array_add19 (&self->priv->listen_sockets, &self->priv->listen_sockets_length1, &self->priv->_listen_sockets_size_, _tmp15_);
		_g_object_unref0 (s);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e->message;
		g_error ("umockdev.vala:1626: load_socket_script(): cannot create Socket: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp17_ = sock_path;
	_tmp18_ = fd;
	g_debug ("umockdev.vala:1629: SocketServer.add: Created socket path %s, fd %i", _tmp17_, _tmp18_);
	_tmp19_ = self->priv->socket_scriptfile;
	_tmp20_ = sock_path;
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = record_file;
	_tmp23_ = g_strdup (_tmp22_);
	g_hash_table_insert (_tmp19_, _tmp21_, _tmp23_);
	b = '1';
	_tmp24_ = self->priv->ctrl_w;
	_tmp25_ = write (_tmp24_, &b, (gsize) 1);
	_vala_assert (_tmp25_ == ((gssize) 1), "Posix.write (this.ctrl_w, &b, 1) == 1");
}


static void* umockdev_socket_server_run (UMockdevSocketServer* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_debug ("umockdev.vala:1640: starting SocketServer thread");
	while (TRUE) {
		gboolean _tmp0_;
		fd_set fds = {0};
		fd_set _tmp1_ = {0};
		gint _tmp2_;
		gint max = 0;
		gint _tmp3_;
		GSocket** _tmp4_;
		gint _tmp4__length1;
		gint res = 0;
		gint _tmp15_;
		struct timeval _tmp16_ = {0};
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp22_;
		gint _tmp23_;
		fd_set _tmp24_;
		gint _tmp25_;
		GSocket** _tmp28_;
		gint _tmp28__length1;
		_tmp0_ = self->priv->running;
		if (!_tmp0_) {
			break;
		}
		FD_ZERO (&_tmp1_);
		fds = _tmp1_;
		_tmp2_ = self->priv->ctrl_r;
		FD_SET (_tmp2_, &fds);
		_tmp3_ = self->priv->ctrl_r;
		max = _tmp3_;
		_tmp4_ = self->priv->listen_sockets;
		_tmp4__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp4_;
			s_collection_length1 = _tmp4__length1;
			for (s_it = 0; s_it < _tmp4__length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					GSocket* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					_tmp5_ = s;
					_tmp6_ = g_socket_get_fd (_tmp5_);
					_tmp7_ = _tmp6_;
					FD_SET (_tmp7_, &fds);
					_tmp8_ = s;
					_tmp9_ = g_socket_get_fd (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = max;
					if (_tmp10_ > _tmp11_) {
						GSocket* _tmp12_;
						gint _tmp13_;
						gint _tmp14_;
						_tmp12_ = s;
						_tmp13_ = g_socket_get_fd (_tmp12_);
						_tmp14_ = _tmp13_;
						max = _tmp14_;
					}
				}
			}
		}
		_tmp15_ = max;
		_tmp16_.tv_sec = (time_t) 0;
		_tmp16_.tv_usec = (glong) 500000;
		_tmp17_ = select (_tmp15_ + 1, &fds, NULL, NULL, &_tmp16_);
		res = _tmp17_;
		_tmp18_ = res;
		if (_tmp18_ < 0) {
			gint _tmp19_;
			gint _tmp20_;
			const gchar* _tmp21_;
			_tmp19_ = errno;
			if (_tmp19_ == EINTR) {
				continue;
			}
			_tmp20_ = errno;
			_tmp21_ = g_strerror (_tmp20_);
			g_error ("umockdev.vala:1659: socket server thread: select() failed: %s", _tmp21_);
		}
		_tmp22_ = res;
		if (_tmp22_ == 0) {
			continue;
		}
		_tmp23_ = self->priv->ctrl_r;
		_tmp24_ = fds;
		_tmp25_ = FD_ISSET (_tmp23_, &_tmp24_);
		if (_tmp25_ > 0) {
			gchar buf = '\0';
			gint _tmp26_;
			gssize _tmp27_;
			g_debug ("umockdev.vala:1666: socket server thread: woken up by control fd");
			_tmp26_ = self->priv->ctrl_r;
			_tmp27_ = read (_tmp26_, &buf, (gsize) 1);
			_vala_assert (_tmp27_ == ((gssize) 1), "Posix.read (this.ctrl_r, &buf, 1) == 1");
			continue;
		}
		g_debug ("umockdev.vala:1672: socket server thread: select() got requests");
		_tmp28_ = self->priv->listen_sockets;
		_tmp28__length1 = self->priv->listen_sockets_length1;
		{
			GSocket** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp28_;
			s_collection_length1 = _tmp28__length1;
			for (s_it = 0; s_it < _tmp28__length1; s_it = s_it + 1) {
				GSocket* s = NULL;
				s = s_collection[s_it];
				{
					GSocket* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					fd_set _tmp32_;
					gint _tmp33_;
					_tmp29_ = s;
					_tmp30_ = g_socket_get_fd (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = fds;
					_tmp33_ = FD_ISSET (_tmp31_, &_tmp32_);
					if (_tmp33_ > 0) {
						gint fd = 0;
						GSocket* _tmp34_;
						gint _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						gint _tmp38_;
						gchar* sock_path = NULL;
						_tmp34_ = s;
						_tmp35_ = g_socket_get_fd (_tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = accept (_tmp36_, NULL, NULL);
						fd = _tmp37_;
						_tmp38_ = fd;
						if (_tmp38_ < 0) {
							gint _tmp39_;
							const gchar* _tmp40_;
							_tmp39_ = errno;
							_tmp40_ = g_strerror (_tmp39_);
							g_error ("umockdev.vala:1679: socket server thread: accept() failed: %s", _tmp40_);
						}
						sock_path = NULL;
						{
							GSocketAddress* _tmp41_ = NULL;
							GSocket* _tmp42_;
							GSocketAddress* _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							gchar* script = NULL;
							GHashTable* _tmp47_;
							const gchar* _tmp48_;
							gconstpointer _tmp49_;
							gchar* _tmp50_;
							GSocket* _tmp51_;
							gint _tmp52_;
							gint _tmp53_;
							const gchar* _tmp54_;
							const gchar* _tmp55_;
							gchar* key = NULL;
							const gchar* _tmp56_;
							gint _tmp57_;
							gchar* _tmp58_;
							UMockdevScriptRunner* _tmp59_ = NULL;
							const gchar* _tmp60_;
							const gchar* _tmp61_;
							gint _tmp62_;
							UMockdevScriptRunner* _tmp63_;
							GHashTable* _tmp64_;
							const gchar* _tmp65_;
							gchar* _tmp66_;
							UMockdevScriptRunner* _tmp67_;
							_tmp42_ = s;
							_tmp43_ = g_socket_get_local_address (_tmp42_, &_inner_error_);
							_tmp41_ = _tmp43_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch13_g_error;
							}
							_tmp44_ = g_unix_socket_address_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, G_TYPE_UNIX_SOCKET_ADDRESS, GUnixSocketAddress));
							_tmp45_ = _tmp44_;
							_tmp46_ = g_strdup (_tmp45_);
							_g_free0 (sock_path);
							sock_path = _tmp46_;
							_tmp47_ = self->priv->socket_scriptfile;
							_tmp48_ = sock_path;
							_tmp49_ = g_hash_table_lookup (_tmp47_, _tmp48_);
							_tmp50_ = g_strdup ((const gchar*) _tmp49_);
							script = _tmp50_;
							_tmp51_ = s;
							_tmp52_ = g_socket_get_fd (_tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = sock_path;
							_tmp55_ = script;
							g_debug ("umockdev.vala:1684: socket server thread: accepted request on server s" \
"ocket fd %i, path %s, script %s", _tmp53_, _tmp54_, _tmp55_);
							_tmp56_ = sock_path;
							_tmp57_ = fd;
							_tmp58_ = g_strdup_printf ("%s%i", _tmp56_, _tmp57_);
							key = _tmp58_;
							_tmp60_ = key;
							_tmp61_ = script;
							_tmp62_ = fd;
							_tmp63_ = umockdev_script_runner_new (_tmp60_, _tmp61_, _tmp62_, &_inner_error_);
							_tmp59_ = _tmp63_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								_g_free0 (key);
								_g_free0 (script);
								_g_object_unref0 (_tmp41_);
								goto __catch13_g_error;
							}
							_tmp64_ = self->priv->script_runners;
							_tmp65_ = key;
							_tmp66_ = g_strdup (_tmp65_);
							_tmp67_ = _tmp59_;
							_tmp59_ = NULL;
							g_hash_table_insert (_tmp64_, _tmp66_, _tmp67_);
							_umockdev_script_runner_unref0 (_tmp59_);
							_g_free0 (key);
							_g_free0 (script);
							_g_object_unref0 (_tmp41_);
						}
						goto __finally13;
						__catch13_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp68_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp68_ = e->message;
							g_error ("umockdev.vala:1689: socket server thread: cannot launch ScriptRunner: " \
"%s", _tmp68_);
							_g_error_free0 (e);
						}
						__finally13:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (sock_path);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_g_free0 (sock_path);
					}
				}
			}
		}
	}
	g_debug ("umockdev.vala:1695: socket server thread: end");
	result = NULL;
	return result;
}


static void umockdev_value_socket_server_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void umockdev_value_socket_server_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		umockdev_socket_server_unref (value->data[0].v_pointer);
	}
}


static void umockdev_value_socket_server_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = umockdev_socket_server_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer umockdev_value_socket_server_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* umockdev_value_socket_server_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UMockdevSocketServer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = umockdev_socket_server_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* umockdev_value_socket_server_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UMockdevSocketServer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = umockdev_socket_server_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* umockdev_param_spec_socket_server (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UMockdevParamSpecSocketServer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer umockdev_value_get_socket_server (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER), NULL);
	return value->data[0].v_pointer;
}


void umockdev_value_set_socket_server (GValue* value, gpointer v_object) {
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		umockdev_socket_server_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}


void umockdev_value_take_socket_server (GValue* value, gpointer v_object) {
	UMockdevSocketServer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UMOCKDEV_TYPE_SOCKET_SERVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UMOCKDEV_TYPE_SOCKET_SERVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		umockdev_socket_server_unref (old);
	}
}


static void umockdev_socket_server_class_init (UMockdevSocketServerClass * klass) {
	umockdev_socket_server_parent_class = g_type_class_peek_parent (klass);
	((UMockdevSocketServerClass *) klass)->finalize = umockdev_socket_server_finalize;
	g_type_class_add_private (klass, sizeof (UMockdevSocketServerPrivate));
}


static void umockdev_socket_server_instance_init (UMockdevSocketServer * self) {
	GSocket** _tmp0_;
	self->priv = UMOCKDEV_SOCKET_SERVER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (GSocket*, 0 + 1);
	self->priv->listen_sockets = _tmp0_;
	self->priv->listen_sockets_length1 = 0;
	self->priv->_listen_sockets_size_ = self->priv->listen_sockets_length1;
	self->ref_count = 1;
}


static void umockdev_socket_server_finalize (UMockdevSocketServer * obj) {
	UMockdevSocketServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UMOCKDEV_TYPE_SOCKET_SERVER, UMockdevSocketServer);
	g_signal_handlers_destroy (self);
	umockdev_socket_server_stop (self);
	self->priv->listen_sockets = (_vala_array_free (self->priv->listen_sockets, self->priv->listen_sockets_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->socket_scriptfile);
	_g_hash_table_unref0 (self->priv->script_runners);
	_g_thread_unref0 (self->priv->thread);
}


GType umockdev_socket_server_get_type (void) {
	static volatile gsize umockdev_socket_server_type_id__volatile = 0;
	if (g_once_init_enter (&umockdev_socket_server_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { umockdev_value_socket_server_init, umockdev_value_socket_server_free_value, umockdev_value_socket_server_copy_value, umockdev_value_socket_server_peek_pointer, "p", umockdev_value_socket_server_collect_value, "p", umockdev_value_socket_server_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UMockdevSocketServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) umockdev_socket_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UMockdevSocketServer), 0, (GInstanceInitFunc) umockdev_socket_server_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType umockdev_socket_server_type_id;
		umockdev_socket_server_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UMockdevSocketServer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&umockdev_socket_server_type_id__volatile, umockdev_socket_server_type_id);
	}
	return umockdev_socket_server_type_id__volatile;
}


gpointer umockdev_socket_server_ref (gpointer instance) {
	UMockdevSocketServer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void umockdev_socket_server_unref (gpointer instance) {
	UMockdevSocketServer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UMOCKDEV_SOCKET_SERVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


/**
 * umockdev_in_mock_environment:
 *
 * Check whether the current process is running under umockdev-wrapper, i. e.
 * the umockdev preload library.
 *
 * Returns: %TRUE if running under preload with mocked devices, %FALSE if
 *          running against the real system.
 */
gboolean umockdev_in_mock_environment (void) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp8_;
	_tmp0_ = umockdev___in_mock_env_initialized;
	if (!_tmp0_) {
		struct stat st = {0};
		struct stat _tmp1_ = {0};
		gint _tmp2_;
		_tmp2_ = stat ("/sys", &_tmp1_);
		st = _tmp1_;
		if (_tmp2_ >= 0) {
			gboolean _tmp3_ = FALSE;
			struct stat _tmp4_;
			ino_t _tmp5_;
			_tmp4_ = st;
			_tmp5_ = _tmp4_.st_ino;
			if (_tmp5_ > ((ino_t) 1)) {
				struct stat _tmp6_;
				gsize _tmp7_;
				_tmp6_ = st;
				_tmp7_ = _tmp6_.st_size;
				_tmp3_ = _tmp7_ > ((gsize) 0);
			} else {
				_tmp3_ = FALSE;
			}
			umockdev___in_mock_env_result = _tmp3_;
		}
		umockdev___in_mock_env_initialized = TRUE;
	}
	_tmp8_ = umockdev___in_mock_env_result;
	result = _tmp8_;
	return result;
}


GQuark umockdev_error_quark (void) {
	return g_quark_from_static_string ("umockdev_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



