/*
 * Copyright (c) 2003-2006 Erez Zadok
 * Copyright (c) 2003-2006 Charles P. Wright
 * Copyright (c) 2005-2006 Josef Sipek
 * Copyright (c) 2005      Arun M. Krishnakumar
 * Copyright (c) 2005-2006 David P. Quigley
 * Copyright (c) 2003-2004 Mohammad Nayyer Zubair
 * Copyright (c) 2003      Puja Gupta
 * Copyright (c) 2003      Harikesavan Krishnan
 * Copyright (c) 2003-2006 Stony Brook University
 * Copyright (c) 2003-2006 The Research Foundation of State University of New York
 *
 * For specific licensing information, see the COPYING file distributed with
 * this package.
 *
 * This Copyright notice must be kept intact and distributed with all sources.
 */
/*
 *  $Id: unionimap.h,v 1.10 2006/10/06 20:13:46 yiannos Exp $
 */

#ifndef __UNIONIMAP_H_
#define __UNIONIMAP_H_

#include "config.h"

#ifdef HAVE_STDIO_H
	#include <stdio.h>
#else /* HAVE_STDIO_H */
	#error Need stdio.h to compile
#endif /* HAVE_STDIO_H */

#ifdef HAVE_STRING_H
	#include <string.h>
#else /* HAVE_STRING_H */
	#error Need string.h to compile
#endif /* HAVE_STRING_H */

#ifdef HAVE_SYS_STAT_H
	#include <sys/stat.h>
#else /* HAVE_SYS_STAT_H */
	#define S_IRUSR 0400
	#define S_IWUSR O200
#endif /* HAVE_SYS_STAT_H */

#ifdef HAVE_SYS_IOCTL_H
        #include <sys/ioctl.h>
#else   /* HAVE_SYS_IOCTL_H */
        #error Need sys/ioctl.h to compile
#endif /* HAVE_SYS_IOCTL_H */

#ifdef HAVE_SYS_STATFS_H
        #include <sys/statfs.h>
#else   /* HAVE_SYS_STATFS_H */
        #error Need sys/statfs.h to compile
#endif /* HAVE_SYS_STATFS_H */

#ifdef HAVE_ERRNO_H
        #include <errno.h>
#else /* HAVE_ERRNO_H */
	#error Need errno.h to compile
#endif /* HAVE_ERRNO_H */

#ifdef HAVE_FCNTL_H
	#include <fcntl.h>
#else /* HAVE_FCNTL_H */
	#error Need fcntl.h to compile
#endif /* HAVE_FCNTL_H */


#if defined HAVE_LIBUUID && defined HAVE_UUID_UUID_H

#include <uuid/uuid.h>

/*
 * Defines,structs,and functions for persistent inodes used by kernel and user
 */

typedef u_int8_t uint8_t;
typedef u_int32_t uint32_t;
typedef u_int64_t uint64_t;

#define UUID_LEN 16
#define UUID_UNP_LEN 37
#define MAX_MAPS 256
#define FORWARDMAP_MAGIC 0x4b1cb38f
#define REVERSEMAP_MAGIC 0Xfcafad71
#define FORWARDMAP_VERSION 0x02
#define REVERSEMAP_VERSION 0x01

struct fmaphdr {
 	uint32_t magic;
 	uint32_t version;
 	uint8_t usedbranches;
 	uint8_t uuid[UUID_LEN];
};

struct bmapent {
	fsid_t fsid;
	uint8_t uuid[UUID_LEN];
};

struct rmaphdr {
	uint32_t magic;
	uint32_t version;
	uint8_t fwduuid[UUID_LEN];
	uint8_t revuuid[UUID_LEN];
	fsid_t fsid;
};

struct bpair {
	fsid_t fsid;
	uint8_t fsnum;
};

struct fmapent {
	uint8_t fsnum;
	uint64_t inode;
};

int unionfs_create_forwardmap(char *filename);
int unionfs_open_forwardmap(struct fmaphdr *header, char *forwardmap);
int unionfs_check_if_entry_exists(int fwrdmap, struct statfs stat, char *path);
int unionfs_create_reversemap(char *filename, char *path, char *forwardmap);
int unionfs_dump_map(char *filename, int debug_level);

#else /* HAVE_LIBUUID && HAVE_UUID_H */

	#warning Missing libuuid, no imap functionality

#endif /* HAVE_LIBUUID && HAVE_UUID_H */


#endif /* __UNIONIMAP_H_ */
/*
 *
 * vim:shiftwidth=8
 * vim:tabstop=8
 *
 * For Emacs:
 * Local variables:
 * c-basic-offset: 8
 * c-comment-only-line-offset: 0
 * c-offsets-alist: ((statement-block-intro . +) (knr-argdecl-intro . 0)
 *              (substatement-open . 0) (label . 0) (statement-cont . +))
 * indent-tabs-mode: t
 * tab-width: 8
 * End:
 */
