/* Chromium Unity integration extension
 * 
 *   Copyright 2012 Canonical Ltd.
 *
 *   This program is free software: you can redistribute it and/or modify it 
 *   under the terms of the GNU General Public License version 3, as published 
 *   by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but 
 *   WITHOUT ANY WARRANTY; without even the implied warranties of 
 *   MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 *   PURPOSE.  See the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along 
 *   with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

// TODO just there for convenience, will probably reuse those from FF but w/ a better
//  module mecanism (dunno what is used by FF)

// FF specific
// TODO should be properly injected
var unsafeWindow = window;

var UnityPopupManager = (
  function () {
    UnityPopupManager = {
      requestIntegration: function (name, domain, integrateCallback, dontAskActionCallback) {
	var message = chrome.i18n.getMessage("integration_copy", [name, domain]);
	var details = "";
	
	var isconfirmed = function (response) {
	  return response && response.integrate;
	};
	UnityContentScriptApi.requestUnityIntegration (message,
                                                       details,
					               function(response) {
					                 if (isconfirmed (response)) {
						           integrateCallback ();
					                 }
                                                         else {
						           dontAskActionCallback ();
                                                         }
					               });
      }
    };
    
    return UnityPopupManager;
  }						   
)();

var UnityFaviconUtils = (
  function () {
    function findFaviconLink (document){
      var linkElements = document.getElementsByTagName("link");
      var i = 0;
      
      for (i = 0; i < linkElements.length; i++){
	var element = linkElements[i];
	
	if (element.hasAttribute("rel") &&
	    (element.rel == "shortcut icon")) {
	  var link = element.href;
	  
	  if (link[0] == "/") {
	    return document.location + link;
	  } else {
	    return link;
	  }
	}
      }
      
      return null;
    }
    
    UnityFaviconUtils = {
      getFaviconForDocument: function (document) {
	var favIcon = findFaviconLink (document);
	
	if (favIcon == null) {
	  favIcon = "http://" + document.domain + "/favicon.ico";
	}
	
	return favIcon;
      }
    };

    return UnityFaviconUtils;
  }
) ();


var UnityWindowHelper = (
  function () {
    function UnityWindowHelper (aWindow) {
      this.window = aWindow;
    };

    UnityWindowHelper.prototype.FindToplevelContentWindow = function (aWindow) {
      var toplevelContentWindow = aWindow;
      
      while (toplevelContentWindow.parent != toplevelContentWindow){
	toplevelContentWindow = toplevelContentWindow.parent;
      }
      return toplevelContentWindow;
    };

    return UnityWindowHelper;
  }
) ();


var UnityPreviewUtils = (
  function () {
    UnityPreviewUtils = {
      getPreviewForWindow: function (window, callback) {
	
	UnityContentScriptApi.takeSnapshot (function (dataURL) {
				              callback (dataURL);
			                    });
      }
    };

    return UnityPreviewUtils;
  }
)();


UnityGlobalPropertyInitializer = {
  makeCallback: function (uwa, service, logger) {
    function callback(aWindow) {
      var _global = {
        context: null
      };
      var _uwa = uwa;
      
      // TODO fix, improper "form"
      var PopupManager = UnityPopupManager;
      var WindowHelper = new UnityWindowHelper (window);
      
      var doListenToTabChanges = function () {
	// open communication link w/ background page to be informed of everything that happens w/
	//  the page itself
	
	// TODO mmh all tabs userscript will receive this, so it might trigger duplicate is_active(0) calls
	//  for already unactive tabs
	chrome.extension.onRequest.addListener (
	  function (request, sender, response) {
	    if (request && request.method && request.method === 'on_tab_active_changed') {
	      UnityContentScriptApi.getTabInfo (
		function (response) {
		  if (request.tabId === response.tabId) {
		    logger ('Activating context corresponding to tab ' + request.tabId);
		    _uwa.context_set_view_is_active (_global.context, 1);
		  }
		  else {
		    _uwa.context_set_view_is_active (_global.context, 0);
		  }
		});
	    }
	  });
      };

      window.addEventListener("pagehide"
			      , function(event) {
				if (_global.context == null) {return;}
				_uwa.context_destroy (_global.context, 0);
				_global.context = null;
			      }, false);
      _global.onInitCallbacks = [];
      
      function doInitializeContextWithName (name, service, domain, iconUrl, oninit, homepage, login, mimeTypes, environmentInfos, firstTime) {
	// If we are adding the site for the first time and there is no homepage, store the point of integration.
	if (firstTime && homepage == undefined) {
	  homepage = WindowHelper.FindToplevelContentWindow (window).document.location.toString();
	}
        
	var appRaiseCallback = function (context, file, userdata) {
          UnityContentScriptApi.getTabInfo (
            function (response) {
              UnityContentScriptApi.raiseTabWithId({tabId: response.tabId, windowId: response.windowId});

              if (file !== null) {
                if (_global.acceptDataCallback) {
                  try {
                    _global.acceptDataCallback (file);
                  }
                  catch(e) {
                    console.log ("Error: " + e);
                  }  
                }
              }
            });
	};
	var appCloseCallback = function (context, userdata) {
          UnityContentScriptApi.getTabInfo (
            function (response) {
              UnityContentScriptApi.killTabWithId({tabId: response.tabId, windowId: response.windowId});
            });
	};
	
	var contextPrepared = function () {

          if (login) {
            logger("Notifying parent extension of login info");
            chrome.extension.sendMessage ({
                                            action: "loginEvent",
                                            login: login,
                                            domain: domain
                                          });
          }

	  // preview request is asynchronous & only for visible tab, so we
	  // take a guess a take a snapshot in the current tab's state
	  // 
	  // TODO make sure that we are still in the same tab (vs visible one).
	  var _previewData = '\0';
	  UnityPreviewUtils.getPreviewForWindow (window, function (dataURL) { _previewData = dataURL; });
	  
	  var previewRequestedCallback = function (context, user_data) {
	    var content = null;
	    
	    try {	    
	      content = _previewData + '\0';
	    } catch (e) {
	      logger ("Unity Preview Error: " + e.toString());
	    }
	    
	    return content;
	  };
	  
	  logger ('Got a context for domain '
		  + domain
		  + ', service: '
		  + service
		  + ', name: '
		  + name
		  + ", homepage: "
		  + homepage
		  + ', context: '
		  + _global.context);
	  
	  _global.contextReady = true;
	  
	  _uwa.context_add_icon (_global.context
				 , UnityFaviconUtils.getFaviconForDocument (document)
				 , 16);
	  
	  _uwa.context_on_raise_callback (_global.context, appRaiseCallback, null);
	  _uwa.context_on_close_callback (_global.context, appCloseCallback, null);
	  _uwa.context_set_preview_requested_callback (_global.context, previewRequestedCallback, null);
	  
	  if ((homepage != undefined) && (homepage != null)) {
	    _uwa.context_set_homepage (_global.context, homepage);
	  }
	  
	  for (var c in _global.onInitCallbacks) {
	    var callback = _global.onInitCallbacks[c];
	    
	    if (callback != null) {
	      try {
		logger ('Calling an initialization callback');
		
		callback();
		
	      } catch (e) {
		logger ("Unity Extension, error calling onInit callback: " + e.toString());
	      }
	    }
	  }
	  
	  doListenToTabChanges ();

          _uwa.context_set_view_is_active (_global.context, 1);

	  _uwa.context_set_view_location (_global.context, document.location.toString());
 	  _uwa.service_set_xid_for_browser_window_id (service
                                                      , _global.context
                                                      , environmentInfos.windowId);
          
          var context_name = _uwa.context_get_name(_global.context);
          var domain_name = _uwa.context_get_domain(_global.context) || domain;
          var interest_id = _uwa.context_get_interest_id(_global.context);
          UnityContentScriptApi.addIntegrationScriptForTab(context_name
                                                           , domain_name
                                                           , interest_id);
        };
        
        if (_global.context != null) {
	  if (_global.contextReady && oninit != null) {
	    
	    try {
	      logger ("Calling integration script's initialization function");
	      
	      oninit();
	      
	    } catch (e) {
	      logger ("Unity Extension, exception calling onInit callback: " + e.toString());
	    }
	  } else if (_global.contextReady == false) {
	    
	    _global.onInitCallbacks.push (oninit);
	  }
	  return;
	}
	
	_global.context = _uwa.context_new_lazy (service, name, domain, iconUrl, mimeTypes);
	
	_global.contextReady = false;
	
	_global.onInitCallbacks.push (oninit);
	
	logger ("Preparing Unity context");
	
	_uwa.context_prepare (_global.context, contextPrepared, null);
      }; // function doInitializeContextWithName
      
      function unityInit (options, environmentInfos) {
	
	var name = options.name || "Undefined name";
	var integrationScriptInitCallback = options.onInit || function () { logger ("Default onInit called for '" + name + "'"); };
	var iconUrl = options.iconUrl;
	var homepage = options.homepage;
	var domain = options.domain;
	var login = options.login;
        var mimeTypes = options.mimeTypes;
	
	var unityInitWithDomain = function (domain) {
          if (!_uwa.permissions_is_integration_allowed()) {
	    logger ("Unity integration disabled (by user settings).");
	    return;
          }
	  function integrateActionCallback() {
	    _uwa.permissions_allow_domain (domain);

	    doInitializeContextWithName (name
					 , service
					 , domain
					 , iconUrl
					 , integrationScriptInitCallback
					 , homepage
                                         , login
                                         , mimeTypes
                                         , environmentInfos
                                         , true);
	  }

	  function dontAskActionCallback() {
	    _uwa.permissions_dontask_domain (domain);
	  }
	  logger ("Initializing Unity for domain: " + domain);

	  if (_uwa.permissions_get_domain_dontask (domain)) {
	    logger ("Domain has been 'blacklisted'");
	    return;
	  }

	  if (domain == "" || _uwa.permissions_get_domain_allowed (domain)) {
	    logger ("Domain has been 'whilelisted' - skipping the integration step");
	    try {
	      doInitializeContextWithName (name
					   , service
					   , domain
					   , iconUrl
					   , integrationScriptInitCallback
					   , homepage
                                           , login
                                           , mimeTypes
                                           , environmentInfos
                                           , false);
	    }
	    catch (e) {
	      logger ("Unity Extension: Error initializing context (" + e.toString() + e.line + e + ")");
	    }
	    return;
	  }
	  logger ('Requesting Unity integration to user');

	  PopupManager.requestIntegration(name
					  , domain
					  , integrateActionCallback
					  , dontAskActionCallback);
	}; // function unityInitWithDomain

        if (!mimeTypes) {
          mimeTypes = null;
        }
        if (!iconUrl) {
          iconUrl = null;
        }

	if (domain == undefined) {
	  domain = document.domain;

	  unityInitWithDomain (domain);
	} else {
	  UnityContentScriptApi.getBaseDomain (document.location.href
		                               , function (currentBaseDomain) {
		                                 if ((domain.indexOf(currentBaseDomain,
					                             domain.length-currentBaseDomain.length) == -1)) {
			                           throw Error("invalid supplied domain "
                                                               + domain
                                                               + " does not have base suffix ("
                                                               + currentBaseDomain + ")");
		                                 }
			                         unityInitWithDomain (domain);
		                               });
	}
      }; // function unityInit

      function unityPrepareEnvironment (options) {
        UnityContentScriptApi.getTabInfo (function (environmentInfos) {
                                            logger ('Environment informations: '
                                                    + environmentInfos.windowId
                                                    + ', tabId: '
                                                    + environmentInfos.tabId);
                                            unityInit (options, environmentInfos);
                                          });
      };

      var CallbackManager = {
        releaseCallback: function (type) {
        },
        makeCallback: function (type, callback) {
          return callback;
        }
      };

      function acceptData(context, mimes, func) {
        uwa.context_set_application_accept_data(_global.context, mimes);
        _global.acceptDataCallback = func;
      }

      function contextAddApplicationActions(actions) {
        var appActions = [];
        for (var i = 0; i < actions.length; i++) {
          appActions.push({
                            path: actions[i].name
                            , callback: actions[i].callback
                          });
        }
        uwa.context_add_application_actions(_global.context, appActions, actions.length);
        actions = [];
      }

      return makeAPI (setTimeout
                      , contextAddApplicationActions
                      , unityPrepareEnvironment
                      , UnityContentScriptApi.toDataURL
                      , logger
                      , _uwa
                      , _global
                      , CallbackManager
                      , acceptData);
      
    } // function callback
    
    return callback;
    
  } // makeCallback: function
};

